/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.cf.smalivm.context.BaseState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassState
extends BaseState {
    private static final Logger log = LoggerFactory.getLogger(ClassState.class.getSimpleName());
    private final VirtualType virtualClass;

    public ClassState(VirtualType virtualClass, ExecutionContext context) {
        super(context, virtualClass.getFields().size());
        this.virtualClass = virtualClass;
    }

    private ClassState(ClassState parent, ExecutionContext context) {
        this(parent.virtualClass, context);
    }

    public void assignField(VirtualField field, Object value) {
        int register = 0;
        String heapId = this.getHeapId(field);
        String type = field.getType();
        this.assignRegister(register, new HeapItem(value, type), heapId);
    }

    public void assignField(VirtualField field, HeapItem item) {
        int register = 0;
        String heapId = this.getHeapId(field);
        this.assignRegister(register, item, heapId);
    }

    public ClassState getChild(ExecutionContext childContext) {
        return new ClassState(this, childContext);
    }

    public VirtualType getVirtualClass() {
        return this.virtualClass;
    }

    public int hashCode() {
        return new HashCodeBuilder(1337, 13).append(this.virtualClass).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClassState other = (ClassState)obj;
        return new EqualsBuilder().append(this.virtualClass, other.virtualClass).isEquals();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Fields:\n");
        for (VirtualField field : this.virtualClass.getFields()) {
            sb.append(field).append(" = ").append(this.peekField(field)).append('\n');
        }
        sb.setLength(sb.length() - 1);
        sb.append('\n');
        return sb.toString();
    }

    public HeapItem peekField(VirtualField field) {
        int register = 0;
        String heapId = this.getHeapId(field);
        HeapItem fieldItem = this.peekRegister(register, heapId);
        if (fieldItem == null) {
            log.error("Undefined field: {}; returning unknown", (Object)field);
            fieldItem = HeapItem.newUnknown(field.getType());
        }
        return fieldItem;
    }

    public void pokeField(VirtualField field, Object value) {
        int register = 0;
        String heapId = this.getHeapId(field);
        String type = field.getType();
        this.pokeRegister(register, new HeapItem(value, type), heapId);
    }

    public void pokeField(VirtualField field, HeapItem item) {
        int register = 0;
        String heapId = this.getHeapId(field);
        this.pokeRegister(register, item, heapId);
    }

    public void updateIdentities(VirtualField field, HeapItem item) {
        int register = 0;
        String heapId = this.getHeapId(field);
        String heapKey = heapId + ":" + register;
        this.updateKey(heapKey, item);
    }

    private String getHeapId(VirtualField field) {
        return field.toString();
    }
}

