/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseState {
    private static final Logger log = LoggerFactory.getLogger(BaseState.class.getSimpleName());
    private final int registerCount;
    private final TIntSet registersAssigned;
    private final TIntSet registersRead;
    private final ExecutionContext context;

    BaseState(BaseState parent, ExecutionContext context) {
        this.registerCount = parent.registerCount;
        this.registersAssigned = new TIntHashSet();
        this.registersRead = new TIntHashSet();
        this.context = context;
    }

    BaseState(ExecutionContext context) {
        this(context, 0);
    }

    BaseState(ExecutionContext context, int registerCount) {
        this.registersAssigned = new TIntHashSet();
        this.registersRead = new TIntHashSet();
        this.registerCount = registerCount;
        this.context = context;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public int[] getRegistersAssigned() {
        return this.registersAssigned.toArray();
    }

    public int[] getRegistersRead() {
        return this.registersRead.toArray();
    }

    public boolean wasRegisterAssigned(int register) {
        return this.registersAssigned.contains(register);
    }

    void assignRegister(int register, HeapItem item, String heapId) {
        this.registersAssigned.add(register);
        this.pokeRegister(register, item, heapId);
    }

    void assignRegisterAndUpdateIdentities(int register, HeapItem item, String heapId) {
        this.registersAssigned.add(register);
        this.context.getHeap().update(heapId, register, item);
    }

    void updateKey(String key, HeapItem item) {
        this.context.getHeap().update(key, item);
    }

    ExecutionContext getContext() {
        return this.context;
    }

    BaseState getParent() {
        ExecutionContext parentContext = this.context.getParent();
        MethodState parent = null;
        if (parentContext != null) {
            parent = parentContext.getMethodState();
        }
        return parent;
    }

    boolean hasRegister(int register, String heapId) {
        return this.context.getHeap().hasRegister(heapId, register);
    }

    HeapItem peekRegister(int register, String heapId) {
        return this.context.getHeap().get(heapId, register);
    }

    void pokeRegister(int register, HeapItem item, String heapId) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Setting ").append(heapId).append(':').append(register).append(" = ").append(item);
            log.trace(sb.toString());
        }
        this.context.getHeap().set(heapId, register, item);
    }

    HeapItem readRegister(int register, String heapId) {
        this.registersRead.add(register);
        return this.peekRegister(register, heapId);
    }

    void removeRegister(int register, String heapId) {
        this.context.getHeap().remove(heapId, register);
    }

    boolean wasRegisterRead(int register, String heapId) {
        if (this.registersRead.contains(register)) {
            return true;
        }
        HeapItem item = this.peekRegister(register, heapId);
        if (null == item) {
            return false;
        }
        for (int currentRegister : this.getRegistersRead()) {
            if (currentRegister == -1) continue;
            HeapItem currentItem = this.peekRegister(currentRegister, heapId);
            if (item.getValue() != currentItem.getValue()) continue;
            return true;
        }
        return false;
    }
}

