/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.configuration;

import java.util.HashSet;
import java.util.Set;
import org.cf.smalivm.configuration.ConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class.getSimpleName());
    public static final String IMMUTABLE_CLASSES_PATH = "immutable_classes.cfg";
    public static final String SAFE_CLASSES_PATH = "safe_classes.cfg";
    public static final String SAFE_METHODS_PATH = "safe_methods.cfg";
    public static final String UNSAFE_METHODS_PATH = "unsafe_methods.cfg";
    public static final String FRAMEWORK_CLASSES_PATH = "framework_classes.cfg";
    public static final String SAFE_FRAMEWORK_CLASSES_PATH = "safe_framework_classes.cfg";
    private static Configuration instance = null;
    private final Set<String> immutableClasses;
    private final Set<String> safeClasses = new HashSet<String>(ConfigurationLoader.load("safe_classes.cfg"));
    private final Set<String> safeMethods = new HashSet<String>(ConfigurationLoader.load("safe_methods.cfg"));
    private final Set<String> unsafeMethods = new HashSet<String>(ConfigurationLoader.load("unsafe_methods.cfg"));

    private Configuration() {
        this.immutableClasses = new HashSet<String>(ConfigurationLoader.load(IMMUTABLE_CLASSES_PATH));
    }

    public static Configuration instance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public Set<String> getImmutableClasses() {
        return this.immutableClasses;
    }

    public Set<String> getSafeClasses() {
        return this.safeClasses;
    }

    public boolean isImmutable(String className) {
        return this.immutableClasses.contains(className);
    }

    public boolean isMutable(String className) {
        return !this.isImmutable(className);
    }

    public boolean isSafe(String typeSignature) {
        String[] parts = typeSignature.split("->");
        String className = parts[0];
        if (this.safeClasses.contains(className) && !this.isUnsafeMethod(typeSignature)) {
            return true;
        }
        return parts.length > 1 && this.safeMethods.contains(typeSignature);
    }

    public boolean isUnsafeMethod(String methodDescriptor) {
        return this.unsafeMethods.contains(methodDescriptor);
    }
}

