/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.io.File;
import java.io.IOException;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.ClassManagerFactory;

public class VirtualMachineFactory {
    private static final int DEFAULT_MAX_ADDRESS_VISITS = 500;
    private static final int DEFAULT_MAX_CALL_DEPTH = 20;
    private static final int DEFAULT_MAX_EXECUTION_TIME = 300;
    private static final int DEFAULT_MAX_METHOD_VISITS = 1000000;

    public VirtualMachine build(ClassManager manager) {
        return new VirtualMachine(manager, 500, 20, 1000000, 300);
    }

    public VirtualMachine build(ClassManager manager, int maxAddressVisits, int maxCallDepth, int maxMethodVisits, int maxExecutionTime) {
        return new VirtualMachine(manager, maxAddressVisits, maxCallDepth, maxMethodVisits, maxExecutionTime);
    }

    public VirtualMachine build(File smaliPath, int outputAPILevel, int maxAddressVisits, int maxCallDepth, int maxMethodVisits, int maxExecutionTime) throws IOException {
        ClassManagerFactory factory = new ClassManagerFactory();
        ClassManager manager = factory.build(smaliPath, outputAPILevel);
        return new VirtualMachine(manager, maxAddressVisits, maxCallDepth, maxMethodVisits, maxExecutionTime);
    }

    public VirtualMachine build(File smaliPath) throws IOException {
        return this.build(smaliPath, 15, 500, 20, 1000000, 300);
    }

    public VirtualMachine build(String smaliPath) throws IOException {
        return this.build(smaliPath, 15);
    }

    public VirtualMachine build(String smaliPath, int outputAPILevel) throws IOException {
        return this.build(smaliPath, outputAPILevel, 500, 20, 1000000, 300);
    }

    public VirtualMachine build(String smaliPath, int outputAPILevel, int maxAddressVisits, int maxCallDepth, int maxMethodVisits, int maxExecutionTime) throws IOException {
        return this.build(new File(smaliPath), outputAPILevel, maxAddressVisits, maxCallDepth, maxMethodVisits, maxExecutionTime);
    }
}

