/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ClassState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.type.VirtualField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFieldAccessor {
    private static Logger log = LoggerFactory.getLogger(StaticFieldAccessor.class.getSimpleName());
    private final VirtualMachine vm;

    StaticFieldAccessor(VirtualMachine vm) {
        this.vm = vm;
    }

    public HeapItem getField(ExecutionContext context, VirtualField field) {
        if (this.isSafe(field)) {
            return this.getSafeField(field);
        }
        return this.getLocalField(context, field);
    }

    private HeapItem getLocalField(ExecutionContext context, VirtualField field) {
        ClassState cState = context.readClassState(field.getDefiningClass());
        return cState.peekField(field);
    }

    private HeapItem getSafeField(VirtualField field) {
        String className = field.getDefiningClass().getBinaryName();
        try {
            Class<?> klazz = Class.forName(className);
            Field realField = FieldUtils.getField(klazz, field.getName());
            Object fieldValue = realField.get(null);
            return new HeapItem(fieldValue, field.getType());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            if (log.isWarnEnabled()) {
                log.warn("Couldn't access field: {}", (Object)field.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug("Stack trace:", e);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Could not find class : {}", (Object)className);
        }
        return HeapItem.newUnknown(field.getType());
    }

    private boolean isSafe(VirtualField field) {
        return this.vm.isSafe(field.getDefiningClass());
    }

    public void putField(ExecutionContext context, VirtualField field, HeapItem putItem) {
        if (this.isSafe(field)) {
            if (log.isWarnEnabled()) {
                log.warn("Ignoring static assignment of non-local field: {} = {}", (Object)field, (Object)putItem);
            }
        } else {
            ClassState cState = context.readClassState(field.getDefiningClass());
            cState.assignField(field, putItem);
        }
    }
}

