/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import com.google.common.base.Defaults;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInstantiator {
    private static final Logger log = LoggerFactory.getLogger(ObjectInstantiator.class.getSimpleName());

    public static Object newInstance(Class<?> klazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object newInstance;
        if (Enum.class.isAssignableFrom(klazz)) {
            return ObjectInstantiator.newEnumInstance(klazz);
        }
        try {
            newInstance = klazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            if (log.isTraceEnabled()) {
                log.trace("{} has no default constructor, picking another", (Object)klazz);
            }
            Constructor<?>[] ctors = klazz.getDeclaredConstructors();
            Constructor<?> ctor = ctors[0];
            ctor.setAccessible(true);
            Object[] args = new Object[ctor.getParameterCount()];
            Class<?>[] parameterTypes = ctor.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                args[i] = Defaults.defaultValue(parameterType);
            }
            newInstance = ctor.newInstance(args);
        }
        return newInstance;
    }

    private static Object newEnumInstance(Class<?> klazz) {
        return Enum.valueOf(klazz, "$shadow_instance");
    }
}

