/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import org.cf.smalivm.ExceptionHandlerAddressResolver;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.exception.UnhandledVirtualException;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.ClassManager;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeExecutor {
    private static Logger log = LoggerFactory.getLogger(NodeExecutor.class.getSimpleName());
    private final ExecutionGraph graph;
    private final ExceptionHandlerAddressResolver exceptionResolver;

    public NodeExecutor(ExecutionGraph graph, ClassManager classManager) {
        this.graph = graph;
        this.exceptionResolver = new ExceptionHandlerAddressResolver(classManager, graph.getMethod());
    }

    private static ExecutionNode spawnChild(ExecutionGraph graph, ExecutionNode parentNode, int childAddress) {
        Op childOp = graph.getTemplateNode(childAddress).getOp();
        ExecutionNode childNode = parentNode.spawnChild(childOp);
        graph.addNode(childNode);
        return childNode;
    }

    private static void spawnChildren(ExecutionGraph graph, ExecutionNode parentNode) {
        for (MethodLocation childLocation : parentNode.getChildLocations()) {
            NodeExecutor.spawnChild(graph, parentNode, childLocation.getCodeAddress());
        }
    }

    private static void spawnExceptionChildren(ExecutionGraph graph, ExecutionNode node, ExceptionHandlerAddressResolver exceptionResolver) throws UnhandledVirtualException {
        if (node.mayThrowException()) {
            for (Throwable exception : node.getExceptions()) {
                int childAddress;
                if (log.isTraceEnabled()) {
                    log.trace("{} may throw virtual exception: ", (Object)node, (Object)exception);
                }
                if ((childAddress = exceptionResolver.resolve(exception, node.getAddress())) >= 0) {
                    ExecutionNode childNode = NodeExecutor.spawnChild(graph, node, childAddress);
                    childNode.getContext().getMethodState().assignExceptionRegister(exception);
                    continue;
                }
                if (node.getChildLocations().length == 0) {
                    if (log.isErrorEnabled()) {
                        log.error("{} unhandled virtual exception: ", (Object)node, (Object)exception);
                    }
                    throw new UnhandledVirtualException(exception);
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("{} possible unhandled virtual exception: ", (Object)node, (Object)exception);
            }
        }
    }

    public void execute(ExecutionNode node) throws UnhandledVirtualException {
        if (log.isDebugEnabled()) {
            Op op = node.getOp();
            log.debug("Handling @{}: {}", (Object)op.getAddress(), (Object)op);
            if (log.isTraceEnabled()) {
                log.trace("Context before:\n{}", (Object)node.getContext().toString(false));
            }
        }
        try {
            node.execute();
        }
        catch (Exception e) {
            int childAddress = this.exceptionResolver.resolve(e, node.getAddress());
            if (childAddress <= 0) {
                throw new RuntimeException("Real exception was thrown executing " + node + " and was not handled. This could be a bug in smalivm.", e);
            }
            if (log.isWarnEnabled()) {
                log.warn("{} threw a real exception but was caught by an exception handler. This may be a bug in smalivm or in the input code. Exception: ", (Object)node, (Object)e);
            }
            NodeExecutor.spawnChild(this.graph, node, childAddress);
        }
        NodeExecutor.spawnChildren(this.graph, node);
        NodeExecutor.spawnExceptionChildren(this.graph, node, this.exceptionResolver);
        if (log.isDebugEnabled()) {
            log.debug("Context after:\n{}", (Object)node.getContext());
        }
    }
}

