/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.util.ClassNameUtils;
import org.cf.util.EnumAnalyzer;
import org.cf.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodReflector {
    private static Logger log = LoggerFactory.getLogger(MethodReflector.class.getSimpleName());
    private static final String ENUM_INIT_SIGNATURE = "Ljava/lang/Enum;-><init>(Ljava/lang/String;";
    private final VirtualMachine vm;
    private final VirtualMethod method;
    private final EnumAnalyzer enumAnalyzer;

    public MethodReflector(VirtualMachine vm, VirtualMethod method) {
        this.vm = vm;
        this.method = method;
        this.enumAnalyzer = new EnumAnalyzer(vm);
    }

    public void reflect(MethodState mState) throws Exception {
        Object returnValue;
        if (log.isDebugEnabled()) {
            log.debug("Reflecting {} with context:\n{}", (Object)this.method, (Object)mState);
        }
        try {
            returnValue = this.invoke(mState);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e) {
            if (log.isWarnEnabled()) {
                log.warn("Failed to reflect {}: ", (Object)this.method, (Object)e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Stack trace: ", e);
            }
            throw e;
        }
        if (!this.method.returnsVoid()) {
            HeapItem returnItem = returnValue != null && !ClassNameUtils.isPrimitive(this.method.getReturnType()) ? new HeapItem(returnValue, ClassNameUtils.toInternal(returnValue.getClass())) : new HeapItem(returnValue, this.method.getReturnType());
            mState.assignReturnRegister(returnItem);
        }
    }

    public String toString() {
        return "MethodReflector{" + this.method + ", static=" + this.method.isStatic() + "}";
    }

    private InvocationArguments getArguments(MethodState mState) throws ClassNotFoundException {
        String parameterTypeName;
        int paramOffset = 0;
        if (!this.method.isStatic()) {
            paramOffset = 1;
        }
        List<String> parameterTypeNames = this.method.getParameterTypeNames();
        int size = parameterTypeNames.size() - paramOffset;
        Object[] args = new Object[size];
        Class[] parameterTypes = new Class[size];
        int registerCount = mState.getRegisterCount();
        for (int i = paramOffset; i < registerCount; i += Utils.getRegisterSize(parameterTypeName)) {
            HeapItem argItem = mState.peekParameter(i);
            args[i - paramOffset] = argItem.getValue();
            parameterTypeName = parameterTypeNames.get(i);
            Class<?> parameterType = argItem.isPrimitive() ? ClassNameUtils.getPrimitiveClass(parameterTypeName) : Class.forName(ClassNameUtils.internalToBinary(parameterTypeName));
            parameterTypes[i - paramOffset] = parameterType;
        }
        return new InvocationArguments(args, parameterTypes);
    }

    private Object invoke(MethodState mState) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object returnValue;
        Class<?> klazz = Class.forName(this.method.getBinaryClassName());
        InvocationArguments invocationArgs = this.getArguments(mState);
        Object[] args = invocationArgs.getArgs();
        Class<?>[] parameterTypes = invocationArgs.getParameterTypes();
        if (this.method.isStatic()) {
            if (log.isDebugEnabled()) {
                log.debug("Reflecting static {}, clazz={} args={}", this.method, klazz, Arrays.toString(args));
            }
            returnValue = MethodUtils.invokeStaticMethod(klazz, this.method.getName(), args, parameterTypes);
        } else if ("<init>".equals(this.method.getName())) {
            if (log.isDebugEnabled()) {
                log.debug("Reflecting construction {}, class={} args={}", this.method, klazz, Arrays.toString(args));
            }
            returnValue = this.method.getSignature().startsWith(ENUM_INIT_SIGNATURE) ? this.invokeEnumInit(mState, (String)args[0], this.vm.getClassLoader()) : ConstructorUtils.invokeConstructor(klazz, args);
            HeapItem instanceItem = new HeapItem(returnValue, ClassNameUtils.toInternal(returnValue.getClass()));
            mState.assignParameter(0, instanceItem);
        } else {
            HeapItem targetItem = mState.peekRegister(0);
            if (log.isDebugEnabled()) {
                log.debug("Reflecting virtual {}, target={} args={}", this.method, targetItem, Arrays.toString(args));
            }
            Object value = targetItem.getValue();
            returnValue = MethodUtils.invokeMethod(value, this.method.getName(), args, parameterTypes);
        }
        return returnValue;
    }

    private Object invokeEnumInit(MethodState mState, String name, ClassLoader classLoader) throws ClassNotFoundException {
        HeapItem instance = mState.peekParameter(mState.getParameterStart());
        String enumType = ClassNameUtils.internalToSource(instance.getType());
        Class<?> enumClass = classLoader.loadClass(enumType);
        try {
            return Enum.valueOf(enumClass, name);
        }
        catch (IllegalArgumentException e) {
            this.enumAnalyzer.analyze(enumClass);
            name = this.enumAnalyzer.getObfuscatedName(name);
            return Enum.valueOf(enumClass, name);
        }
    }

    private static class InvocationArguments {
        private Object[] args;
        private Class<?>[] parameterTypes;

        InvocationArguments(Object[] args, Class<?>[] parameterTypes) {
            this.args = args;
            this.parameterTypes = parameterTypes;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }
    }
}

