/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.lang.reflect.Constructor;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.opcode.Op;
import org.cf.util.ClassNameUtils;

public class ExceptionFactory {
    private final VirtualMachine vm;

    ExceptionFactory(VirtualMachine vm) {
        this.vm = vm;
    }

    public Throwable build(Op op, String className) {
        return this.build(op, className, null);
    }

    public Throwable build(Op op, Class<? extends Throwable> exceptionClass) {
        return this.build(op, exceptionClass, null);
    }

    public Throwable build(Op op, Class<? extends Throwable> exceptionClass, String message) {
        try {
            Constructor<? extends Throwable> ctor = exceptionClass.getDeclaredConstructor(String.class);
            ctor.setAccessible(true);
            return ctor.newInstance(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Exception();
        }
    }

    public Throwable build(Op op, String className, String message) {
        String binaryName = ClassNameUtils.internalToBinary(className);
        try {
            Class<?> exceptionClass = this.vm.getClassLoader().loadClass(binaryName);
            return this.build(op, exceptionClass, message);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Exception();
        }
    }
}

