/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SimplifyOptions
implements Serializable {
    private static final byte[] DEX_MAGIC = new byte[]{100, 101, 120};
    private static final byte[] PK_ZIP_MAGIC = new byte[]{80, 75, 3};
    private static final long serialVersionUID = -8592147369856820020L;
    private Pattern excludeFilter;
    private boolean help;
    private boolean ignoreErrors;
    private Pattern includeFilter;
    private boolean includeSupportLibrary;
    private File inFile;
    private InputType inputType;
    private int maxAddressVisits = 10000;
    private int maxCallDepth = 50;
    private int maxExecutionTime = 300;
    private int maxMethodVisits = 1000000;
    private int maxOptimizationPasses = 100;
    private File outDexFile;
    private File outFile;
    private int outputAPILevel = 15;
    private boolean quiet;
    private boolean removeWeak = true;
    private int verbosity = 0;

    public Pattern getExcludeFilter() {
        return this.excludeFilter;
    }

    protected void setExcludeFilter(Pattern excludeFilter) {
        this.excludeFilter = excludeFilter;
    }

    public Pattern getIncludeFilter() {
        return this.includeFilter;
    }

    protected void setIncludeFilter(Pattern includeFilter) {
        this.includeFilter = includeFilter;
    }

    public File getInFile() {
        return this.inFile;
    }

    void setInFile(File inFile) {
        this.inFile = inFile;
        try {
            this.inputType = this.determineInputType();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMaxAddressVisits() {
        return this.maxAddressVisits;
    }

    protected void setMaxAddressVisits(int maxAddressVisits) {
        this.maxAddressVisits = maxAddressVisits;
    }

    public int getMaxCallDepth() {
        return this.maxCallDepth;
    }

    protected void setMaxCallDepth(int maxCallDepth) {
        this.maxCallDepth = maxCallDepth;
    }

    public int getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    protected void setMaxExecutionTime(int maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    public int getMaxMethodVisits() {
        return this.maxMethodVisits;
    }

    protected void setMaxMethodVisits(int maxMethodVisits) {
        this.maxMethodVisits = maxMethodVisits;
    }

    public int getMaxOptimizationPasses() {
        return this.maxOptimizationPasses;
    }

    protected void setMaxOptimizationPasses(int maxOptimizationPasses) {
        this.maxOptimizationPasses = maxOptimizationPasses;
    }

    public File getOutDexFile() {
        return this.outDexFile;
    }

    public File getOutFile() {
        return this.outFile;
    }

    void setOutFile(File outFile) {
        this.outFile = outFile;
        if (this.isZip()) {
            try {
                this.outDexFile = File.createTempFile("simplify", "dex");
                this.outDexFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create temporary dex file:\n" + e);
            }
        } else {
            this.outDexFile = outFile;
        }
    }

    public int getOutputAPILevel() {
        return this.outputAPILevel;
    }

    protected void setOutputAPILevel(int outputAPILevel) {
        this.outputAPILevel = outputAPILevel;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    protected void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public boolean includeSupportLibrary() {
        return this.includeSupportLibrary;
    }

    public boolean isDex() {
        return InputType.DEX.equals((Object)this.inputType);
    }

    public boolean isDirectory() {
        return InputType.DIRECTORY.equals((Object)this.inputType);
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isRemoveWeak() {
        return this.removeWeak;
    }

    protected void setRemoveWeak(boolean removeWeak) {
        this.removeWeak = removeWeak;
    }

    public boolean isZip() {
        return InputType.ZIP.equals((Object)this.inputType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Input file: ").append(this.getInFile()).append('\n');
        sb.append("Output file: ").append(this.getOutFile()).append('\n');
        sb.append("Include filter: ").append(this.getIncludeFilter()).append('\n');
        sb.append("Exclude filter: ").append(this.getExcludeFilter()).append('\n');
        sb.append("Max execution time: ").append(this.getMaxExecutionTime()).append('\n');
        sb.append("Max address visits: ").append(this.getMaxAddressVisits()).append('\n');
        sb.append("Max call depth: ").append(this.getMaxCallDepth()).append('\n');
        sb.append("Max method visits: ").append(this.getMaxMethodVisits()).append('\n');
        sb.append("Max optimization passes: ").append(this.getMaxOptimizationPasses()).append('\n');
        sb.append("Output API level: ").append(this.getOutputAPILevel()).append('\n');
        sb.append("Include support library: ").append(this.includeSupportLibrary).append('\n');
        return sb.toString().trim();
    }

    protected void setIncludeSupportLibrary(boolean includeSupportLibrary) {
        this.includeSupportLibrary = includeSupportLibrary;
    }

    protected void setIsHelp() {
        this.help = true;
    }

    protected void setIgnoreErrors() {
        this.ignoreErrors = true;
    }

    protected void setIsQuiet() {
        this.quiet = true;
    }

    private InputType determineInputType() throws IOException {
        if (this.inFile.isDirectory()) {
            return InputType.DIRECTORY;
        }
        byte[] buf = new byte[3];
        try (FileInputStream fis = new FileInputStream(this.inFile);){
            fis.read(buf);
        }
        if (Arrays.equals(DEX_MAGIC, buf)) {
            return InputType.DEX;
        }
        if (Arrays.equals(PK_ZIP_MAGIC, buf)) {
            return InputType.ZIP;
        }
        throw new RuntimeException("Unknown input file type; magic: " + Arrays.toString(buf));
    }

    private static enum InputType {
        DEX,
        DIRECTORY,
        ZIP;

    }
}

