/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cf.simplify.ExecutionGraphManipulator;
import org.cf.simplify.SimplifyOptions;
import org.cf.simplify.strategy.ConstantPropagationStrategy;
import org.cf.simplify.strategy.DeadRemovalStrategy;
import org.cf.simplify.strategy.OptimizationStrategy;
import org.cf.simplify.strategy.PeepholeStrategy;
import org.cf.simplify.strategy.UnreflectionStrategy;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.type.VirtualMethod;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimizer {
    private static final Logger log = LoggerFactory.getLogger(Optimizer.class.getSimpleName());
    private static final Map<String, Integer> totalOptimizationCounts = new HashMap<String, Integer>();
    private final ExecutionGraphManipulator manipulator;
    private final VirtualMethod method;
    private final List<OptimizationStrategy> reoptimizeStrategies;
    private final List<OptimizationStrategy> reexecuteStrategies;
    private final List<OptimizationStrategy> allStrategies;
    private boolean madeAnyChanges;
    private boolean shouldReexecute;
    private Map<String, Integer> optimizationCounts;

    public Optimizer(ExecutionGraph graph, VirtualMethod method, VirtualMachine vm, DexBuilder dexBuilder, SimplifyOptions opts) {
        this.manipulator = new ExecutionGraphManipulator(graph, method, vm, dexBuilder);
        this.method = method;
        this.reoptimizeStrategies = new LinkedList<OptimizationStrategy>();
        DeadRemovalStrategy strategy = new DeadRemovalStrategy(this.manipulator);
        strategy.setRemoveWeak(opts.isRemoveWeak());
        this.reoptimizeStrategies.add(strategy);
        this.reoptimizeStrategies.add(new ConstantPropagationStrategy(this.manipulator));
        this.reoptimizeStrategies.add(new PeepholeStrategy(this.manipulator));
        this.reexecuteStrategies = new LinkedList<OptimizationStrategy>();
        this.reexecuteStrategies.add(new UnreflectionStrategy(this.manipulator));
        this.allStrategies = new LinkedList<OptimizationStrategy>();
        this.allStrategies.addAll(this.reoptimizeStrategies);
        this.allStrategies.addAll(this.reexecuteStrategies);
        this.optimizationCounts = new HashMap<String, Integer>();
    }

    public static String getTotalOptimizationCounts() {
        return "Total optimizations:\n" + Optimizer.buildOptimizationCounts(totalOptimizationCounts);
    }

    private static StringBuilder buildOptimizationCounts(Map<String, Integer> counts) {
        LinkedList<String> keys = new LinkedList<String>(counts.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append('\t').append(key).append(" = ").append(counts.get(key)).append("\n");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    public String getOptimizationCounts() {
        StringBuilder sb = new StringBuilder("Optimizations:\n");
        sb.append((CharSequence)Optimizer.buildOptimizationCounts(this.optimizationCounts));
        return sb.toString();
    }

    public boolean madeChanges() {
        return this.madeAnyChanges;
    }

    public boolean shouldReexecute() {
        return this.shouldReexecute;
    }

    public void simplify(int maxPasses) {
        boolean madeChange;
        System.out.println("Simplifying: " + this.method);
        int pass = 0;
        this.madeAnyChanges = false;
        do {
            madeChange = false;
            for (OptimizationStrategy strategy : this.reoptimizeStrategies) {
                madeChange |= strategy.perform();
            }
            for (OptimizationStrategy strategy : this.reexecuteStrategies) {
                this.shouldReexecute |= strategy.perform();
            }
            this.madeAnyChanges |= madeChange | this.shouldReexecute;
        } while (madeChange && ++pass < maxPasses);
        this.updateOptimizationCounts();
    }

    private void updateOptimizationCounts() {
        for (OptimizationStrategy strategy : this.allStrategies) {
            Map<String, Integer> optimizations = strategy.getOptimizationCounts();
            for (Map.Entry<String, Integer> entry : optimizations.entrySet()) {
                Integer totalCount;
                String key = entry.getKey();
                Integer currentCount = this.optimizationCounts.get(key);
                if (null == currentCount) {
                    currentCount = 0;
                }
                if (null == (totalCount = totalOptimizationCounts.get(key))) {
                    totalCount = 0;
                }
                int count = entry.getValue();
                currentCount = currentCount + count;
                this.optimizationCounts.put(key, currentCount);
                totalCount = totalCount + count;
                totalOptimizationCounts.put(key, totalCount);
            }
        }
    }
}

