/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.cf.simplify.Main;
import org.cf.simplify.Optimizer;
import org.cf.simplify.SimplifyOptions;
import org.cf.simplify.SimplifyOptionsParser;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.VirtualMachineFactory;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.exception.UnhandledVirtualException;
import org.cf.smalivm.exception.VirtualMachineException;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualMethod;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.util.ConsoleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Logger log = LoggerFactory.getLogger(Main.class.getSimpleName());
    private static final Pattern SUPPORT_LIBRARY_PATTERN = Pattern.compile("Landroid/support/(annotation|design|v\\d{1,2})/");
    private final VirtualMachineFactory vmFactory;
    private SimplifyOptions opts;
    private VirtualMachine vm;

    public Launcher(VirtualMachineFactory vmFactory) {
        this.vmFactory = vmFactory;
    }

    private static void filterMethods(Collection<VirtualMethod> methods, Pattern positive, Pattern negative) {
        Iterator<VirtualMethod> it = methods.iterator();
        while (it.hasNext()) {
            String name = it.next().getSignature();
            if (positive != null && !positive.matcher(name).find()) {
                it.remove();
                continue;
            }
            if (negative == null || !negative.matcher(name).find()) continue;
            it.remove();
        }
    }

    private static void filterSupportLibrary(Collection<String> classNames) {
        classNames.removeIf(name -> SUPPORT_LIBRARY_PATTERN.matcher((CharSequence)name).find());
    }

    private static SimplifyOptions getOptions(String[] args) {
        SimplifyOptions opts = null;
        try {
            opts = SimplifyOptionsParser.parse(args);
        }
        catch (ParseException e) {
            Launcher.usage(SimplifyOptionsParser.getOptions());
            System.exit(-1);
        }
        if (opts.isHelp()) {
            Launcher.usage(SimplifyOptionsParser.getOptions());
            System.exit(0);
        }
        return opts;
    }

    private static void setLogLevel(SimplifyOptions bean) {
        if (bean.isQuiet()) {
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            rootLogger.setLevel(Level.OFF);
            return;
        }
        if (bean.getVerbosity() == 1) {
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            rootLogger.setLevel(Level.INFO);
        } else if (bean.getVerbosity() == 2) {
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            rootLogger.setLevel(Level.DEBUG);
        } else if (bean.getVerbosity() == 3) {
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            rootLogger.setLevel(Level.TRACE);
        }
    }

    private static void updateZip(File zip, File entry, String entryName) throws IOException {
        HashMap env = new HashMap();
        String uriPath = "jar:" + zip.toURI().toString();
        URI uri = URI.create(uriPath);
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            fs.provider().checkAccess(fs.getPath(entryName, new String[0]), AccessMode.READ);
            Path target = fs.getPath(entryName, new String[0]);
            Path source = entry.toPath();
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        formatter.setWidth(consoleWidth);
        formatter.printHelp("java -jar simplify.jar <input> [options]", "deobfuscates a dalvik executable", options, "");
    }

    public void run(String[] args) throws IOException, UnhandledVirtualException {
        this.opts = Launcher.getOptions(args);
        Launcher.setLogLevel(this.opts);
        log.info("Options:\n{}", (Object)this.opts.toString());
        RuntimeStats stats = new RuntimeStats();
        stats.begin();
        this.vm = this.vmFactory.build(this.opts.getInFile(), this.opts.getOutputAPILevel(), this.opts.getMaxAddressVisits(), this.opts.getMaxCallDepth(), this.opts.getMaxMethodVisits(), this.opts.getMaxExecutionTime());
        ClassManager classManager = this.vm.getClassManager();
        Map<String, Collection<VirtualMethod>> targetClassNameToMethods = Launcher.collectTargetClassNameToMethods(classManager, this.opts);
        stats.startClasses(targetClassNameToMethods.keySet());
        for (Map.Entry<String, Collection<VirtualMethod>> entry : targetClassNameToMethods.entrySet()) {
            stats.incrementCurrentClassIndex();
            String className = entry.getKey();
            Collection<VirtualMethod> methods = entry.getValue();
            System.out.println("[" + stats.getCurrentClassIndex() + " / " + stats.getTotalClasses() + "] Processing top level class " + className);
            this.executeMethods(methods, classManager, stats);
        }
        stats.end();
        System.out.println("Simplification complete:\n" + stats.getStats());
        System.out.println(Optimizer.getTotalOptimizationCounts());
        System.out.println("Writing output to " + this.opts.getOutFile());
        classManager.getDexBuilder().writeTo(new FileDataStore(this.opts.getOutDexFile()));
        if (this.opts.isZip()) {
            Files.copy(this.opts.getInFile().toPath(), this.opts.getOutFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            Launcher.updateZip(this.opts.getOutFile(), this.opts.getOutDexFile(), "classes.dex");
        }
    }

    private static Map<String, Collection<VirtualMethod>> collectTargetClassNameToMethods(ClassManager classManager, SimplifyOptions opts) {
        Set<String> classNames = classManager.getNonFrameworkClassNames();
        if (!opts.includeSupportLibrary()) {
            int beforeCount = classNames.size();
            Launcher.filterSupportLibrary(classNames);
            log.info("Filtered {} support library classes", (Object)(beforeCount - classNames.size()));
        }
        HashMap<String, Collection<VirtualMethod>> classNameToMethods = new HashMap<String, Collection<VirtualMethod>>();
        for (String className : classNames) {
            Collection<VirtualMethod> methods = classManager.getVirtualClass(className).getMethods();
            Launcher.filterMethods(methods, opts.getIncludeFilter(), opts.getExcludeFilter());
            if (methods.isEmpty()) continue;
            classNameToMethods.put(className, methods);
        }
        return classNameToMethods;
    }

    private void executeMethods(Collection<VirtualMethod> methods, ClassManager classManager, RuntimeStats stats) {
        DexBuilder dexBuilder = classManager.getDexBuilder();
        stats.startMethods(methods);
        for (VirtualMethod method : methods) {
            Optimizer optimizer;
            boolean executeAgain;
            stats.incrementCurrentMethodIndex();
            if (!method.hasImplementation()) {
                System.out.println("[" + stats.getCurrentMethodIndex() + " / " + stats.getTotalMethods() + "] Skipping top level method without implementation: " + method);
                continue;
            }
            do {
                System.out.println("(" + stats.getCurrentMethodIndex() + " / " + stats.getTotalMethods() + ") Executing top level method: " + method);
                ExecutionGraph graph = null;
                try {
                    graph = this.vm.execute(method);
                }
                catch (VirtualMachineException e) {
                    System.err.println("Aborting execution; exception: " + e);
                }
                catch (Throwable e1) {
                    if (this.opts.ignoreErrors()) {
                        System.err.println("Unexpected, non-virtual exception executing " + method + "; skipping");
                        e1.printStackTrace();
                        stats.incrementFailedMethodCount();
                        this.vm = this.vmFactory.build(classManager, this.opts.getMaxAddressVisits(), this.opts.getMaxCallDepth(), this.opts.getMaxMethodVisits(), this.opts.getMaxExecutionTime());
                        break;
                    }
                    throw e1;
                }
                if (null == graph) {
                    System.out.println("Skipping optimization of " + method + "; null execution graph");
                    stats.incrementFailedMethodCount();
                    break;
                }
                optimizer = new Optimizer(graph, method, this.vm, dexBuilder, this.opts);
                try {
                    optimizer.simplify(this.opts.getMaxOptimizationPasses());
                }
                catch (Throwable e1) {
                    if (this.opts.ignoreErrors()) {
                        System.err.println("Exception optimizing " + method + ", skipping");
                        e1.printStackTrace();
                        stats.incrementFailedMethodCount();
                        this.vm = this.vmFactory.build(classManager, this.opts.getMaxAddressVisits(), this.opts.getMaxCallDepth(), this.opts.getMaxMethodVisits(), this.opts.getMaxExecutionTime());
                        break;
                    }
                    throw e1;
                }
                if (optimizer.madeChanges()) {
                    this.vm.updateInstructionGraph(method);
                }
                System.out.println(optimizer.getOptimizationCounts());
            } while (executeAgain = optimizer.shouldReexecute());
            stats.incrementOptimizedMethodCount();
        }
    }

    private class RuntimeStats {
        int totalClasses;
        int totalMethods;
        int currentClassIndex;
        int currentMethodIndex;
        int failedMethodCount;
        int optimizedMethodCount;
        long startTime;
        long endTime;

        RuntimeStats() {
        }

        void startClasses(Collection classes) {
            this.currentClassIndex = 0;
            this.totalClasses = classes.size();
        }

        void startMethods(Collection methods) {
            this.currentMethodIndex = 0;
            this.totalMethods = methods.size();
        }

        void incrementCurrentClassIndex() {
            ++this.currentClassIndex;
        }

        void incrementCurrentMethodIndex() {
            ++this.currentMethodIndex;
        }

        void incrementOptimizedMethodCount() {
            ++this.optimizedMethodCount;
        }

        void incrementFailedMethodCount() {
            ++this.failedMethodCount;
        }

        void begin() {
            this.startTime = System.currentTimeMillis();
        }

        void end() {
            this.endTime = System.currentTimeMillis();
        }

        String getStats() {
            long totalTime = this.endTime - this.startTime;
            return "\ttotal classes = " + this.totalClasses + "\n\ttotal methods = " + this.totalMethods + "\n\toptimized methods = " + this.optimizedMethodCount + "\n\tfailed methods = " + this.failedMethodCount + "\n\trun time = " + totalTime + " ms";
        }

        int getTotalClasses() {
            return this.totalClasses;
        }

        int getTotalMethods() {
            return this.totalMethods;
        }

        int getCurrentClassIndex() {
            return this.currentClassIndex;
        }

        int getCurrentMethodIndex() {
            return this.currentMethodIndex;
        }

        int getFailedMethodCount() {
            return this.failedMethodCount;
        }

        int getOptimizedMethodCount() {
            return this.optimizedMethodCount;
        }
    }
}

