/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.Segmentation;

public class SegmentationImpl
extends AbstractParameter
implements Segmentation {
    private static final int _TRUE = 1;
    private static final int _FALSE = 0;
    private boolean firstSegIndication = false;
    private boolean class1Selected = false;
    private byte remainingSegments = (byte)15;
    private int segmentationLocalRef;

    public SegmentationImpl() {
    }

    public SegmentationImpl(boolean firstSegIndication, boolean class1Selected, byte remainingSegments, int segmentationLocalRef) {
        this.firstSegIndication = firstSegIndication;
        this.class1Selected = class1Selected;
        this.remainingSegments = remainingSegments;
        this.segmentationLocalRef = segmentationLocalRef;
    }

    public boolean isFirstSegIndication() {
        return this.firstSegIndication;
    }

    public void setFirstSegIndication(boolean firstSegIndication) {
        this.firstSegIndication = firstSegIndication;
    }

    public boolean isClass1Selected() {
        return this.class1Selected;
    }

    public void setClass1Selected(boolean class1Selected) {
        this.class1Selected = class1Selected;
    }

    public byte getRemainingSegments() {
        return this.remainingSegments;
    }

    public void setRemainingSegments(byte remainingSegments) {
        if (remainingSegments < 0 || remainingSegments > 15) {
            throw new IllegalArgumentException("Wrong value of remaining segments: " + remainingSegments);
        }
        this.remainingSegments = remainingSegments;
    }

    public int getSegmentationLocalRef() {
        return this.segmentationLocalRef;
    }

    public void setSegmentationLocalRef(int segmentationLocalRef) {
        this.segmentationLocalRef = segmentationLocalRef;
    }

    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[in.read()];
            if (in.read(buffer) != buffer.length) {
                throw new ParseException();
            }
            this.decode(buffer, factory, sccpProtocolVersion);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = this.encode(removeSpc, sccpProtocolVersion);
            os.write(buffer.length);
            os.write(buffer);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void decode(byte[] buffer, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        byte v = buffer[0];
        this.firstSegIndication = (v >> 7 & 1) == 1;
        this.class1Selected = (v >> 6 & 1) == 1;
        this.remainingSegments = (byte)(v & 0xF);
        this.segmentationLocalRef = (buffer[1] & 0xFF) + ((buffer[2] & 0xFF) << 8) + ((buffer[3] & 0xFF) << 16);
    }

    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        byte[] buffer = new byte[4];
        int v = this.remainingSegments & 0xF;
        v |= (this.class1Selected ? 1 : 0) << 6;
        buffer[0] = (byte)(v |= (this.firstSegIndication ? 1 : 0) << 7);
        buffer[1] = (byte)(this.segmentationLocalRef & 0xFF);
        buffer[2] = (byte)(this.segmentationLocalRef >> 8 & 0xFF);
        buffer[3] = (byte)(this.segmentationLocalRef >> 16 & 0xFF);
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Segmentation [remainingSegments=");
        sb.append(this.getRemainingSegments());
        if (this.isFirstSegIndication()) {
            sb.append(" firstSegment");
        }
        if (this.isClass1Selected()) {
            sb.append(" class1Selected");
        }
        sb.append(" localRef=");
        sb.append(this.getSegmentationLocalRef());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.class1Selected ? 1231 : 1237);
        result = 31 * result + (this.firstSegIndication ? 1231 : 1237);
        result = 31 * result + this.remainingSegments;
        result = 31 * result + this.segmentationLocalRef;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentationImpl other = (SegmentationImpl)obj;
        if (this.class1Selected != other.class1Selected) {
            return false;
        }
        if (this.firstSegIndication != other.firstSegIndication) {
            return false;
        }
        if (this.remainingSegments != other.remainingSegments) {
            return false;
        }
        return this.segmentationLocalRef == other.segmentationLocalRef;
    }
}

