/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientInternalID;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSStatus;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExternalClient;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LCSPrivacyClass;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.NotificationToMSUser;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ServiceType;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtSSStatusImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExternalClientImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ServiceTypeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCSPrivacyClassImpl
extends SequenceBase
implements LCSPrivacyClass {
    private static final int _TAG_notificationToMSUser = 0;
    private static final int _TAG_externalClientList = 1;
    private static final int _TAG_plmnClientList = 2;
    private static final int _TAG_extensionContainer = 3;
    private static final int _TAG_extExternalClientList = 4;
    private static final int _TAG_serviceTypeList = 5;
    private SSCode ssCode;
    private ExtSSStatus ssStatus;
    private NotificationToMSUser notificationToMSUser;
    private ArrayList<ExternalClient> externalClientList;
    private ArrayList<LCSClientInternalID> plmnClientList;
    private MAPExtensionContainer extensionContainer;
    private ArrayList<ExternalClient> extExternalClientList;
    private ArrayList<ServiceType> serviceTypeList;

    public LCSPrivacyClassImpl() {
        super("LCSPrivacyClass");
    }

    public LCSPrivacyClassImpl(SSCode ssCode, ExtSSStatus ssStatus, NotificationToMSUser notificationToMSUser, ArrayList<ExternalClient> externalClientList, ArrayList<LCSClientInternalID> plmnClientList, MAPExtensionContainer extensionContainer, ArrayList<ExternalClient> extExternalClientList, ArrayList<ServiceType> serviceTypeList) {
        super("LCSPrivacyClass");
        this.ssCode = ssCode;
        this.ssStatus = ssStatus;
        this.notificationToMSUser = notificationToMSUser;
        this.externalClientList = externalClientList;
        this.plmnClientList = plmnClientList;
        this.extensionContainer = extensionContainer;
        this.extExternalClientList = extExternalClientList;
        this.serviceTypeList = serviceTypeList;
    }

    @Override
    public SSCode getSsCode() {
        return this.ssCode;
    }

    @Override
    public ExtSSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    public NotificationToMSUser getNotificationToMSUser() {
        return this.notificationToMSUser;
    }

    @Override
    public ArrayList<ExternalClient> getExternalClientList() {
        return this.externalClientList;
    }

    @Override
    public ArrayList<LCSClientInternalID> getPLMNClientList() {
        return this.plmnClientList;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public ArrayList<ExternalClient> getExtExternalClientList() {
        return this.extExternalClientList;
    }

    @Override
    public ArrayList<ServiceType> getServiceTypeList() {
        return this.serviceTypeList;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.ssStatus = null;
        this.notificationToMSUser = null;
        this.externalClientList = null;
        this.plmnClientList = null;
        this.extensionContainer = null;
        this.extExternalClientList = null;
        this.serviceTypeList = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssCode: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssCode = new SSCodeImpl();
                    ((SSCodeImpl)this.ssCode).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssStatus: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssStatus = new ExtSSStatusImpl();
                    ((ExtSSStatusImpl)this.ssStatus).decodeAll(ais);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".notificationToMSUser: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    int i2 = (int)ais.readInteger();
                                    this.notificationToMSUser = NotificationToMSUser.getInstance(i2);
                                    break;
                                }
                                case 1: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".externalClientList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.externalClientList = new ArrayList();
                                    AsnInputStream ais2 = ais.readSequenceStream();
                                    while (ais2.available() != 0) {
                                        int tag2 = ais2.readTag();
                                        if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is primitive when decoding externalClientList", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        ExternalClientImpl elem = new ExternalClientImpl();
                                        elem.decodeAll(ais2);
                                        this.externalClientList.add(elem);
                                        if (this.externalClientList.size() >= 0 && this.externalClientList.size() <= 5) continue;
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".externalClientList: elements count must be from 1 to 5, found: " + this.externalClientList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    break;
                                }
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".plmnClientList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.plmnClientList = new ArrayList();
                                    AsnInputStream ais3 = ais.readSequenceStream();
                                    while (ais3.available() != 0) {
                                        int tag2 = ais3.readTag();
                                        if (tag2 != 10 || ais3.getTagClass() != 0 || !ais3.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is not primitive when decoding plmnClientList", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        int lcsId = (int)ais3.readInteger();
                                        LCSClientInternalID elem = LCSClientInternalID.getLCSClientInternalID(lcsId);
                                        this.plmnClientList.add(elem);
                                        if (this.plmnClientList.size() >= 1 && this.plmnClientList.size() <= 5) continue;
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".plmnClientList: elements count must be from 1 to 5, found: " + this.plmnClientList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    break;
                                }
                                case 3: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break;
                                }
                                case 4: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extExternalClientList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extExternalClientList = new ArrayList();
                                    AsnInputStream ais4 = ais.readSequenceStream();
                                    while (ais4.available() != 0) {
                                        int tag2 = ais4.readTag();
                                        if (tag2 != 16 || ais4.getTagClass() != 0 || ais4.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is primitive when decoding extExternalClientList", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        ExternalClientImpl elem = new ExternalClientImpl();
                                        elem.decodeAll(ais4);
                                        this.extExternalClientList.add(elem);
                                        if (this.extExternalClientList.size() >= 1 && this.extExternalClientList.size() <= 35) continue;
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extExternalClientList: elements count must be from 1 to 35, found: " + this.extExternalClientList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    break;
                                }
                                case 5: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".plmnClientList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.serviceTypeList = new ArrayList();
                                    AsnInputStream ais5 = ais.readSequenceStream();
                                    while (ais5.available() != 0) {
                                        int tag2 = ais5.readTag();
                                        if (tag2 != 16 || ais5.getTagClass() != 0 || ais5.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is primitive when decoding serviceTypeList", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        ServiceTypeImpl elem = new ServiceTypeImpl();
                                        elem.decodeAll(ais5);
                                        this.serviceTypeList.add(elem);
                                        if (this.serviceTypeList.size() >= 1 && this.serviceTypeList.size() <= 32) continue;
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".serviceTypeList: elements count must be from 1 to 32, found: " + this.serviceTypeList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    break;
                                }
                                default: {
                                    ais.advanceElement();
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
            }
            ++num;
        }
        if (this.ssCode == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament ssCode is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.ssStatus == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament ssStatus is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssCode == null) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": ssCode must not be null");
        }
        if (this.ssStatus == null) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": ssStatus must not be null");
        }
        if (this.externalClientList != null && (this.externalClientList.size() < 0 || this.externalClientList.size() > 5)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter externalClientList size must be from 1 to 5, found: " + this.externalClientList.size());
        }
        if (this.plmnClientList != null && (this.plmnClientList.size() < 1 || this.plmnClientList.size() > 5)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter plmnClientList size must be from 1 to 5, found: " + this.plmnClientList.size());
        }
        if (this.extExternalClientList != null && (this.extExternalClientList.size() < 1 || this.extExternalClientList.size() > 35)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter extExternalClientList size must be from 1 to 35, found: " + this.extExternalClientList.size());
        }
        if (this.serviceTypeList != null && (this.serviceTypeList.size() < 1 || this.serviceTypeList.size() > 32)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter serviceTypeList size must be from 1 to 32, found: " + this.serviceTypeList.size());
        }
        try {
            SequenceBase bee;
            int pos;
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
            ((ExtSSStatusImpl)this.ssStatus).encodeAll(asnOs);
            if (this.notificationToMSUser != null) {
                asnOs.writeInteger(2, 0, this.notificationToMSUser.getCode());
            }
            if (this.externalClientList != null) {
                asnOs.writeTag(2, false, 1);
                pos = asnOs.StartContentDefiniteLength();
                for (ExternalClient externalClient : this.externalClientList) {
                    bee = (ExternalClientImpl)externalClient;
                    bee.encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.plmnClientList != null) {
                asnOs.writeTag(2, false, 2);
                pos = asnOs.StartContentDefiniteLength();
                for (LCSClientInternalID lCSClientInternalID : this.plmnClientList) {
                    asnOs.writeInteger(0, 10, lCSClientInternalID.getId());
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
            }
            if (this.extExternalClientList != null) {
                asnOs.writeTag(2, false, 4);
                pos = asnOs.StartContentDefiniteLength();
                for (ExternalClient externalClient : this.extExternalClientList) {
                    bee = (ExternalClientImpl)externalClient;
                    bee.encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            if (this.serviceTypeList != null) {
                asnOs.writeTag(2, false, 5);
                pos = asnOs.StartContentDefiniteLength();
                for (ServiceType serviceType : this.serviceTypeList) {
                    bee = (ServiceTypeImpl)serviceType;
                    bee.encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        boolean firstItem;
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode.toString());
            sb.append(", ");
        }
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus.toString());
            sb.append(", ");
        }
        if (this.notificationToMSUser != null) {
            sb.append("notificationToMSUser=");
            sb.append(this.notificationToMSUser.toString());
            sb.append(", ");
        }
        if (this.externalClientList != null) {
            sb.append("externalClientList=[");
            firstItem = true;
            for (ExternalClient externalClient : this.externalClientList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(externalClient.toString());
            }
            sb.append("], ");
        }
        if (this.plmnClientList != null) {
            sb.append("plmnClientList=[");
            firstItem = true;
            for (LCSClientInternalID lCSClientInternalID : this.plmnClientList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(lCSClientInternalID.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.extExternalClientList != null) {
            sb.append("extExternalClientList=[");
            firstItem = true;
            for (ExternalClient externalClient : this.extExternalClientList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(externalClient.toString());
            }
            sb.append("], ");
        }
        if (this.serviceTypeList != null) {
            sb.append("serviceTypeList=[");
            firstItem = true;
            for (ServiceType serviceType : this.serviceTypeList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(serviceType.toString());
            }
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

