/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tools.traceparser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.mobicents.protocols.ss7.tools.traceparser.ProcessControl;
import org.mobicents.protocols.ss7.tools.traceparser.TraceParserUtil;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriver;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriverBase;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderException;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderListener;

public class TraceReaderDriverPcap
extends TraceReaderDriverBase
implements TraceReaderDriver {
    public TraceReaderDriverPcap(ProcessControl processControl, String fileName) {
        super(processControl, fileName);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startTraceFile() throws TraceReaderException {
        if (this.listeners.size() == 0) {
            throw new TraceReaderException("TraceReaderListener list is empty");
        }
        this.isStarted = true;
        fis = null;
        try {
            try {
                if (this.processControl.checkNeedInterrupt()) {
                    var31_2 = null;
                    try {
                        fis.close();
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                fis = new FileInputStream(this.fileName);
                fileSignature = new byte[4];
                if (fis.read(fileSignature) < 4) {
                    throw new Exception("Not enouph data for a file signature");
                }
                libPcapSign = new byte[]{-44, -61, -78, -95};
                pcapNgSign = new byte[]{10, 13, 13, 10};
                if (Arrays.equals(fileSignature, libPcapSign)) {
                    fileEncodingType = FileEncodingType.LIB_PCAP;
                } else {
                    if (Arrays.equals(fileSignature, pcapNgSign) == false) throw new Exception("A file signature does not match to LIBPCAP or PCAPNG file formats");
                    fileEncodingType = FileEncodingType.PCAP_NG;
                }
                switch (1.$SwitchMap$org$mobicents$protocols$ss7$tools$traceparser$TraceReaderDriverPcap$FileEncodingType[fileEncodingType.ordinal()]) {
                    case 1: {
                        littleBigEndianFormat = LittleBigEndianFormat.LITTLE_ENDIAN;
                        globHeader = new byte[24];
                        System.arraycopy(fileSignature, 0, globHeader, 0, 4);
                        if (fis.read(globHeader, 4, 20) < 20) {
                            throw new Exception("Not enough data for a global header LIB PCAP");
                        }
                        network = ((globHeader[20] & 255) << 0) + ((globHeader[21] & 255) << 8) + ((globHeader[22] & 255) << 16) + ((globHeader[23] & 255) << 24);
                        recCnt = 0;
                        while (fis.available() > 0) {
                            if (recCnt == 509) {
                                gggg = 0;
                                ++gggg;
                            }
                            if (this.processControl.checkNeedInterrupt()) {
                                var31_3 = null;
                                ** try [egrp 2[TRYBLOCK] [9 : 1025->1032)] { 
lbl44:
                                // 1 sources

                                fis.close();
                                return;
lbl46:
                                // 1 sources

                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                            packetHeader = new byte[16];
                            if (fis.read(packetHeader) < 16) {
                                throw new Exception("Not enough data for a packet header LIB PCAP");
                            }
                            ts_sec = this.parseIntValue(packetHeader, 0, littleBigEndianFormat);
                            ts_usec = this.parseIntValue(packetHeader, 4, littleBigEndianFormat);
                            incl_len = this.parseIntValue(packetHeader, 8, littleBigEndianFormat);
                            orig_len = this.parseIntValue(packetHeader, 12, littleBigEndianFormat);
                            data = new byte[incl_len];
                            if (fis.read(data) < incl_len) {
                                throw new Exception("Not enough data for a packet data");
                            }
                            ++recCnt;
                            this.parsePacket(data, network);
                        }
                        break;
                    }
                    case 2: {
                        sectionHeaderBlockGlobHeader = new byte[24];
                        System.arraycopy(fileSignature, 0, sectionHeaderBlockGlobHeader, 0, 4);
                        if (fis.read(sectionHeaderBlockGlobHeader, 4, 20) < 20) {
                            throw new Exception("Not enough data for a sectionHeaderBlock Header PCAP NG");
                        }
                        bigEndianSign = new byte[]{26, 43, 60, 77};
                        bigLittleEndianFld = new byte[4];
                        System.arraycopy(sectionHeaderBlockGlobHeader, 8, bigLittleEndianFld, 0, 4);
                        littleBigEndianFormat = Arrays.equals(bigLittleEndianFld, bigEndianSign) != false ? LittleBigEndianFormat.BIG_ENDIAN : LittleBigEndianFormat.LITTLE_ENDIAN;
                        blockTotalLength = this.parseIntValue(sectionHeaderBlockGlobHeader, 4, littleBigEndianFormat);
                        sectLen = this.parseIntValue(sectionHeaderBlockGlobHeader, 16, littleBigEndianFormat);
                        sectionHeaderBlockglobOptions = new byte[blockTotalLength - 24 - 4];
                        if (fis.read(sectionHeaderBlockglobOptions) < sectionHeaderBlockglobOptions.length) {
                            throw new Exception("Not enough data for a sectionHeaderBlock Options PCAP NG");
                        }
                        blockTotalLength2 = new byte[4];
                        if (fis.read(blockTotalLength2) < 4) {
                            throw new Exception("Not enough data for a blockTotalLength2 PCAP NG");
                        }
                        options = this.parsePcapNgOptions(sectionHeaderBlockglobOptions, 0, littleBigEndianFormat);
                        linkType = 0;
                        snapLen = 0;
                        recCnt = 0;
                        block19: while (fis.available() > 0) {
                            if (this.processControl.checkNeedInterrupt()) {
                                var31_4 = null;
                                ** try [egrp 2[TRYBLOCK] [9 : 1025->1032)] { 
lbl89:
                                // 1 sources

                                fis.close();
                                return;
lbl91:
                                // 1 sources

                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                            packetHeader = new byte[8];
                            if (fis.read(packetHeader) < 8) {
                                throw new Exception("Not enough data for a packet header PCAP NG");
                            }
                            blockType = this.parseIntValue(packetHeader, 0, littleBigEndianFormat);
                            blockTotalLength = this.parseIntValue(packetHeader, 4, littleBigEndianFormat);
                            data = new byte[blockTotalLength - 12];
                            if (fis.read(data) < blockTotalLength - 12) {
                                throw new Exception("Not enough data for a block data PCAP NG");
                            }
                            blockTotalLength2 = new byte[4];
                            if (fis.read(blockTotalLength2) < 4) {
                                throw new Exception("Not enough data for a blockTotalLength2 PCAP NG");
                            }
                            switch (blockType) {
                                case 1: {
                                    linkType = this.parseShortValue(data, 0, littleBigEndianFormat);
                                    snapLen = this.parseIntValue(data, 4, littleBigEndianFormat);
                                    options = this.parsePcapNgOptions(data, 8, littleBigEndianFormat);
                                    break;
                                }
                                case 6: {
                                    _interface = this.parseIntValue(data, 0, littleBigEndianFormat);
                                    timestamp = this.parseLongValue(data, 4, littleBigEndianFormat);
                                    capturedLen = this.parseIntValue(data, 12, littleBigEndianFormat);
                                    packetLen = this.parseIntValue(data, 16, littleBigEndianFormat);
                                    data2 = new byte[capturedLen];
                                    System.arraycopy(data, 20, data2, 0, capturedLen);
                                    cl = (capturedLen + 3) / 4 * 4;
                                    options = this.parsePcapNgOptions(data, 20 + cl, littleBigEndianFormat);
                                    ++recCnt;
                                    this.parsePacket(data2, linkType);
                                    continue block19;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (Throwable e) {
                this.loger.error("General exception: " + e.getMessage());
                e.printStackTrace();
                throw new TraceReaderException("General exception: " + e.getMessage(), e);
            }
            {
            }
            var31_5 = null;
            try {}
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            fis.close();
            return;
        }
        catch (Throwable var30_49) {
            var31_6 = null;
            ** try [egrp 2[TRYBLOCK] [9 : 1025->1032)] { 
lbl141:
            // 1 sources

            fis.close();
            throw var30_49;
lbl143:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            throw var30_49;
        }
    }

    private int parseIntValue(byte[] buf, int offset, LittleBigEndianFormat littleBigEndianFormat) {
        int res = littleBigEndianFormat == LittleBigEndianFormat.LITTLE_ENDIAN ? (buf[offset + 0] & 0xFF) + ((buf[offset + 1] & 0xFF) << 8) + ((buf[offset + 2] & 0xFF) << 16) + ((buf[offset + 3] & 0xFF) << 24) : (buf[offset + 3] & 0xFF) + ((buf[offset + 2] & 0xFF) << 8) + ((buf[offset + 1] & 0xFF) << 16) + ((buf[offset + 0] & 0xFF) << 24);
        return res;
    }

    private long parseLongValue(byte[] buf, int offset, LittleBigEndianFormat littleBigEndianFormat) {
        long res = littleBigEndianFormat == LittleBigEndianFormat.LITTLE_ENDIAN ? (long)((buf[offset + 0] & 0xFF) + ((buf[offset + 1] & 0xFF) << 8) + ((buf[offset + 2] & 0xFF) << 16) + ((buf[offset + 3] & 0xFF) << 24) + ((buf[offset + 4] & 0xFF) << 32) + ((buf[offset + 5] & 0xFF) << 40) + ((buf[offset + 6] & 0xFF) << 48) + ((buf[offset + 7] & 0xFF) << 56)) : (long)((buf[offset + 7] & 0xFF) + ((buf[offset + 6] & 0xFF) << 8) + ((buf[offset + 5] & 0xFF) << 16) + ((buf[offset + 4] & 0xFF) << 24) + ((buf[offset + 3] & 0xFF) << 32) + ((buf[offset + 2] & 0xFF) << 40) + ((buf[offset + 1] & 0xFF) << 48) + ((buf[offset + 0] & 0xFF) << 56));
        return res;
    }

    private int parseShortValue(byte[] buf, int offset, LittleBigEndianFormat littleBigEndianFormat) {
        int res = littleBigEndianFormat == LittleBigEndianFormat.LITTLE_ENDIAN ? (buf[offset + 0] & 0xFF) + ((buf[offset + 1] & 0xFF) << 8) : (buf[offset + 1] & 0xFF) + ((buf[offset + 0] & 0xFF) << 8);
        return res;
    }

    public PcapNgOption[] parsePcapNgOptions(byte[] data, int ind, LittleBigEndianFormat littleBigEndianFormat) {
        ArrayList<PcapNgOption> res = new ArrayList<PcapNgOption>();
        while (data.length - ind >= 4) {
            int optionCode = this.parseShortValue(data, ind, littleBigEndianFormat);
            int optionLength = this.parseShortValue(data, ind + 2, littleBigEndianFormat);
            if (optionCode == 0) break;
            byte[] buf = new byte[optionLength];
            System.arraycopy(data, ind + 4, buf, 0, optionLength);
            PcapNgOption opt = new PcapNgOption();
            opt.optionCode = optionCode;
            opt.value = buf;
            res.add(opt);
            int ol = (optionLength + 3) / 4 * 4;
            ind += 4 + ol;
        }
        PcapNgOption[] ress = new PcapNgOption[res.size()];
        res.toArray(ress);
        return ress;
    }

    private void parsePacket(byte[] data, int network) throws TraceReaderException {
        switch (network) {
            case 1: {
                if (data == null || data.length < 34) {
                    return;
                }
                if (data[12] != 8 || data[13] != 0) {
                    return;
                }
                byte[] ipData = new byte[data.length - 14];
                System.arraycopy(data, 14, ipData, 0, data.length - 14);
                this.parseIpV4Packet(ipData);
                break;
            }
            case 113: {
                if (data == null || data.length < 36) {
                    return;
                }
                if (data[14] != 8 || data[15] != 0) {
                    return;
                }
                byte[] ipData = new byte[data.length - 16];
                System.arraycopy(data, 16, ipData, 0, data.length - 16);
                this.parseIpV4Packet(ipData);
                break;
            }
            case 141: {
                if (data == null || data.length < 5) {
                    return;
                }
                byte[] bufMsg = new byte[data.length + 3];
                bufMsg[2] = 63;
                System.arraycopy(data, 0, bufMsg, 3, data.length);
                for (TraceReaderListener ls : this.listeners) {
                    TraceParserUtil.parceLegacyMtp3(bufMsg, this.listeners);
                }
                break;
            }
        }
    }

    private void parseIpV4Packet(byte[] data) throws TraceReaderException {
        int version = (data[0] & 0xF0) >> 4;
        int ipHeaderLen = (data[0] & 0xF) * 4;
        if (version != 4) {
            return;
        }
        int ipProtocolId = data[9] & 0xFF;
        if (ipProtocolId != 132) {
            return;
        }
        int startSctpBlock = ipHeaderLen;
        startSctpBlock += 12;
        while (data.length >= startSctpBlock + 4) {
            int suff;
            int blockType = data[startSctpBlock] & 0xFF;
            int blockLen = ((data[startSctpBlock + 2] & 0xFF) << 8) + (data[startSctpBlock + 3] & 0xFF);
            if (blockLen == 0 || data.length < startSctpBlock + blockLen) break;
            if (blockType == 0 && blockLen > 16) {
                byte[] bufM3ua = new byte[blockLen - 16];
                System.arraycopy(data, startSctpBlock + 16, bufM3ua, 0, blockLen - 16);
                this.parseM3uaPacket(bufM3ua);
            }
            if ((suff = blockLen % 4) > 0) {
                blockLen += 4 - suff;
            }
            startSctpBlock += blockLen;
        }
    }

    private void parseM3uaPacket(byte[] data) throws TraceReaderException {
        if (data.length < 8) {
            return;
        }
        int version = data[0] & 0xFF;
        int messageClass = data[2] & 0xFF;
        int messageType = data[3] & 0xFF;
        int msgLen = ((data[4] & 0xFF) << 24) + ((data[5] & 0xFF) << 16) + ((data[6] & 0xFF) << 8) + (data[7] & 0xFF);
        if (data.length < msgLen) {
            return;
        }
        if (messageClass == 1 && messageType == 1) {
            int parLen;
            int pos = 8;
            long networkAppearance = -1L;
            long routingContext = -1L;
            long correlationId = -1L;
            byte[] protocolData = null;
            while (pos + 4 <= msgLen && pos + (parLen = ((data[pos + 2] & 0xFF) << 8) + (data[pos + 3] & 0xFF)) <= msgLen) {
                if (data[pos] == 2 && data[pos + 1] == 0) {
                    networkAppearance = ((data[pos + 4] & 0xFF) << 24) + ((data[pos + 5] & 0xFF) << 16) + ((data[pos + 6] & 0xFF) << 8) + (data[pos + 7] & 0xFF);
                }
                if (data[pos] == 0 && data[pos + 1] == 6) {
                    routingContext = ((data[pos + 4] & 0xFF) << 24) + ((data[pos + 5] & 0xFF) << 16) + ((data[pos + 6] & 0xFF) << 8) + (data[pos + 7] & 0xFF);
                }
                if (data[pos] == 2 && data[pos + 1] == 16) {
                    protocolData = new byte[parLen - 4];
                    System.arraycopy(data, pos + 4, protocolData, 0, parLen - 4);
                }
                if (data[pos] == 0 && data[pos + 1] == 19) {
                    correlationId = ((data[pos + 4] & 0xFF) << 24) + ((data[pos + 5] & 0xFF) << 16) + ((data[pos + 6] & 0xFF) << 8) + (data[pos + 7] & 0xFF);
                }
                pos += parLen;
            }
            if (protocolData != null) {
                this.parseM3uaProtocolData(networkAppearance, routingContext, correlationId, protocolData);
            }
        } else if (messageClass == 6 && messageType == 1) {
            int len2 = ((data[18] & 0xFF) << 8) + data[19] & 0xFF;
            byte[] protocolData = new byte[len2 - 4 + 3];
            protocolData[2] = 63;
            System.arraycopy(data, 20, protocolData, 3, protocolData.length - 3);
            for (TraceReaderListener ls : this.listeners) {
                TraceParserUtil.parceLegacyMtp3(protocolData, this.listeners);
            }
        }
    }

    private void parseM3uaProtocolData(long networkAppearance, long routingContext, long correlationId, byte[] data) throws TraceReaderException {
        if (data.length < 14) {
            return;
        }
        int opc = ((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
        int dpc = ((data[4] & 0xFF) << 24) + ((data[5] & 0xFF) << 16) + ((data[6] & 0xFF) << 8) + (data[7] & 0xFF);
        int si = data[8] & 0xFF;
        int ni = data[9] & 0xFF;
        int mp = data[10] & 0xFF;
        int sls = data[11] & 0xFF;
        byte[] bufMsg = new byte[data.length - 12];
        System.arraycopy(data, 12, bufMsg, 0, data.length - 12);
        for (TraceReaderListener ls : this.listeners) {
            ls.ss7Message(si, ni, 0, opc, dpc, sls, bufMsg);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$mobicents$protocols$ss7$tools$traceparser$TraceReaderDriverPcap$FileEncodingType;

        static {
            $SwitchMap$org$mobicents$protocols$ss7$tools$traceparser$TraceReaderDriverPcap$FileEncodingType = new int[FileEncodingType.values().length];
            try {
                1.$SwitchMap$org$mobicents$protocols$ss7$tools$traceparser$TraceReaderDriverPcap$FileEncodingType[FileEncodingType.LIB_PCAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$mobicents$protocols$ss7$tools$traceparser$TraceReaderDriverPcap$FileEncodingType[FileEncodingType.PCAP_NG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public class PcapNgOption {
        public int optionCode;
        public byte[] value;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PcapNgOption=[optionCode=");
            sb.append(this.optionCode);
            sb.append(", len=");
            sb.append(this.value.length);
            sb.append(", bytes=");
            sb.append(DatatypeConverter.printHexBinary((byte[])this.value));
            sb.append(", UTF8 String=");
            try {
                String decoded = new String(this.value, "UTF-8");
                sb.append(decoded);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            sb.append("]");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LittleBigEndianFormat {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileEncodingType {
        LIB_PCAP,
        PCAP_NG;

    }
}

