/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.io.Serializable;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.SccpManagementEventListener;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpNoticeMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.message.MessageFactory;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SccpProviderImpl
implements SccpProvider,
Serializable {
    private static final Logger logger = Logger.getLogger(SccpProviderImpl.class);
    private transient SccpStackImpl stack;
    protected FastMap<Integer, SccpListener> ssnToListener = new FastMap();
    protected FastList<SccpManagementEventListener> managementEventListeners = new FastList();
    private MessageFactoryImpl messageFactory;
    private ParameterFactoryImpl parameterFactory;

    SccpProviderImpl(SccpStackImpl stack) {
        this.stack = stack;
        this.messageFactory = stack.messageFactory;
        this.parameterFactory = new ParameterFactoryImpl();
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public ParameterFactory getParameterFactory() {
        return this.parameterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSccpListener(int ssn, SccpListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            SccpListener existingListener = this.ssnToListener.get(ssn);
            if (existingListener != null && logger.isEnabledFor(Level.WARN)) {
                logger.warn(String.format("Registering SccpListener=%s for already existing SccpListnere=%s for SSN=%d", listener, existingListener, ssn));
            }
            FastMap<Integer, SccpListener> newListener = new FastMap<Integer, SccpListener>();
            newListener.putAll(this.ssnToListener);
            newListener.put(ssn, listener);
            this.ssnToListener = newListener;
            this.stack.broadcastChangedSsnState(ssn, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterSccpListener(int ssn) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            FastMap<Integer, SccpListener> newListener = new FastMap<Integer, SccpListener>();
            newListener.putAll(this.ssnToListener);
            SccpListener existingListener = (SccpListener)newListener.remove(ssn);
            if (existingListener == null && logger.isEnabledFor(Level.WARN)) {
                logger.warn(String.format("No existing SccpListnere=%s for SSN=%d", existingListener, ssn));
            }
            this.ssnToListener = newListener;
            this.stack.broadcastChangedSsnState(ssn, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerManagementEventListener(SccpManagementEventListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            if (this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<SccpManagementEventListener> newManagementEventListeners = new FastList<SccpManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.add(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterManagementEventListener(SccpManagementEventListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            if (!this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<SccpManagementEventListener> newManagementEventListeners = new FastList<SccpManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.remove(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    protected SccpListener getSccpListener(int ssn) {
        return this.ssnToListener.get(ssn);
    }

    protected FastMap<Integer, SccpListener> getAllSccpListeners() {
        return this.ssnToListener;
    }

    @Override
    public void send(SccpDataMessage message) throws IOException {
        try {
            SccpDataMessageImpl msg = (SccpDataMessageImpl)message;
            this.stack.send(msg);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void send(SccpNoticeMessage message) throws IOException {
        try {
            SccpNoticeMessageImpl msg = (SccpNoticeMessageImpl)message;
            this.stack.send(msg);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        return this.stack.getMaxUserDataLength(calledPartyAddress, callingPartyAddress, msgNetworkId);
    }
}

