/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.callhandling;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.callhandling.SuppressMTSS;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SuppressMTSSImpl
implements SuppressMTSS,
MAPAsnPrimitive {
    private static final int _INDEX_SuppressCUG = 0;
    private static final int _INDEX_SuppressCCBS = 1;
    private static final String _PrimitiveName = "SuppressMTSS";
    private BitSetStrictLength bitString = new BitSetStrictLength(2);

    public SuppressMTSSImpl() {
    }

    public SuppressMTSSImpl(boolean suppressCUG, boolean suppressCCBS) {
        if (suppressCUG) {
            this.bitString.set(0);
        }
        if (suppressCCBS) {
            this.bitString.set(1);
        }
    }

    public boolean getSuppressCUG() {
        return this.bitString.get(0);
    }

    public boolean getSuppressCCBS() {
        return this.bitString.get(1);
    }

    public int getTag() throws MAPException {
        return 3;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SuppressMTSS: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SuppressMTSS: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SuppressMTSS: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SuppressMTSS: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length < 2 || length > 3) {
            throw new MAPParsingComponentException("Error decoding SuppressMTSS: the SuppressMTSS field must contain from 2 or 3 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.bitString = ansIS.readBitStringData(length);
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 3);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SuppressMTSS: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeBitStringData(this.bitString);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding SuppressMTSS: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SuppressMTSS: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.getSuppressCUG()) {
            sb.append("SuppressCUG, ");
        }
        if (this.getSuppressCCBS()) {
            sb.append("SuppressCCBS, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

