/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.CallingPartyNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.Digits;
import org.mobicents.protocols.ss7.cap.api.isup.LocationNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.OriginalCalledNumberCap;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.ScfID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.EstablishTemporaryConnectionRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.Carrier;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.NAOliInfo;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwo;
import org.mobicents.protocols.ss7.cap.isup.CallingPartyNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.DigitsImpl;
import org.mobicents.protocols.ss7.cap.isup.LocationNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.OriginalCalledNumberCapImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.ScfIDImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CarrierImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.NAOliInfoImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwoImpl;

public class EstablishTemporaryConnectionRequestImpl
extends CircuitSwitchedCallMessageImpl
implements EstablishTemporaryConnectionRequest {
    public static final int _ID_assistingSSPIPRoutingAddress = 0;
    public static final int _ID_correlationID = 1;
    public static final int _ID_scfID = 3;
    public static final int _ID_extensions = 4;
    public static final int _ID_carrier = 5;
    public static final int _ID_serviceInteractionIndicatorsTwo = 6;
    public static final int _ID_callSegmentID = 7;
    public static final int _ID_naOliInfo = 50;
    public static final int _ID_chargeNumber = 51;
    public static final int _ID_originalCalledPartyID = 52;
    public static final int _ID_callingPartyNumber = 53;
    private static final String _PrimitiveName = "EstablishTemporaryConnectionIndication";
    private Digits assistingSSPIPRoutingAddress;
    private Digits correlationID;
    private ScfID scfID;
    private CAPExtensions extensions;
    private Carrier carrier;
    private ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo;
    private Integer callSegmentID;
    private NAOliInfo naOliInfo;
    private LocationNumberCap chargeNumber;
    private OriginalCalledNumberCap originalCalledPartyID;
    private CallingPartyNumberCap callingPartyNumber;
    private boolean isCAPVersion3orLater;

    public EstablishTemporaryConnectionRequestImpl(boolean isCAPVersion3orLater) {
        this.isCAPVersion3orLater = isCAPVersion3orLater;
    }

    public EstablishTemporaryConnectionRequestImpl(Digits assistingSSPIPRoutingAddress, Digits correlationID, ScfID scfID, CAPExtensions extensions, Carrier carrier, ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo, Integer callSegmentID, NAOliInfo naOliInfo, LocationNumberCap chargeNumber, OriginalCalledNumberCap originalCalledPartyID, CallingPartyNumberCap callingPartyNumber, boolean isCAPVersion3orLater) {
        this.assistingSSPIPRoutingAddress = assistingSSPIPRoutingAddress;
        this.correlationID = correlationID;
        this.scfID = scfID;
        this.extensions = extensions;
        this.carrier = carrier;
        this.serviceInteractionIndicatorsTwo = serviceInteractionIndicatorsTwo;
        this.callSegmentID = callSegmentID;
        this.naOliInfo = naOliInfo;
        this.chargeNumber = chargeNumber;
        this.originalCalledPartyID = originalCalledPartyID;
        this.callingPartyNumber = callingPartyNumber;
        this.isCAPVersion3orLater = isCAPVersion3orLater;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.establishTemporaryConnection_Request;
    }

    public int getOperationCode() {
        return 17;
    }

    public Digits getAssistingSSPIPRoutingAddress() {
        return this.assistingSSPIPRoutingAddress;
    }

    public Digits getCorrelationID() {
        return this.correlationID;
    }

    public ScfID getScfID() {
        return this.scfID;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public ServiceInteractionIndicatorsTwo getServiceInteractionIndicatorsTwo() {
        return this.serviceInteractionIndicatorsTwo;
    }

    public Integer getCallSegmentID() {
        return this.callSegmentID;
    }

    public NAOliInfo getNAOliInfo() {
        return this.naOliInfo;
    }

    public LocationNumberCap getChargeNumber() {
        return this.chargeNumber;
    }

    public OriginalCalledNumberCap getOriginalCalledPartyID() {
        return this.originalCalledPartyID;
    }

    public CallingPartyNumberCap getCallingPartyNumber() {
        return this.callingPartyNumber;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.assistingSSPIPRoutingAddress = null;
        this.correlationID = null;
        this.scfID = null;
        this.extensions = null;
        this.carrier = null;
        this.serviceInteractionIndicatorsTwo = null;
        this.callSegmentID = null;
        this.naOliInfo = null;
        this.chargeNumber = null;
        this.originalCalledPartyID = null;
        this.callingPartyNumber = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block13: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.assistingSSPIPRoutingAddress = new DigitsImpl();
                        ((DigitsImpl)this.assistingSSPIPRoutingAddress).decodeAll(ais);
                        this.assistingSSPIPRoutingAddress.setIsGenericNumber();
                        continue block13;
                    }
                    case 1: {
                        this.correlationID = new DigitsImpl();
                        ((DigitsImpl)this.correlationID).decodeAll(ais);
                        this.correlationID.setIsGenericDigits();
                        continue block13;
                    }
                    case 3: {
                        this.scfID = new ScfIDImpl();
                        ((ScfIDImpl)this.scfID).decodeAll(ais);
                        continue block13;
                    }
                    case 4: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        continue block13;
                    }
                    case 5: {
                        this.carrier = new CarrierImpl();
                        ((CarrierImpl)this.carrier).decodeAll(ais);
                        continue block13;
                    }
                    case 6: {
                        if (!this.isCAPVersion3orLater) continue block13;
                        this.serviceInteractionIndicatorsTwo = new ServiceInteractionIndicatorsTwoImpl();
                        ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).decodeAll(ais);
                        continue block13;
                    }
                    case 7: {
                        if (this.isCAPVersion3orLater) {
                            this.callSegmentID = (int)ais.readInteger();
                            continue block13;
                        }
                        this.serviceInteractionIndicatorsTwo = new ServiceInteractionIndicatorsTwoImpl();
                        ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).decodeAll(ais);
                        continue block13;
                    }
                    case 50: {
                        this.naOliInfo = new NAOliInfoImpl();
                        ((NAOliInfoImpl)this.naOliInfo).decodeAll(ais);
                        continue block13;
                    }
                    case 51: {
                        this.chargeNumber = new LocationNumberCapImpl();
                        ((LocationNumberCapImpl)this.chargeNumber).decodeAll(ais);
                        continue block13;
                    }
                    case 52: {
                        this.originalCalledPartyID = new OriginalCalledNumberCapImpl();
                        ((OriginalCalledNumberCapImpl)this.originalCalledPartyID).decodeAll(ais);
                        continue block13;
                    }
                    case 53: {
                        this.callingPartyNumber = new CallingPartyNumberCapImpl();
                        ((CallingPartyNumberCapImpl)this.callingPartyNumber).decodeAll(ais);
                        continue block13;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.assistingSSPIPRoutingAddress == null) {
            throw new CAPParsingComponentException("Error while decoding EstablishTemporaryConnectionIndication: parameter assistingSSPIPRoutingAddress is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.assistingSSPIPRoutingAddress == null) {
            throw new CAPException("Error while encoding EstablishTemporaryConnectionIndication: assistingSSPIPRoutingAddress must not be null");
        }
        try {
            ((DigitsImpl)this.assistingSSPIPRoutingAddress).encodeAll(aos, 2, 0);
            if (this.correlationID != null) {
                ((DigitsImpl)this.correlationID).encodeAll(aos, 2, 1);
            }
            if (this.scfID != null) {
                ((ScfIDImpl)this.scfID).encodeAll(aos, 2, 3);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 4);
            }
            if (this.carrier != null) {
                ((CarrierImpl)this.carrier).encodeAll(aos, 2, 5);
            }
            if (this.serviceInteractionIndicatorsTwo != null) {
                if (this.isCAPVersion3orLater) {
                    ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).encodeAll(aos, 2, 6);
                } else {
                    ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).encodeAll(aos, 2, 7);
                }
            }
            if (this.callSegmentID != null && this.isCAPVersion3orLater) {
                aos.writeInteger(2, 7, this.callSegmentID.intValue());
            }
            if (this.naOliInfo != null) {
                ((NAOliInfoImpl)this.naOliInfo).encodeAll(aos, 2, 50);
            }
            if (this.chargeNumber != null) {
                ((LocationNumberCapImpl)this.chargeNumber).encodeAll(aos, 2, 51);
            }
            if (this.originalCalledPartyID != null) {
                ((OriginalCalledNumberCapImpl)this.originalCalledPartyID).encodeAll(aos, 2, 52);
            }
            if (this.callingPartyNumber != null) {
                ((CallingPartyNumberCapImpl)this.callingPartyNumber).encodeAll(aos, 2, 53);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding EstablishTemporaryConnectionIndication: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.assistingSSPIPRoutingAddress != null) {
            sb.append(", assistingSSPIPRoutingAddress=");
            sb.append(this.assistingSSPIPRoutingAddress.toString());
        }
        if (this.correlationID != null) {
            sb.append(", correlationID=");
            sb.append(this.correlationID.toString());
        }
        if (this.scfID != null) {
            sb.append(", scfID=");
            sb.append(this.scfID.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.carrier != null) {
            sb.append(", carrier=");
            sb.append(this.carrier.toString());
        }
        if (this.serviceInteractionIndicatorsTwo != null) {
            sb.append(", serviceInteractionIndicatorsTwo=");
            sb.append(this.serviceInteractionIndicatorsTwo.toString());
        }
        if (this.callSegmentID != null) {
            sb.append(", callSegmentID=");
            sb.append(this.callSegmentID.toString());
        }
        if (this.naOliInfo != null) {
            sb.append(", naOliInfo=");
            sb.append(this.naOliInfo.toString());
        }
        if (this.chargeNumber != null) {
            sb.append(", chargeNumber=");
            sb.append(this.chargeNumber.toString());
        }
        if (this.originalCalledPartyID != null) {
            sb.append(", originalCalledPartyID=");
            sb.append(this.originalCalledPartyID.toString());
        }
        if (this.callingPartyNumber != null) {
            sb.append(", callingPartyNumber=");
            sb.append(this.callingPartyNumber.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

