/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CriticalityType;
import org.mobicents.protocols.ss7.cap.api.primitives.ExtensionField;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;
import org.mobicents.protocols.ss7.map.primitives.OidContainer;

public class ExtensionFieldImpl
implements ExtensionField,
CAPAsnPrimitive {
    public static final int _ID_value = 1;
    private static final String DATA = "data";
    private static final String LOCAL_CODE = "localCode";
    private static final String GLOBAL_CODE = "globalCode";
    private static final String CRITICALITY_TYPE = "criticalityType";
    private static final String DEFAULT_STRING = null;
    public static final String _PrimitiveName = "ExtensionField";
    private Integer localCode;
    private long[] globalCode;
    private CriticalityType criticalityType;
    public byte[] data;
    protected static final XMLFormat<ExtensionFieldImpl> EXTENSION_FIELD_XML = new XMLFormat<ExtensionFieldImpl>(ExtensionFieldImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ExtensionFieldImpl extensionField) throws XMLStreamException {
            ByteArrayContainer bc;
            String criticalityType;
            String globalCode;
            long localCode = xml.getAttribute(ExtensionFieldImpl.LOCAL_CODE, Long.MIN_VALUE);
            if (localCode != Long.MIN_VALUE) {
                extensionField.localCode = (int)localCode;
            }
            if ((globalCode = xml.getAttribute(ExtensionFieldImpl.GLOBAL_CODE, DEFAULT_STRING)) != null) {
                OidContainer oid = new OidContainer();
                try {
                    oid.parseSerializedData(globalCode);
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException("NumberFormatException when parsing globalCode in extensionField", e);
                }
                ExtensionFieldImpl.access$202(extensionField, oid.getData());
            }
            if ((criticalityType = xml.getAttribute(ExtensionFieldImpl.CRITICALITY_TYPE, DEFAULT_STRING)) != null) {
                extensionField.setCriticalityType(Enum.valueOf(CriticalityType.class, criticalityType));
            }
            if ((bc = xml.get(ExtensionFieldImpl.DATA, ByteArrayContainer.class)) != null) {
                extensionField.data = bc.getData();
            }
        }

        @Override
        public void write(ExtensionFieldImpl extensionField, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (extensionField.localCode != null) {
                xml.setAttribute(ExtensionFieldImpl.LOCAL_CODE, extensionField.localCode);
            }
            if (extensionField.globalCode != null) {
                OidContainer oid = new OidContainer(extensionField.globalCode);
                xml.setAttribute(ExtensionFieldImpl.GLOBAL_CODE, oid.getSerializedData());
            }
            if (extensionField.criticalityType != null) {
                xml.setAttribute(ExtensionFieldImpl.CRITICALITY_TYPE, extensionField.criticalityType.toString());
            }
            if (extensionField.data != null) {
                ByteArrayContainer bac = new ByteArrayContainer(extensionField.data);
                xml.add(bac, ExtensionFieldImpl.DATA, ByteArrayContainer.class);
            }
        }
    };

    public ExtensionFieldImpl() {
    }

    public ExtensionFieldImpl(Integer localCode, CriticalityType criticalityType, byte[] data) {
        this.localCode = localCode;
        this.criticalityType = criticalityType;
        this.data = data;
    }

    public ExtensionFieldImpl(long[] globalCode, CriticalityType criticalityType, byte[] data) {
        this.globalCode = globalCode;
        this.criticalityType = criticalityType;
        this.data = data;
    }

    public Integer getLocalCode() {
        return this.localCode;
    }

    public long[] getGlobalCode() {
        return this.globalCode;
    }

    public CriticalityType getCriticalityType() {
        return this.criticalityType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setLocalCode(Integer localCode) {
        this.localCode = localCode;
        this.globalCode = null;
    }

    public void setGlobalCode(long[] globalCode) {
        this.localCode = null;
        this.globalCode = globalCode;
    }

    public void setCriticalityType(CriticalityType criticalityType) {
        this.criticalityType = criticalityType;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ExtensionField: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ExtensionField: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ExtensionField: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ExtensionField: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.localCode = null;
        this.globalCode = null;
        this.criticalityType = CriticalityType.typeIgnore;
        this.data = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new CAPParsingComponentException("Error while decoding ExtensionField: Parameter 0 bad tag class or not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    switch (tag) {
                        case 2: {
                            this.localCode = (int)ais.readInteger();
                            break block0;
                        }
                        case 6: {
                            this.globalCode = ais.readObjectIdentifier();
                            break block0;
                        }
                    }
                    throw new CAPParsingComponentException("Error while decoding ExtensionField: Parameter 0 bad tag", CAPParsingComponentExceptionReason.MistypedParameter);
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 0: {
                            if (tag == 10) {
                                int i1 = (int)ais.readInteger();
                                this.criticalityType = CriticalityType.getInstance(i1);
                                if (this.criticalityType != null) break block0;
                                throw new CAPParsingComponentException("Error while decoding ExtensionField: Bad criticalityType value", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            throw new CAPParsingComponentException("Error while decoding ExtensionField: Bad tag of the CLASS_UNIVERSAL field", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 2: {
                            if (tag == 1) {
                                int len = ais.readLength();
                                if (ais.available() < len) {
                                    throw new CAPParsingComponentException("Error while decoding ExtensionField: not enouph data for a value field", CAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.data = new byte[len];
                                ais.read(this.data);
                                break block0;
                            }
                            throw new CAPParsingComponentException("Error while decoding ExtensionField: Bad tag of the CLASS_CONTEXT_SPECIFIC field", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        default: {
                            throw new CAPParsingComponentException("Error while decoding ExtensionField: Parameter 1 or 2 has bad tag class", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                    }
                }
            }
            ++num;
        }
        if (this.data == null) {
            throw new CAPParsingComponentException("Error while decoding ExtensionField: value field is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ExtensionField: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            if (this.localCode == null && this.globalCode == null || this.localCode != null && this.globalCode != null) {
                throw new CAPException("Error while decoding ExtensionField: at least localCode or globalCode field must not be null");
            }
            if (this.data == null) {
                throw new CAPException("Error while decoding ExtensionField: value field must not be null");
            }
            if (this.localCode != null) {
                aos.writeInteger(this.localCode.intValue());
            } else {
                aos.writeObjectIdentifier(this.globalCode);
            }
            if (this.criticalityType != null && this.criticalityType != CriticalityType.typeIgnore) {
                aos.writeInteger(0, 10, this.criticalityType.getCode());
            }
            aos.writeTag(2, true, 1);
            int pos = aos.StartContentDefiniteLength();
            aos.write(this.data);
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ExtensionField: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ExtensionField: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.localCode != null) {
            sb.append("localCode=");
            sb.append(this.localCode);
        }
        if (this.globalCode != null) {
            sb.append("globalCode=[");
            sb.append(this.printDataArrLong(this.globalCode));
            sb.append("]");
        }
        if (this.criticalityType != null) {
            sb.append(", criticalityType=");
            sb.append((Object)this.criticalityType);
        }
        if (this.data != null) {
            sb.append(", data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArrLong(long[] arr) {
        StringBuilder sb = new StringBuilder();
        for (long b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }

    static /* synthetic */ long[] access$202(ExtensionFieldImpl x0, long[] x1) {
        x0.globalCode = x1;
        return x1;
    }
}

