/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnReferencedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ErrorCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnErrMessage;
import org.restcomm.protocols.ss7.sccp.parameter.ErrorCause;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class SccpConnErrMessageImpl
extends SccpConnReferencedMessageImpl
implements SccpConnErrMessage {
    protected ErrorCause errorCause;

    public SccpConnErrMessageImpl(int sls, int localSsn) {
        super(0, 15, sls, localSsn);
    }

    public SccpConnErrMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(0, 15, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public ErrorCause getErrorCause() {
        return this.errorCause;
    }

    @Override
    public void setErrorCause(ErrorCause value) {
        this.errorCause = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ErrorCauseImpl cause = new ErrorCauseImpl();
            cause.decode(buffer, factory, sccpProtocolVersion);
            this.errorCause = cause;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        if (this.type == 0) {
            return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
        }
        try {
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.errorCause == null) {
                return new EncodingResultData(EncodingResult.ErrorCauseMissing, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(5);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cause = ((ErrorCauseImpl)this.errorCause).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(cause);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=ERR");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" destLR=");
        if (this.destinationLocalReferenceNumber != null) {
            sb.append(this.destinationLocalReferenceNumber.getValue());
        }
        sb.append(" errorCause=");
        if (this.errorCause != null) {
            sb.append((Object)this.errorCause.getValue());
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

