/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.DefaultSMSHandling;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.SMSCAMELTDPData;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.SMSTriggerDetectionPoint;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;

public class SMSCAMELTDPDataImpl
extends SequenceBase
implements SMSCAMELTDPData {
    public static final int _TAG_smsTriggerDetectionPoint = 0;
    public static final int _TAG_serviceKey = 1;
    public static final int _TAG_gsmSCFAddress = 2;
    public static final int _TAG_defaultSMSHandling = 3;
    public static final int _TAG_extensionContainer = 4;
    private SMSTriggerDetectionPoint smsTriggerDetectionPoint;
    private long serviceKey;
    private ISDNAddressString gsmSCFAddress;
    private DefaultSMSHandling defaultSMSHandling;
    private MAPExtensionContainer extensionContainer;

    public SMSCAMELTDPDataImpl() {
        super("SMSCAMELTDPData");
    }

    public SMSCAMELTDPDataImpl(SMSTriggerDetectionPoint smsTriggerDetectionPoint, long serviceKey, ISDNAddressString gsmSCFAddress, DefaultSMSHandling defaultSMSHandling, MAPExtensionContainer extensionContainer) {
        super("SMSCAMELTDPData");
        this.smsTriggerDetectionPoint = smsTriggerDetectionPoint;
        this.serviceKey = serviceKey;
        this.gsmSCFAddress = gsmSCFAddress;
        this.defaultSMSHandling = defaultSMSHandling;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public SMSTriggerDetectionPoint getSMSTriggerDetectionPoint() {
        return this.smsTriggerDetectionPoint;
    }

    @Override
    public long getServiceKey() {
        return this.serviceKey;
    }

    @Override
    public ISDNAddressString getGsmSCFAddress() {
        return this.gsmSCFAddress;
    }

    @Override
    public DefaultSMSHandling getDefaultSMSHandling() {
        return this.defaultSMSHandling;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.smsTriggerDetectionPoint = null;
        this.serviceKey = -1L;
        this.gsmSCFAddress = null;
        this.defaultSMSHandling = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block10: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".smsTriggerDetectionPoint: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int code = (int)ais.readInteger();
                            this.smsTriggerDetectionPoint = SMSTriggerDetectionPoint.getInstance(code);
                            continue block10;
                        }
                        case 1: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".serviceKey: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.serviceKey = ais.readInteger();
                            continue block10;
                        }
                        case 2: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".offeredCamel4CSIs: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.gsmSCFAddress = new ISDNAddressStringImpl();
                            ((ISDNAddressStringImpl)this.gsmSCFAddress).decodeAll(ais);
                            continue block10;
                        }
                        case 3: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".csiActive: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int code = (int)ais.readInteger();
                            this.defaultSMSHandling = DefaultSMSHandling.getInstance(code);
                            continue block10;
                        }
                        case 4: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block10;
                        }
                    }
                    ais.advanceElement();
                    continue block10;
                }
            }
            ais.advanceElement();
        }
        if (this.smsTriggerDetectionPoint == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament smsTriggerDetectionPoint is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament gsmSCFAddress is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.defaultSMSHandling == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament defaultSMSHandling is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.serviceKey == -1L) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament serviceKey is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.smsTriggerDetectionPoint == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter smsTriggerDetectionPoint is not defined");
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter gsmSCFAddress is not defined");
        }
        if (this.defaultSMSHandling == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter defaultSMSHandling is not defined");
        }
        try {
            asnOs.writeInteger(2, 0, this.smsTriggerDetectionPoint.getCode());
            asnOs.writeInteger(2, 1, this.serviceKey);
            ((ISDNAddressStringImpl)this.gsmSCFAddress).encodeAll(asnOs, 2, 2);
            asnOs.writeInteger(2, 3, this.defaultSMSHandling.getCode());
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 4);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.smsTriggerDetectionPoint != null) {
            sb.append("smsTriggerDetectionPoint=");
            sb.append(this.smsTriggerDetectionPoint.toString());
            sb.append(", ");
        }
        sb.append("serviceKey=");
        sb.append(this.serviceKey);
        sb.append(", ");
        if (this.gsmSCFAddress != null) {
            sb.append("gsmSCFAddress=");
            sb.append(this.gsmSCFAddress.toString());
            sb.append(", ");
        }
        if (this.defaultSMSHandling != null) {
            sb.append("defaultSMSHandling=");
            sb.append(this.defaultSMSHandling.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

