/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import javax.xml.bind.DatatypeConverter;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ChargingCharacteristics;
import org.restcomm.protocols.ss7.map.primitives.OctetStringBase;

public class ChargingCharacteristicsImpl
extends OctetStringBase
implements ChargingCharacteristics {
    public static final int _FLAG_NORMAL_CHARGING = 8;
    public static final int _FLAG_PREPAID_CHARGING = 4;
    public static final int _FLAG_FLAT_RATE_CHARGING_CHARGING = 2;
    public static final int _FLAG_CHARGING_BY_HOT_BILLING_CHARGING = 1;
    private static final String DATA = "data";
    private static final String IS_NORMAL_CHARGING = "isNormalCharging";
    private static final String IS_PREPAID_CHARGING = "isPrepaidCharging";
    private static final String IS_FLAT_RATE_CHARGING = "isFlatRateChargingCharging";
    private static final String IS_BY_HOT_BILLING_CHARGING = "isChargingByHotBillingCharging";
    private static final String DEFAULT_VALUE = null;
    private static final boolean DEFAULT_BOOL_VALUE = false;
    protected static final XMLFormat<ChargingCharacteristicsImpl> CHARGING_CHARACTERISTICS_XML = new XMLFormat<ChargingCharacteristicsImpl>(ChargingCharacteristicsImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ChargingCharacteristicsImpl chargingCharacteristics) throws XMLStreamException {
            String s = xml.getAttribute(ChargingCharacteristicsImpl.DATA, DEFAULT_VALUE);
            if (s != null) {
                ChargingCharacteristicsImpl.access$102(chargingCharacteristics, DatatypeConverter.parseHexBinary((String)s));
            }
            boolean isNormalCharging = xml.getAttribute(ChargingCharacteristicsImpl.IS_NORMAL_CHARGING, false);
            boolean isPrepaidCharging = xml.getAttribute(ChargingCharacteristicsImpl.IS_PREPAID_CHARGING, false);
            boolean isFlatRateChargingCharging = xml.getAttribute(ChargingCharacteristicsImpl.IS_FLAT_RATE_CHARGING, false);
            boolean isChargingByHotBillingCharging = xml.getAttribute(ChargingCharacteristicsImpl.IS_BY_HOT_BILLING_CHARGING, false);
            chargingCharacteristics.setData(isNormalCharging, isPrepaidCharging, isFlatRateChargingCharging, isChargingByHotBillingCharging);
        }

        @Override
        public void write(ChargingCharacteristicsImpl chargingCharacteristics, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (chargingCharacteristics.data != null) {
                xml.setAttribute(ChargingCharacteristicsImpl.DATA, DatatypeConverter.printHexBinary((byte[])chargingCharacteristics.data));
            }
            xml.setAttribute(ChargingCharacteristicsImpl.IS_NORMAL_CHARGING, chargingCharacteristics.isNormalCharging());
            xml.setAttribute(ChargingCharacteristicsImpl.IS_PREPAID_CHARGING, chargingCharacteristics.isPrepaidCharging());
            xml.setAttribute(ChargingCharacteristicsImpl.IS_FLAT_RATE_CHARGING, chargingCharacteristics.isFlatRateChargingCharging());
            xml.setAttribute(ChargingCharacteristicsImpl.IS_BY_HOT_BILLING_CHARGING, chargingCharacteristics.isChargingByHotBillingCharging());
        }
    };

    public ChargingCharacteristicsImpl() {
        super(2, 2, "ChargingCharacteristics");
    }

    public ChargingCharacteristicsImpl(byte[] data) {
        super(2, 2, "ChargingCharacteristics", data);
    }

    public ChargingCharacteristicsImpl(boolean isNormalCharging, boolean isPrepaidCharging, boolean isFlatRateChargingCharging, boolean isChargingByHotBillingCharging) {
        super(2, 2, "ChargingCharacteristics");
        this.setData(isNormalCharging, isPrepaidCharging, isFlatRateChargingCharging, isChargingByHotBillingCharging);
    }

    protected void setData(boolean isNormalCharging, boolean isPrepaidCharging, boolean isFlatRateChargingCharging, boolean isChargingByHotBillingCharging) {
        this.data = new byte[2];
        if (isNormalCharging) {
            this.data[0] = (byte)(this.data[0] | 8);
        }
        if (isPrepaidCharging) {
            this.data[0] = (byte)(this.data[0] | 4);
        }
        if (isFlatRateChargingCharging) {
            this.data[0] = (byte)(this.data[0] | 2);
        }
        if (isChargingByHotBillingCharging) {
            this.data[0] = (byte)(this.data[0] | 1);
        }
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    private boolean isDataGoodFormed() {
        return this.data != null && this.data.length == 2;
    }

    @Override
    public boolean isNormalCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 8) != 0;
    }

    @Override
    public boolean isPrepaidCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 4) != 0;
    }

    @Override
    public boolean isFlatRateChargingCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 2) != 0;
    }

    @Override
    public boolean isChargingByHotBillingCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 1) != 0;
    }

    @Override
    public String toString() {
        if (this.isDataGoodFormed()) {
            boolean normalCharging = this.isNormalCharging();
            boolean prepaidCharging = this.isPrepaidCharging();
            boolean flatRateChargingCharging = this.isFlatRateChargingCharging();
            boolean chargingByHotBillingCharging = this.isChargingByHotBillingCharging();
            StringBuilder sb = new StringBuilder();
            sb.append(this._PrimitiveName);
            sb.append(" [Data= ");
            sb.append(this.printDataArr());
            if (normalCharging) {
                sb.append(", normalCharging");
            }
            if (prepaidCharging) {
                sb.append(", prepaidCharging");
            }
            if (flatRateChargingCharging) {
                sb.append(", flatRateChargingCharging");
            }
            if (chargingByHotBillingCharging) {
                sb.append(", chargingByHotBillingCharging");
            }
            sb.append("]");
            return sb.toString();
        }
        return super.toString();
    }

    static /* synthetic */ byte[] access$102(ChargingCharacteristicsImpl x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

