/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.EPSInfo;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.ISRInformation;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.PDNGWUpdate;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.ISRInformationImpl;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.PDNGWUpdateImpl;

public class EPSInfoImpl
implements EPSInfo,
MAPAsnPrimitive {
    public static final int _TAG_pndGwUpdate = 0;
    public static final int _TAG_isrInformation = 1;
    public static final String _PrimitiveName = "EPSInfo";
    private PDNGWUpdate pndGwUpdate;
    private ISRInformation isrInformation;

    public EPSInfoImpl() {
    }

    public EPSInfoImpl(PDNGWUpdate pndGwUpdate) {
        this.pndGwUpdate = pndGwUpdate;
        this.isrInformation = null;
    }

    public EPSInfoImpl(ISRInformation isrInformation) {
        this.pndGwUpdate = null;
        this.isrInformation = isrInformation;
    }

    @Override
    public PDNGWUpdate getPndGwUpdate() {
        return this.pndGwUpdate;
    }

    @Override
    public ISRInformation getIsrInformation() {
        return this.isrInformation;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.pndGwUpdate != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.pndGwUpdate == null;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding EPSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding EPSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding EPSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding EPSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.pndGwUpdate = null;
        this.isrInformation = null;
        int tag = ais.getTag();
        if (ais.getTagClass() != 2) {
            throw new MAPParsingComponentException("Error while decoding EPSInfo: Primitive has bad tag class", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (tag) {
            case 0: {
                if (ais.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding EPSInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.pndGwUpdate = new PDNGWUpdateImpl();
                ((PDNGWUpdateImpl)this.pndGwUpdate).decodeData(ais, length);
                break;
            }
            case 1: {
                if (!ais.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding EPSInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.isrInformation = new ISRInformationImpl();
                ((ISRInformationImpl)this.isrInformation).decodeData(ais, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding EPSInfo: bad choice tag", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding EPSInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.pndGwUpdate == null && this.isrInformation == null) {
            throw new MAPException("Error while encoding EPSInfo: all choices must not be null");
        }
        if (this.pndGwUpdate != null && this.isrInformation != null) {
            throw new MAPException("Error while encoding EPSInfo: all choices must not be not null");
        }
        if (this.pndGwUpdate != null) {
            ((PDNGWUpdateImpl)this.pndGwUpdate).encodeData(asnOs);
        } else {
            ((ISRInformationImpl)this.isrInformation).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.pndGwUpdate != null) {
            sb.append("pndGwUpdate=");
            sb.append(this.pndGwUpdate.toString());
        }
        if (this.isrInformation != null) {
            sb.append("isrInformation=");
            sb.append(this.isrInformation.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

