/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dialogic.oam;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.ss7.linkset.oam.FormatterHelp;
import org.mobicents.ss7.linkset.oam.Linkset;

public class DialogicLinkset
extends Linkset {
    private static final Logger logger = Logger.getLogger(DialogicLinkset.class);
    private static final String SRC_MODULE = "srcMod";
    private static final String DEST_MODULE = "destMod";
    private int sourceModule;
    private int destModule;
    protected static final XMLFormat<DialogicLinkset> DAHDI_LINK_XML = new XMLFormat<DialogicLinkset>(DialogicLinkset.class){

        @Override
        public void read(XMLFormat.InputElement xml, DialogicLinkset linkset) throws XMLStreamException {
            LINKSET_XML.read(xml, linkset);
            linkset.sourceModule = xml.getAttribute(DialogicLinkset.SRC_MODULE, -1);
            linkset.destModule = xml.getAttribute(DialogicLinkset.DEST_MODULE, -1);
            try {
                linkset.configure();
            }
            catch (Exception e) {
                logger.error("Failed to initialize dialogic card", e);
            }
        }

        @Override
        public void write(DialogicLinkset linkset, XMLFormat.OutputElement xml) throws XMLStreamException {
            LINKSET_XML.write(linkset, xml);
            xml.setAttribute(DialogicLinkset.SRC_MODULE, linkset.sourceModule);
            xml.setAttribute(DialogicLinkset.DEST_MODULE, linkset.destModule);
        }
    };

    public DialogicLinkset() {
    }

    public DialogicLinkset(String linksetName, int opc, int dpc, int ni, int srcMod, int dstMod) {
        super(linksetName, opc, dpc, ni);
        this.sourceModule = srcMod;
        this.destModule = dstMod;
    }

    public int getSourceModule() {
        return this.sourceModule;
    }

    public void setSourceModule(int sourceModule) {
        this.sourceModule = sourceModule;
    }

    public int getDestModule() {
        return this.destModule;
    }

    public void setDestModule(int destModule) {
        this.destModule = destModule;
    }

    protected void initialize() {
    }

    protected void configure() throws Exception {
        if (this.mode == 2) {
            // empty if block
        }
    }

    public void activate() throws Exception {
        if (this.state == 3) {
            throw new Exception("Linkset already active");
        }
        this.mode = 2;
        this.configure();
    }

    public void deactivate() throws Exception {
        throw new Exception("Not implemented yet");
    }

    public void activateLink(String linkName) throws Exception {
        throw new Exception("Operation not supported");
    }

    public void deactivateLink(String linkName) throws Exception {
        throw new Exception("Operation not supported");
    }

    public void createLink(String[] arg0) throws Exception {
        throw new Exception("Not implemented yet");
    }

    public void deleteLink(String arg0) throws Exception {
        throw new Exception("Not implemented yet");
    }

    public void print(StringBuffer sb, int leftPad, int descPad) {
        FormatterHelp.createPad(sb, leftPad);
        sb.append(this.linksetName);
        if (this.linksetName.length() < 10) {
            FormatterHelp.createPad(sb, 10 - this.linksetName.length());
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append("dialogic");
        FormatterHelp.createPad(sb, descPad);
        sb.append("opc").append("=").append(this.opc);
        int length = Integer.toString(this.opc).length();
        if (length < 8) {
            FormatterHelp.createPad(sb, 8 - length);
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append("apc").append("=").append(this.apc);
        length = Integer.toString(this.apc).length();
        if (length < 8) {
            FormatterHelp.createPad(sb, 8 - length);
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append("ni").append("=").append(this.ni);
        FormatterHelp.createPad(sb, descPad);
        sb.append(SRC_MODULE).append("=").append(this.sourceModule);
        FormatterHelp.createPad(sb, descPad);
        sb.append(DEST_MODULE).append("=").append(this.destModule);
        FormatterHelp.createPad(sb, descPad);
        sb.append("state").append("=").append(FormatterHelp.getLinksetState(this.state));
        sb.append("\n");
    }
}

