/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.mtp;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3Primitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitiveFactory;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPart;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPartListener;
import org.mobicents.protocols.ss7.mtp.RoutingLabelFormat;

public abstract class Mtp3UserPartBaseImpl
implements Mtp3UserPart {
    private static final Logger logger = Logger.getLogger(Mtp3UserPartBaseImpl.class);
    private static final String LICENSE_PRODUCT_NAME = "Mobicents-jSS7";
    private int maxSls = 32;
    private int slsFilter = 31;
    protected int deliveryTransferMessageThreadCount = Runtime.getRuntime().availableProcessors() * 2;
    protected boolean isStarted = false;
    private CopyOnWriteArrayList<Mtp3UserPartListener> userListeners = new CopyOnWriteArrayList();
    private ExecutorService[] msgDeliveryExecutors;
    private ExecutorService msgDeliveryExecutorSystem;
    private int[] slsTable = null;
    private RoutingLabelFormat routingLabelFormat = RoutingLabelFormat.ITU;
    private Mtp3TransferPrimitiveFactory mtp3TransferPrimitiveFactory = null;
    private boolean useLsbForLinksetSelection = false;
    private final String productName;

    public Mtp3UserPartBaseImpl(String productName) {
        this.productName = productName == null ? LICENSE_PRODUCT_NAME : productName;
    }

    public int getDeliveryMessageThreadCount() {
        return this.deliveryTransferMessageThreadCount;
    }

    public void setDeliveryMessageThreadCount(int deliveryMessageThreadCount) {
        if (deliveryMessageThreadCount > 0) {
            this.deliveryTransferMessageThreadCount = deliveryMessageThreadCount;
        }
    }

    public void addMtp3UserPartListener(Mtp3UserPartListener listener) {
        this.userListeners.add(listener);
    }

    public void removeMtp3UserPartListener(Mtp3UserPartListener listener) {
        this.userListeners.remove(listener);
    }

    public int getMaxUserDataLength(int dpc) {
        switch (this.routingLabelFormat) {
            case ITU: {
                return 268;
            }
            case ANSI_Sls8Bit: {
                return 265;
            }
        }
        return -1;
    }

    public RoutingLabelFormat getRoutingLabelFormat() {
        return this.routingLabelFormat;
    }

    public void setRoutingLabelFormat(RoutingLabelFormat routingLabelFormat) {
        this.routingLabelFormat = routingLabelFormat;
    }

    public Mtp3TransferPrimitiveFactory getMtp3TransferPrimitiveFactory() {
        return this.mtp3TransferPrimitiveFactory;
    }

    public boolean isUseLsbForLinksetSelection() {
        return this.useLsbForLinksetSelection;
    }

    public void setUseLsbForLinksetSelection(boolean useLsbForLinksetSelection) {
        this.useLsbForLinksetSelection = useLsbForLinksetSelection;
    }

    public void start() throws Exception {
        if (this.isStarted) {
            return;
        }
        if (this.routingLabelFormat != RoutingLabelFormat.ITU && this.routingLabelFormat != RoutingLabelFormat.ANSI_Sls8Bit) {
            throw new Exception("Invalid PointCodeFormat set. We support only ITU or ANSI now");
        }
        switch (this.routingLabelFormat) {
            case ITU: {
                this.maxSls = 16;
                this.slsFilter = 15;
                break;
            }
            case ANSI_Sls5Bit: {
                this.maxSls = 32;
                this.slsFilter = 31;
                break;
            }
            case ANSI_Sls8Bit: {
                this.maxSls = 256;
                this.slsFilter = 255;
                break;
            }
            default: {
                throw new Exception("Invalid SLS length");
            }
        }
        this.slsTable = new int[this.maxSls];
        this.mtp3TransferPrimitiveFactory = new Mtp3TransferPrimitiveFactory(this.routingLabelFormat);
        this.createSLSTable(this.deliveryTransferMessageThreadCount);
        this.msgDeliveryExecutors = new ExecutorService[this.deliveryTransferMessageThreadCount];
        for (int i = 0; i < this.deliveryTransferMessageThreadCount; ++i) {
            this.msgDeliveryExecutors[i] = Executors.newFixedThreadPool(1);
        }
        this.msgDeliveryExecutorSystem = Executors.newFixedThreadPool(1);
        this.isStarted = true;
    }

    public void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        for (ExecutorService es : this.msgDeliveryExecutors) {
            es.shutdown();
        }
        this.msgDeliveryExecutorSystem.shutdown();
    }

    protected void sendTransferMessageToLocalUser(Mtp3TransferPrimitive msg, int seqControl) {
        if (this.isStarted) {
            MsgTransferDeliveryHandler hdl = new MsgTransferDeliveryHandler(msg);
            this.msgDeliveryExecutors[this.slsTable[seqControl &= this.slsFilter]].execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3TransferPrimitive=%s but Mtp3UserPart is not started. Message will be dropped", msg));
        }
    }

    protected void sendPauseMessageToLocalUser(Mtp3PausePrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3PausePrimitive=%s but Mtp3PausePrimitive is not started. Message will be dropped", msg));
        }
    }

    protected void sendResumeMessageToLocalUser(Mtp3ResumePrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3ResumePrimitive=%s but Mtp3PausePrimitive is not started. Message will be dropped", msg));
        }
    }

    protected void sendStatusMessageToLocalUser(Mtp3StatusPrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3StatusPrimitive=%s but Mtp3PausePrimitive is not started. Message will be dropped", msg));
        }
    }

    private void createSLSTable(int minimumBoundThread) {
        int stream = 0;
        for (int i = 0; i < this.maxSls; ++i) {
            if (stream >= minimumBoundThread) {
                stream = 0;
            }
            this.slsTable[i] = stream++;
        }
    }

    private class MsgSystemDeliveryHandler
    implements Runnable {
        Mtp3Primitive msg;

        public MsgSystemDeliveryHandler(Mtp3Primitive msg) {
            this.msg = msg;
        }

        public void run() {
            if (Mtp3UserPartBaseImpl.this.isStarted) {
                try {
                    for (Mtp3UserPartListener lsn : Mtp3UserPartBaseImpl.this.userListeners) {
                        if (this.msg.getType() == 3) {
                            lsn.onMtp3PauseMessage((Mtp3PausePrimitive)this.msg);
                        }
                        if (this.msg.getType() == 4) {
                            lsn.onMtp3ResumeMessage((Mtp3ResumePrimitive)this.msg);
                        }
                        if (this.msg.getType() != 5) continue;
                        lsn.onMtp3StatusMessage((Mtp3StatusPrimitive)this.msg);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while delivering a payload messages to the MTP3-user: " + e.getMessage(), e);
                }
            } else {
                logger.error(String.format("Received Mtp3Primitive=%s but Mtp3UserPart is not started. Message will be dropped", this.msg));
            }
        }
    }

    private class MsgTransferDeliveryHandler
    implements Runnable {
        private Mtp3TransferPrimitive msg;

        public MsgTransferDeliveryHandler(Mtp3TransferPrimitive msg) {
            this.msg = msg;
        }

        public void run() {
            if (Mtp3UserPartBaseImpl.this.isStarted) {
                try {
                    for (Mtp3UserPartListener lsn : Mtp3UserPartBaseImpl.this.userListeners) {
                        lsn.onMtp3TransferMessage(this.msg);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while delivering a system messages to the MTP3-user: " + e.getMessage(), e);
                }
            } else {
                logger.error(String.format("Received Mtp3TransferPrimitive=%s but Mtp3UserPart is not started. Message will be dropped", this.msg));
            }
        }
    }
}

