/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.imei;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMEI;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.RequestedEquipmentInfo;
import org.mobicents.protocols.ss7.map.primitives.IMEIImpl;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;
import org.mobicents.protocols.ss7.map.service.mobility.imei.RequestedEquipmentInfoImpl;

public class CheckImeiRequestImpl
extends MobilityMessageImpl
implements CheckImeiRequest {
    public static final String _PrimitiveName = "CheckImeiRequest";
    private IMEI imei = null;
    private RequestedEquipmentInfo requestedEquipmentInfo = null;
    private MAPExtensionContainer extensionContainer = null;
    private IMSI imsi = null;
    private long mapProtocolVersion;
    private int encodedLength;

    public CheckImeiRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public CheckImeiRequestImpl(long mapProtocolVersion, IMEI imei, RequestedEquipmentInfo requestedEquipmentInfo, MAPExtensionContainer extensionContainer) {
        this.mapProtocolVersion = mapProtocolVersion;
        this.imei = imei;
        this.requestedEquipmentInfo = requestedEquipmentInfo;
        this.extensionContainer = extensionContainer;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 16;
        }
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public IMSI getIMSI() {
        return this.imsi;
    }

    public void setIMSI(IMSI imsi) {
        this.imsi = imsi;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CheckImeiRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CheckImeiRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding CheckImeiRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding CheckImeiRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imei = null;
        this.requestedEquipmentInfo = null;
        this.extensionContainer = null;
        this.imsi = null;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                switch (num) {
                    case 0: {
                        if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CheckImeiRequest.imei: bad tag or tag class or is not primitive: TagClass=" + ais.getTagClass() + ", tag=" + tag, MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imei = new IMEIImpl();
                        ((IMEIImpl)this.imei).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (tag != 3 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding CheckImeiRequest.requestedEquipmentInfo: bad tag or tag class or is not primitive: TagClass=" + ais.getTagClass() + ", tag=" + tag, MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.requestedEquipmentInfo = new RequestedEquipmentInfoImpl();
                        ((RequestedEquipmentInfoImpl)this.requestedEquipmentInfo).decodeAll(ais);
                        break;
                    }
                    default: {
                        if (tag == 16 && ais.getTagClass() == 0) {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding CheckImeiRequest: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break;
                        }
                        ais.advanceElement();
                    }
                }
                ++num;
            }
            if (num < 2) {
                throw new MAPParsingComponentException("Error while decoding CheckImeiRequest: Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else {
            this.imei = new IMEIImpl();
            ((IMEIImpl)this.imei).decodeData(ansIS, length);
            if (ansIS.available() != 0) {
                int tag = ansIS.readTag();
                length = ansIS.readLength();
                if (tag != 0 && ansIS.getTagClass() != 0 && !ansIS.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding CheckImeiRequest.imsi: bad tag or tag class or is not primitive: TagClass=" + ansIS.getTagClass() + ", tag=" + tag, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.imsi = new IMSIImpl();
                ((IMSIImpl)this.imsi).decodeData(ansIS, length);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            if (this.imsi == null) {
                int pos = asnOs.StartContentDefiniteLength();
                this.encodeData(asnOs);
                asnOs.FinalizeContent(pos);
            } else {
                AsnOutputStream tempAos = new AsnOutputStream();
                this.encodeData(tempAos);
                asnOs.writeLength(this.getEncodedLength());
                this.encodeData(asnOs);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding CheckImeiRequest: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding CheckImeiRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imei == null) {
            throw new MAPException("imei parameter must not be null");
        }
        if (this.mapProtocolVersion >= 3L) {
            if (this.requestedEquipmentInfo == null) {
                throw new MAPException("requestedEquipmentInfo parameter must not be null");
            }
            ((IMEIImpl)this.imei).encodeAll(asnOs);
            ((RequestedEquipmentInfoImpl)this.requestedEquipmentInfo).encodeAll(asnOs);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        } else {
            ((IMEIImpl)this.imei).encodeData(asnOs);
            this.encodedLength = asnOs.size();
            if (this.imsi != null) {
                ((IMSIImpl)this.imsi).encodeAll(asnOs, 0, 0);
            }
        }
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.checkIMEI_Request;
    }

    public int getOperationCode() {
        return 43;
    }

    public IMEI getIMEI() {
        return this.imei;
    }

    public RequestedEquipmentInfo getRequestedEquipmentInfo() {
        return this.requestedEquipmentInfo;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imei != null) {
            sb.append("imei=");
            sb.append(this.imei.toString());
            sb.append(", ");
        }
        if (this.requestedEquipmentInfo != null) {
            sb.append("requestedEquipmentInfo=");
            sb.append(this.requestedEquipmentInfo.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

