/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CollectedDigits;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CollectedInfo;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CollectedDigitsImpl;

public class CollectedInfoImpl
implements CollectedInfo,
CAPAsnPrimitive {
    public static final int _ID_collectedDigits = 0;
    public static final String _PrimitiveName = "CollectedInfo";
    private static final String COLLECTED_DIGITS = "collectedDigits";
    private CollectedDigits collectedDigits;
    protected static final XMLFormat<CollectedInfoImpl> COLLECTED_INFO_XML = new XMLFormat<CollectedInfoImpl>(CollectedInfoImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CollectedInfoImpl collectedInfo) throws XMLStreamException {
            collectedInfo.collectedDigits = xml.get(CollectedInfoImpl.COLLECTED_DIGITS, CollectedDigitsImpl.class);
            int choiceCount = 0;
            if (collectedInfo.collectedDigits != null) {
                ++choiceCount;
            }
            if (choiceCount != 1) {
                throw new XMLStreamException("CollectedInfo decoding error: there must be one choice selected, found: " + choiceCount);
            }
        }

        @Override
        public void write(CollectedInfoImpl collectedInfo, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (collectedInfo.collectedDigits != null) {
                xml.add((CollectedDigitsImpl)collectedInfo.collectedDigits, CollectedInfoImpl.COLLECTED_DIGITS, CollectedDigitsImpl.class);
            }
        }
    };

    public CollectedInfoImpl() {
    }

    public CollectedInfoImpl(CollectedDigits collectedDigits) {
        this.collectedDigits = collectedDigits;
    }

    public CollectedDigits getCollectedDigits() {
        return this.collectedDigits;
    }

    public int getTag() throws CAPException {
        if (this.collectedDigits != null) {
            return 0;
        }
        throw new CAPException("Error while encoding CollectedInfo: no of choices has been definite");
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CollectedInfo: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CollectedInfo: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CollectedInfo: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CollectedInfo: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.collectedDigits = null;
        if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding CollectedInfo: bad tagClass or is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.collectedDigits = new CollectedDigitsImpl();
                ((CollectedDigitsImpl)this.collectedDigits).decodeData(ais, length);
                break;
            }
            default: {
                throw new CAPParsingComponentException("Error while decoding CollectedInfo: bad tag: " + ais.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CollectedInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        int choiceCnt = 0;
        if (this.collectedDigits != null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPException("Error while encoding CollectedInfo: only one choice must be definite, found: " + choiceCnt);
        }
        if (this.collectedDigits != null) {
            ((CollectedDigitsImpl)this.collectedDigits).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.collectedDigits != null) {
            sb.append("collectedDigits=");
            sb.append(this.collectedDigits.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

