/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.scheduler;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntConcurrentLinkedList<E> {
    private Node<E> head = new Node<Object>(-1, null);
    private Node<E> tail = new Node<Object>(-1, null);
    private Node<E> cacheHead = new Node<Object>(-1, null);
    private Node<E> cacheTail = new Node<Object>(-1, null);
    private Node<E> tempNode;
    private Object searchNode;
    private Integer size = 0;
    private Integer cacheSize = 0;
    private ListIterator iterator = new ListIterator();
    private Lock lock = new Lock();

    public IntConcurrentLinkedList() {
        this.head.next = this.tail;
        this.tail.previous = this.head;
        this.cacheHead.next = this.cacheTail;
        this.cacheTail.previous = this.cacheHead;
    }

    public boolean contains(int key) {
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && key != this.tempNode.key) {
            this.tempNode = this.tempNode.next;
        }
        if (this.tempNode.element == null) {
            this.releaseAccess();
            return true;
        }
        this.releaseAccess();
        return false;
    }

    public boolean add(E value, int key) {
        Integer n;
        Integer n2;
        if (value == null) {
            return false;
        }
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && key != this.tempNode.key) {
            this.tempNode = this.tempNode.next;
        }
        if (this.tempNode.element != null) {
            this.releaseAccess();
            return false;
        }
        if (this.cacheSize == 0) {
            this.tempNode = new Node<E>(key, value);
        } else {
            this.tempNode = this.cacheHead.next;
            this.cacheHead.next = this.tempNode.next;
            this.cacheHead.next.previous = this.cacheHead;
            this.tempNode.key = key;
            this.tempNode.element = value;
            n2 = this.cacheSize;
            n = this.cacheSize = Integer.valueOf(this.cacheSize - 1);
        }
        this.tail.previous.next = this.tempNode;
        this.tempNode.previous = this.tail.previous;
        this.tempNode.next = this.tail;
        this.tail.previous = this.tempNode;
        n2 = this.size;
        n = this.size = Integer.valueOf(this.size + 1);
        this.releaseAccess();
        return true;
    }

    public boolean offer(E value, int key) {
        Integer n;
        Integer n2;
        if (value == null) {
            return false;
        }
        this.aquireAccess();
        if (this.cacheSize == 0) {
            this.tempNode = new Node<E>(key, value);
        } else {
            this.tempNode = this.cacheHead.next;
            this.cacheHead.next = this.tempNode.next;
            this.cacheHead.next.previous = this.cacheHead;
            this.tempNode.key = key;
            this.tempNode.element = value;
            n2 = this.cacheSize;
            n = this.cacheSize = Integer.valueOf(this.cacheSize - 1);
        }
        this.tail.previous.next = this.tempNode;
        this.tempNode.previous = this.tail.previous;
        this.tempNode.next = this.tail;
        this.tail.previous = this.tempNode;
        n2 = this.size;
        n = this.size = Integer.valueOf(this.size + 1);
        this.releaseAccess();
        return true;
    }

    public E get(int key) {
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && key != this.tempNode.key) {
            this.tempNode = this.tempNode.next;
        }
        Object result = this.tempNode.element;
        this.releaseAccess();
        return result;
    }

    public E remove(int key) {
        this.aquireAccess();
        this.tempNode = this.head.next;
        while (this.tempNode.element != null && key != this.tempNode.key) {
            this.tempNode = this.tempNode.next;
        }
        if (this.tempNode.element == null) {
            this.releaseAccess();
            return null;
        }
        this.tempNode.previous.next = this.tempNode.next;
        this.tempNode.next.previous = this.tempNode.previous;
        Integer n = this.size;
        Integer n2 = this.size = Integer.valueOf(this.size - 1);
        this.tempNode.next = this.cacheHead.next;
        this.cacheHead.next = this.tempNode;
        this.tempNode.previous = this.cacheHead;
        this.tempNode.next.previous = this.tempNode;
        Object result = this.tempNode.element;
        this.releaseAccess();
        return result;
    }

    public void clear() {
        this.aquireAccess();
        if (this.size > 0) {
            this.cacheSize = this.cacheSize + this.size;
            this.size = 0;
            this.tail.previous.next = this.cacheHead.next;
            this.cacheHead.next.previous = this.tail.previous;
            this.cacheHead.next = this.head.next;
            this.head.next.previous = this.cacheHead;
            this.head.next = this.tail;
            this.tail.previous = this.head;
        }
        this.releaseAccess();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public Iterator<E> iterator() {
        this.iterator.currNode = this.head;
        return this.iterator;
    }

    private void aquireAccess() {
        try {
            this.lock.lock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void releaseAccess() {
        this.lock.unlock();
    }

    private class Lock {
        protected boolean locked = false;

        public synchronized void lock() throws InterruptedException {
            while (this.locked) {
                this.wait();
            }
            this.locked = true;
        }

        public synchronized void unlock() {
            this.locked = false;
            this.notify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIterator
    implements Iterator<E> {
        private Node<E> currNode;

        public ListIterator() {
            this.currNode = IntConcurrentLinkedList.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.currNode.next.element != null;
        }

        @Override
        public E next() {
            IntConcurrentLinkedList.this.aquireAccess();
            Object result = this.currNode.next.element;
            this.currNode = this.currNode.next;
            IntConcurrentLinkedList.this.releaseAccess();
            return result;
        }

        @Override
        public void remove() {
            IntConcurrentLinkedList.this.aquireAccess();
            IntConcurrentLinkedList.this.tempNode = this.currNode;
            this.currNode = this.currNode.next;
            ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.previous.next = ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.next;
            ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.next.previous = ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.previous;
            Integer n = IntConcurrentLinkedList.this.size;
            Integer n2 = IntConcurrentLinkedList.this.size = IntConcurrentLinkedList.this.size - 1;
            ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.next = ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).cacheHead.next;
            ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).cacheHead.next = IntConcurrentLinkedList.this.tempNode;
            ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.previous = IntConcurrentLinkedList.this.cacheHead;
            ((IntConcurrentLinkedList)IntConcurrentLinkedList.this).tempNode.next.previous = IntConcurrentLinkedList.this.tempNode;
            IntConcurrentLinkedList.this.releaseAccess();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node<E> {
        int key;
        E element;
        Node<E> next;
        Node<E> previous;

        Node(int key, E element) {
            this.key = key;
            this.element = element;
        }
    }
}

