/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaDefinition;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaEventInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.OccurrenceInfo;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.lsm.AreaDefinitionImpl;

public class AreaEventInfoImpl
extends SequenceBase
implements AreaEventInfo {
    private static final int _TAG_areaDefinition = 0;
    private static final int _TAG_OCCURRENCE_INFO = 1;
    private static final int _TAG_INTERVAL_TIME = 2;
    private AreaDefinition areaDefinition;
    private OccurrenceInfo occurrenceInfo;
    private Integer intervalTime;

    public AreaEventInfoImpl() {
        super("AreaEventInfo");
    }

    public AreaEventInfoImpl(AreaDefinition areaDefinition, OccurrenceInfo occurrenceInfo, Integer intervalTime) {
        super("AreaEventInfo");
        this.areaDefinition = areaDefinition;
        this.occurrenceInfo = occurrenceInfo;
        this.intervalTime = intervalTime;
    }

    public AreaDefinition getAreaDefinition() {
        return this.areaDefinition;
    }

    public OccurrenceInfo getOccurrenceInfo() {
        return this.occurrenceInfo;
    }

    public Integer getIntervalTime() {
        return this.intervalTime;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.areaDefinition = null;
        this.occurrenceInfo = null;
        this.intervalTime = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 0 [areaDefinition [0] AreaDefinition] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.areaDefinition = new AreaDefinitionImpl();
        ((AreaDefinitionImpl)this.areaDefinition).decodeAll(ais);
        block4: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 1 [occurrenceInfo [1] OccurrenceInfo] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.occurrenceInfo = OccurrenceInfo.getOccurrenceInfo(i1);
                        continue block4;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter 2 [intervalTime [2] IntervalTime] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.intervalTime = (int)ais.readInteger();
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.areaDefinition == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter[areaDefinition [0] AreaDefinition] is not defined");
        }
        ((AreaDefinitionImpl)this.areaDefinition).encodeAll(asnOs, 2, 0);
        try {
            if (this.occurrenceInfo != null) {
                asnOs.writeInteger(2, 1, this.occurrenceInfo.getInfo());
            }
            if (this.intervalTime != null) {
                asnOs.writeInteger(2, 2, this.intervalTime.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.areaDefinition == null ? 0 : this.areaDefinition.hashCode());
        result = 31 * result + (this.occurrenceInfo == null ? 0 : this.occurrenceInfo.getInfo());
        result = 31 * result + (this.intervalTime == null ? 0 : this.intervalTime);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AreaEventInfoImpl other = (AreaEventInfoImpl)obj;
        if (this.areaDefinition == null ? other.areaDefinition != null : !this.areaDefinition.equals(other.areaDefinition)) {
            return false;
        }
        if (this.occurrenceInfo == null ? other.occurrenceInfo != null : this.occurrenceInfo != other.occurrenceInfo) {
            return false;
        }
        return !(this.intervalTime == null ? other.intervalTime != null : this.intervalTime.intValue() != other.intervalTime.intValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.areaDefinition != null) {
            sb.append("areaDefinition=");
            sb.append(this.areaDefinition);
        }
        if (this.occurrenceInfo != null) {
            sb.append(", occurrenceInfo=");
            sb.append(this.occurrenceInfo.toString());
        }
        if (this.intervalTime != null) {
            sb.append(", intervalTime=");
            sb.append(this.intervalTime.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

