/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.CUGRejectCause;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageCUGReject;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class MAPErrorMessageCUGRejectImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageCUGReject {
    private static final String CUG_REJECT_CAUSE = "cugRejectCause";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    private CUGRejectCause cugRejectCause;
    private MAPExtensionContainer extensionContainer;
    protected String _PrimitiveName = "MAPErrorMessageCUGReject";
    protected static final XMLFormat<MAPErrorMessageCUGRejectImpl> MAP_ERROR_MESSAGE_CALL_BARRED_XML = new XMLFormat<MAPErrorMessageCUGRejectImpl>(MAPErrorMessageCUGRejectImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, MAPErrorMessageCUGRejectImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, errorMessage);
            String str = xml.get(MAPErrorMessageCUGRejectImpl.CUG_REJECT_CAUSE, String.class);
            if (str != null) {
                errorMessage.cugRejectCause = Enum.valueOf(CUGRejectCause.class, str);
            }
            errorMessage.extensionContainer = xml.get(MAPErrorMessageCUGRejectImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        @Override
        public void write(MAPErrorMessageCUGRejectImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write(errorMessage, xml);
            if (errorMessage.getCUGRejectCause() != null) {
                xml.add(errorMessage.getCUGRejectCause().toString(), MAPErrorMessageCUGRejectImpl.CUG_REJECT_CAUSE, String.class);
            }
            xml.add((MAPExtensionContainerImpl)errorMessage.extensionContainer, MAPErrorMessageCUGRejectImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageCUGRejectImpl(CUGRejectCause cugRejectCause, MAPExtensionContainer extensionContainer) {
        super(15L);
        this.cugRejectCause = cugRejectCause;
        this.extensionContainer = extensionContainer;
    }

    public MAPErrorMessageCUGRejectImpl() {
        super(15L);
    }

    public boolean isEmCUGReject() {
        return true;
    }

    public MAPErrorMessageCUGReject getEmCUGReject() {
        return this;
    }

    public CUGRejectCause getCUGRejectCause() {
        return this.cugRejectCause;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public void setCUGRejectCause(CUGRejectCause val) {
        this.cugRejectCause = val;
    }

    public void setExtensionContainer(MAPExtensionContainer val) {
        this.extensionContainer = val;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.cugRejectCause = null;
        this.extensionContainer = null;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 16 || localAis.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": bad tag class or tag or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AsnInputStream ais = localAis.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 16: {
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break block0;
                        }
                        case 10: {
                            int i1 = (int)ais.readInteger();
                            this.cugRejectCause = CUGRejectCause.getInstance(i1);
                            break block0;
                        }
                    }
                    ais.advanceElement();
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.cugRejectCause == null && this.extensionContainer == null) {
            return;
        }
        try {
            if (this.cugRejectCause != null) {
                asnOs.writeInteger(0, 10, this.cugRejectCause.getCode());
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.cugRejectCause != null) {
            sb.append("cugRejectCause=" + this.cugRejectCause.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=" + this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

