/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.oam;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPDialogOam;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPServiceOam;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPServiceOamListener;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.oam.ActivateTraceModeRequestImpl_Oam;
import org.mobicents.protocols.ss7.map.service.oam.ActivateTraceModeResponseImpl_Oam;
import org.mobicents.protocols.ss7.map.service.oam.MAPDialogOamImpl;
import org.mobicents.protocols.ss7.map.service.oam.SendImsiRequestImpl;
import org.mobicents.protocols.ss7.map.service.oam.SendImsiResponseImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceOamImpl
extends MAPServiceBaseImpl
implements MAPServiceOam {
    protected Logger loger = Logger.getLogger(MAPServiceOamImpl.class);

    public MAPServiceOamImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogOam createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        return this.createNewDialog(appCntx, origAddress, origReference, destAddress, destReference, null);
    }

    public MAPDialogOam createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference, Long localTrId) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogOam because MAPServiceOam is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        MAPDialogOamImpl dialog = new MAPDialogOamImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.putMAPDialogIntoCollection(dialog);
        return dialog;
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogOamImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceOamListener mapServiceListener) {
        super.addMAPServiceListener(mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceOamListener mapServiceListener) {
        super.removeMAPServiceListener(mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case imsiRetrievalContext: {
                if (vers >= 2 && vers <= 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case tracingContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName(altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public MAPApplicationContext getMAPv1ApplicationContext(int operationCode, Invoke invoke) {
        switch (operationCode) {
            case 50: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.tracingContext, MAPApplicationContextVersion.version1);
            }
        }
        return null;
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        if (compType != ComponentType.Invoke || this.mapProviderImpl.isCongested()) {
            // empty if block
        }
        MAPDialogOamImpl mapDialogOamImpl = (MAPDialogOamImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        MAPApplicationContextName acn = mapDialog.getApplicationContext().getApplicationContextName();
        int vers = mapDialog.getApplicationContext().getApplicationContextVersion().getVersion();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 50: {
                if (acn != MAPApplicationContextName.tracingContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processActivateTraceModeRequest(parameter, mapDialogOamImpl, invokeId);
                    break;
                }
                this.processActivateTraceModeResponse(parameter, mapDialogOamImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 58: {
                if (acn != MAPApplicationContextName.imsiRetrievalContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processSendImsiRequest(parameter, mapDialogOamImpl, invokeId);
                    break;
                }
                this.processSendImsiResponse(parameter, mapDialogOamImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            default: {
                throw new MAPParsingComponentException("MAPServiceOam: unknown incoming operation code: " + ocValueInt, MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void processActivateTraceModeRequest(Parameter parameter, MAPDialogOamImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding processActivateTraceModeRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding processActivateTraceModeRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ActivateTraceModeRequestImpl_Oam ind = new ActivateTraceModeRequestImpl_Oam();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceOamListener)serLis).onActivateTraceModeRequest_Oam(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing processActivateTraceModeRequest: " + e.getMessage(), e);
            }
        }
    }

    private void processActivateTraceModeResponse(Parameter parameter, MAPDialogOamImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        ActivateTraceModeResponseImpl_Oam ind = new ActivateTraceModeResponseImpl_Oam();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding processActivateTraceModeResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                ((MAPServiceOamListener)serLis).onActivateTraceModeResponse_Oam(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing processActivateTraceModeResponse: " + e.getMessage(), e);
            }
        }
    }

    private void processSendImsiRequest(Parameter parameter, MAPDialogOamImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding processSendImsiRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding processSendImsiRequest: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendImsiRequestImpl ind = new SendImsiRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceOamListener)serLis).onSendImsiRequest(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing processSendImsiRequest: " + e.getMessage(), e);
            }
        }
    }

    private void processSendImsiResponse(Parameter parameter, MAPDialogOamImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding processSendImsiResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding processSendImsiResponse: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        SendImsiResponseImpl ind = new SendImsiResponseImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceOamListener)serLis).onSendImsiResponse(ind);
            }
            catch (Exception e) {
                this.loger.error("Error processing processSendImsiResponse: " + e.getMessage(), e);
            }
        }
    }
}

