/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.NotReachableReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.PDPContextInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.PSSubscriberState;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.PSSubscriberStateChoice;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.PDPContextInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSSubscriberStateImpl
implements PSSubscriberState,
MAPAsnPrimitive {
    public static final int _ID_notProvidedFromSGSNorMME = 0;
    public static final int _ID_ps_Detached = 1;
    public static final int _ID_ps_AttachedNotReachableForPaging = 2;
    public static final int _ID_ps_AttachedReachableForPaging = 3;
    public static final int _ID_ps_PDP_ActiveNotReachableForPaging = 4;
    public static final int _ID_ps_PDP_ActiveReachableForPaging = 5;
    public static final String _PrimitiveName = "PSSubscriberState";
    private PSSubscriberStateChoice choice;
    private NotReachableReason netDetNotReachable;
    private ArrayList<PDPContextInfo> pdpContextInfoList;

    public PSSubscriberStateImpl() {
    }

    public PSSubscriberStateImpl(PSSubscriberStateChoice choice, NotReachableReason netDetNotReachable, ArrayList<PDPContextInfo> pdpContextInfoList) {
        this.choice = choice;
        this.netDetNotReachable = netDetNotReachable;
        this.pdpContextInfoList = pdpContextInfoList;
    }

    @Override
    public PSSubscriberStateChoice getChoice() {
        return this.choice;
    }

    @Override
    public NotReachableReason getNetDetNotReachable() {
        return this.netDetNotReachable;
    }

    @Override
    public ArrayList<PDPContextInfo> getPDPContextInfoList() {
        return this.pdpContextInfoList;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.choice == PSSubscriberStateChoice.notProvidedFromSGSNorMME) {
            return 0;
        }
        if (this.choice == PSSubscriberStateChoice.psDetached) {
            return 1;
        }
        if (this.choice == PSSubscriberStateChoice.psAttachedNotReachableForPaging) {
            return 2;
        }
        if (this.choice == PSSubscriberStateChoice.psAttachedReachableForPaging) {
            return 3;
        }
        if (this.choice == PSSubscriberStateChoice.psPDPActiveNotReachableForPaging) {
            return 4;
        }
        if (this.choice == PSSubscriberStateChoice.psPDPActiveReachableForPaging) {
            return 5;
        }
        if (this.choice == PSSubscriberStateChoice.netDetNotReachable) {
            return 10;
        }
        throw new MAPException("Error encoding PSSubscriberState: Bad hoice value");
    }

    @Override
    public int getTagClass() {
        if (this.choice == PSSubscriberStateChoice.netDetNotReachable) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.choice != PSSubscriberStateChoice.psPDPActiveNotReachableForPaging && this.choice != PSSubscriberStateChoice.psPDPActiveReachableForPaging;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PSSubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PSSubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PSSubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PSSubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        block19: {
            block20: {
                block18: {
                    this.choice = null;
                    this.netDetNotReachable = null;
                    this.pdpContextInfoList = null;
                    if (ansIS.getTagClass() != 0) break block18;
                    switch (ansIS.getTag()) {
                        case 10: {
                            if (!ansIS.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding netDetNotReachable choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.choice = PSSubscriberStateChoice.netDetNotReachable;
                            int i1 = (int)ansIS.readIntegerData(length);
                            this.netDetNotReachable = NotReachableReason.getInstance(i1);
                            break block19;
                        }
                        default: {
                            throw new MAPParsingComponentException("Error while decoding PSSubscriberState: bad tag for Universal TagClass: " + ansIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                    }
                }
                if (ansIS.getTagClass() != 2) break block20;
                switch (ansIS.getTag()) {
                    case 0: {
                        if (!ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding notProvidedFromSGSNorMME choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.choice = PSSubscriberStateChoice.notProvidedFromSGSNorMME;
                        ansIS.readNullData(length);
                        break block19;
                    }
                    case 1: {
                        if (!ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding psDetached choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.choice = PSSubscriberStateChoice.psDetached;
                        ansIS.readNullData(length);
                        break block19;
                    }
                    case 2: {
                        if (!ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding psAttachedNotReachableForPaging choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.choice = PSSubscriberStateChoice.psAttachedNotReachableForPaging;
                        ansIS.readNullData(length);
                        break block19;
                    }
                    case 3: {
                        if (!ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding psAttachedReachableForPaging choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.choice = PSSubscriberStateChoice.psAttachedReachableForPaging;
                        ansIS.readNullData(length);
                        break block19;
                    }
                    case 4: {
                        if (ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding psPDPActiveNotReachableForPaging choice: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.choice = PSSubscriberStateChoice.psPDPActiveNotReachableForPaging;
                        this.decodePdpContextInfoList(ansIS, length);
                        break block19;
                    }
                    case 5: {
                        if (ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding psPDPActiveReachableForPaging choice: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.choice = PSSubscriberStateChoice.psPDPActiveReachableForPaging;
                        this.decodePdpContextInfoList(ansIS, length);
                        break block19;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding PSSubscriberState: bad tag for ContextSpecific TagClass: " + ansIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new MAPParsingComponentException("Error while decoding PSSubscriberState: bad tagClass: " + ansIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void decodePdpContextInfoList(AsnInputStream ansIS, int length) throws AsnException, IOException, MAPParsingComponentException {
        this.pdpContextInfoList = new ArrayList();
        while (ansIS.available() != 0) {
            int tag2 = ansIS.readTag();
            if (ansIS.getTagClass() != 0 || tag2 != 16 || ansIS.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error when decoding PSSubscriberState pdpContextInfoList parameter components: bad tag class or tag or is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            PDPContextInfoImpl elem = new PDPContextInfoImpl();
            elem.decodeAll(ansIS);
            this.pdpContextInfoList.add(elem);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PSSubscriberState: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.choice == null) {
                throw new MAPException("Error while encoding the PSSubscriberState: choice is not defined");
            }
            if ((this.choice == PSSubscriberStateChoice.psPDPActiveNotReachableForPaging || this.choice == PSSubscriberStateChoice.psPDPActiveReachableForPaging) && this.pdpContextInfoList == null) {
                throw new MAPException("Error while encoding the PSSubscriberState: for choice psPDPActiveNotReachableForPaging or psPDPActiveReachableForPaging - pdpContextInfoList must not be null");
            }
            if (this.choice == PSSubscriberStateChoice.netDetNotReachable && this.netDetNotReachable == null) {
                throw new MAPException("Error while encoding the PSSubscriberState: for choice netDetNotReachable - netDetNotReachable must not be null");
            }
            switch (this.choice) {
                case notProvidedFromSGSNorMME: 
                case psDetached: 
                case psAttachedNotReachableForPaging: 
                case psAttachedReachableForPaging: {
                    asnOs.writeNullData();
                    break;
                }
                case psPDPActiveNotReachableForPaging: 
                case psPDPActiveReachableForPaging: {
                    if (this.pdpContextInfoList.size() < 1 || this.pdpContextInfoList.size() > 50) {
                        throw new MAPException("Error while encoding PSSubscriberState: pdpContextInfoList size must be from 1 to 50");
                    }
                    for (PDPContextInfo cii : this.pdpContextInfoList) {
                        PDPContextInfoImpl ci = (PDPContextInfoImpl)cii;
                        ci.encodeAll(asnOs);
                    }
                    break;
                }
                case netDetNotReachable: {
                    asnOs.writeIntegerData(this.netDetNotReachable.getCode());
                }
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding PSSubscriberState: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.choice != null) {
            sb.append(this.choice.toString());
        }
        if (this.netDetNotReachable != null) {
            sb.append(", netDetNotReachable=");
            sb.append(this.netDetNotReachable.toString());
        }
        if (this.pdpContextInfoList != null && this.pdpContextInfoList.size() > 0) {
            sb.append(", pdpContextInfoList [");
            for (PDPContextInfo p : this.pdpContextInfoList) {
                sb.append("PDPContextInfo=");
                sb.append(p);
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

