/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AsState;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.MessageHandler;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPDown;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPDownAck;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPUp;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.ASPUpAck;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.Heartbeat;
import org.mobicents.protocols.ss7.m3ua.message.aspsm.HeartbeatAck;
import org.mobicents.protocols.ss7.m3ua.parameter.ASPIdentifier;
import org.mobicents.protocols.ss7.m3ua.parameter.ErrorCode;

public class AspStateMaintenanceHandler
extends MessageHandler {
    private static final Logger logger = Logger.getLogger(AspStateMaintenanceHandler.class);

    public AspStateMaintenanceHandler(AspFactoryImpl aspFactoryImpl) {
        super(aspFactoryImpl);
    }

    protected void handleAspUp(ASPUp aspUp) {
        if (this.aspFactoryImpl.getFunctionality() == Functionality.SGW || this.aspFactoryImpl.getFunctionality() == Functionality.AS && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.SERVER) {
            ASPUpAck aspUpAck = (ASPUpAck)this.aspFactoryImpl.messageFactory.createMessage(3, 4);
            ASPIdentifier aspId = aspUp.getASPIdentifier();
            aspUpAck.setASPIdentifier(aspId);
            this.aspFactoryImpl.write(aspUpAck);
            FastCollection.Record n = this.aspFactoryImpl.aspList.head();
            FastCollection.Record end = this.aspFactoryImpl.aspList.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspImpl aspImpl = (AspImpl)((FastList.Node)n).getValue();
                aspImpl.setASPIdentifier(aspUp.getASPIdentifier());
                FSM aspPeerFSM = aspImpl.getPeerFSM();
                if (aspPeerFSM == null) {
                    logger.error(String.format("Received ASPUP=%s for ASP=%s. But peer FSM is null.", aspUp, this.aspFactoryImpl.getName()));
                    return;
                }
                if (AspState.getState(aspPeerFSM.getState().getName()) == AspState.ACTIVE) {
                    ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
                    this.sendError(aspImpl.getAs().getRoutingContext(), errorCodeObj);
                }
                try {
                    aspPeerFSM.setAttribute("message", aspUp);
                    aspPeerFSM.signal("aspup");
                    FSM asLocalFSM = ((AsImpl)aspImpl.getAs()).getLocalFSM();
                    asLocalFSM.setAttribute("asp", aspImpl);
                    asLocalFSM.signal("aspup");
                }
                catch (UnknownTransitionException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(null, errorCodeObj);
        }
    }

    protected void handleAspUpAck(ASPUpAck aspUpAck) {
        if (!this.aspFactoryImpl.started) {
            return;
        }
        if (this.aspFactoryImpl.getFunctionality() == Functionality.AS || this.aspFactoryImpl.getFunctionality() == Functionality.SGW && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.CLIENT) {
            FastCollection.Record n = this.aspFactoryImpl.aspList.head();
            FastCollection.Record end = this.aspFactoryImpl.aspList.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspImpl aspImpl = (AspImpl)((FastList.Node)n).getValue();
                FSM aspLocalFSM = aspImpl.getLocalFSM();
                if (aspLocalFSM == null) {
                    logger.error(String.format("Received ASPUP_ACK=%s for ASP=%s. But local FSM is null.", aspUpAck, this.aspFactoryImpl.getName()));
                    return;
                }
                boolean transToActive = this.activate(aspImpl);
                if (!transToActive) {
                    try {
                        aspLocalFSM.signal("aspinactive");
                    }
                    catch (UnknownTransitionException e) {
                        logger.error(e.getMessage(), e);
                    }
                    continue;
                }
                try {
                    aspLocalFSM.signal("aspactivesent");
                    if (this.aspFactoryImpl.getFunctionality() != Functionality.IPSP) continue;
                    AsImpl asImpl = (AsImpl)aspImpl.getAs();
                    FSM asPeerFSM = asImpl.getPeerFSM();
                    if (asPeerFSM == null) {
                        logger.error(String.format("Received ASPUP_ACK=%s for ASP=%s. But Peer FSM of AS=%s is null.", aspUpAck, this.aspFactoryImpl.getName(), asImpl));
                        return;
                    }
                    AsState asPeerFSMState = AsState.getState(asPeerFSM.getState().getName());
                    if (AsState.DOWN != asPeerFSMState) continue;
                    asPeerFSM.setAttribute("asp", aspImpl);
                    asPeerFSM.signal("ntfyasinactive");
                }
                catch (UnknownTransitionException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(null, errorCodeObj);
        }
    }

    protected void handleAspDown(ASPDown aspDown) {
        if (this.aspFactoryImpl.getFunctionality() == Functionality.SGW || this.aspFactoryImpl.getFunctionality() == Functionality.AS && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.DE || this.aspFactoryImpl.getFunctionality() == Functionality.IPSP && this.aspFactoryImpl.getExchangeType() == ExchangeType.SE && this.aspFactoryImpl.getIpspType() == IPSPType.SERVER) {
            ASPDownAck aspDwnAck = (ASPDownAck)this.aspFactoryImpl.messageFactory.createMessage(3, 5);
            this.aspFactoryImpl.write(aspDwnAck);
            FastCollection.Record n = this.aspFactoryImpl.aspList.head();
            FastCollection.Record end = this.aspFactoryImpl.aspList.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspImpl aspImpl = (AspImpl)((FastList.Node)n).getValue();
                FSM aspPeerFSM = aspImpl.getPeerFSM();
                if (aspPeerFSM == null) {
                    logger.error(String.format("Received ASPDOWN=%s for ASP=%s. But peer FSM is null.", aspDown, this.aspFactoryImpl.getName()));
                    return;
                }
                try {
                    aspPeerFSM.setAttribute("message", aspDown);
                    aspPeerFSM.signal("aspdown");
                    FSM asLocalFSM = ((AsImpl)aspImpl.getAs()).getLocalFSM();
                    asLocalFSM.setAttribute("asp", aspImpl);
                    asLocalFSM.signal("aspdown");
                }
                catch (UnknownTransitionException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            ErrorCode errorCodeObj = this.aspFactoryImpl.parameterFactory.createErrorCode(6);
            this.sendError(null, errorCodeObj);
        }
    }

    protected void handleAspDownAck(ASPDownAck aspUpAck) {
        if (!this.aspFactoryImpl.started) {
            boolean stopAssociation = true;
            FastCollection.Record n = this.aspFactoryImpl.aspList.head();
            FastCollection.Record end = this.aspFactoryImpl.aspList.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspState aspPeerState;
                AspImpl aspImpl = (AspImpl)((FastList.Node)n).getValue();
                FSM fsm = aspImpl.getLocalFSM();
                if (fsm == null) {
                    logger.error(String.format("Received ASPDOWN_ACK=%s for ASP=%s. But local FSM is null.", aspUpAck, this.aspFactoryImpl.getName()));
                    continue;
                }
                FSM fsmPeer = aspImpl.getPeerFSM();
                if (fsmPeer != null && (aspPeerState = AspState.getState(fsmPeer.getState().getName())) != AspState.DOWN) {
                    stopAssociation = false;
                }
                try {
                    fsm.signal("aspdownack");
                }
                catch (UnknownTransitionException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (!stopAssociation) {
                logger.error(String.format("Ungracefully stopping the underlying Association=%s for AspFactory=%s. Atleast one of the ASP's is Double Exchange and Peer ASP state is still not down", this.aspFactoryImpl.association.getName(), this.aspFactoryImpl.getName()));
            }
            try {
                if (this.aspFactoryImpl.aspFactoryStopTimer != null) {
                    this.aspFactoryImpl.aspFactoryStopTimer.cancel();
                }
                this.aspFactoryImpl.transportManagement.stopAssociation(this.aspFactoryImpl.association.getName());
            }
            catch (Exception e) {
                logger.error(String.format("Exception while starting the Association=%s", this.aspFactoryImpl.association.getName()), e);
            }
        } else {
            logger.error(String.format("Received ASPDOWN_ACK=%s for ASPFactory=%s. But Aspfactory is down.", aspUpAck, this.aspFactoryImpl.getName()));
        }
    }

    public void handleHeartbeat(Heartbeat hrtBeat) {
        HeartbeatAck hrtBeatAck = (HeartbeatAck)this.aspFactoryImpl.messageFactory.createMessage(3, 6);
        hrtBeatAck.setHeartbeatData(hrtBeat.getHeartbeatData());
        this.aspFactoryImpl.write(hrtBeatAck);
    }

    private boolean activate(AspImpl aspImpl) {
        AsImpl asImpl = (AsImpl)aspImpl.getAs();
        if (asImpl.getTrafficModeType() == null || asImpl.getTrafficModeType().getMode() == 2) {
            this.aspFactoryImpl.sendAspActive(asImpl);
            return true;
        }
        if (asImpl.getTrafficModeType().getMode() == 1) {
            FastCollection.Record n = asImpl.appServerProcs.head();
            FastCollection.Record end = asImpl.appServerProcs.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                AspImpl asptemp = (AspImpl)((FastList.Node)n).getValue();
                FSM fsm = asptemp.getLocalFSM();
                AspState aspState = AspState.getState(fsm.getState().getName());
                if (asptemp.getName().equals(aspImpl.getName()) || aspState != AspState.ACTIVE_SENT && aspState != AspState.ACTIVE) continue;
                return false;
            }
            this.aspFactoryImpl.sendAspActive(asImpl);
            return true;
        }
        return false;
    }
}

