/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dahdi.oam;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp2;
import org.mobicents.protocols.ss7.mtp.Mtp2Listener;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.ss7.hardware.dahdi.Channel;
import org.mobicents.ss7.linkset.oam.FormatterHelp;
import org.mobicents.ss7.linkset.oam.Link;

public class DahdiLink
extends Link
implements Mtp2Listener {
    private static final Logger logger = Logger.getLogger(DahdiLink.class);
    private int span = -1;
    private int channelID = -1;
    private int code = -1;
    private int ioBufferSize = 32;
    private static final String LINK_SPAN = "span";
    private static final String LINK_CHANNEL_ID = "channelId";
    private static final String LINK_CODE = "code";
    private static final String LINK_IO_BUFFER_SIZE = "iOBufferSize";
    private Channel channel = null;
    private Mtp2 mtp2 = null;
    protected static final XMLFormat<DahdiLink> DAHDI_LINK_XML = new XMLFormat<DahdiLink>(DahdiLink.class){

        @Override
        public void read(XMLFormat.InputElement xml, DahdiLink link) throws XMLStreamException {
            LINK_XML.read(xml, link);
            link.span = xml.getAttribute(DahdiLink.LINK_SPAN, -1);
            link.channelID = xml.getAttribute(DahdiLink.LINK_CHANNEL_ID, -1);
            link.code = xml.getAttribute(DahdiLink.LINK_CODE, -1);
            link.ioBufferSize = xml.getAttribute(DahdiLink.LINK_IO_BUFFER_SIZE, 32);
            try {
                link.configure();
            }
            catch (Exception e) {
                logger.error("Failed to initialize dahdi link", e);
            }
        }

        @Override
        public void write(DahdiLink link, XMLFormat.OutputElement xml) throws XMLStreamException {
            LINK_XML.write(link, xml);
            xml.setAttribute(DahdiLink.LINK_SPAN, link.getSpan());
            xml.setAttribute(DahdiLink.LINK_CHANNEL_ID, link.getChannelID());
            xml.setAttribute(DahdiLink.LINK_CODE, link.getCode());
            xml.setAttribute(DahdiLink.LINK_IO_BUFFER_SIZE, link.getIoBufferSize());
        }
    };

    public DahdiLink() {
    }

    public DahdiLink(String linkName, int span, int channelID, int code) {
        super(linkName);
        this.span = span;
        this.channelID = channelID;
        this.code = code;
    }

    protected void configure() throws Exception {
        if (this.mode == 2) {
            if (this.channel == null) {
                this.channel = new Channel();
                this.mtp2 = new Mtp2(this.linkName.toString() + "-" + this.code, this.channel, this.scheduler);
            }
            this.mtp2.setMtp2Listener(this);
            this.channel.setChannelID(this.channelID);
            this.channel.setCode(this.code);
            this.channel.setIOBufferSize(this.ioBufferSize);
            this.channel.setLinkName(this.linkName.toString());
            this.channel.setSpan(this.span);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        if (this.mtp2 != null) {
            this.mtp2.setScheduler(scheduler);
        }
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public void setChannelID(int channelID) {
        this.channelID = channelID;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getIoBufferSize() {
        return this.ioBufferSize;
    }

    public void setIoBufferSize(int ioBufferSize) {
        this.ioBufferSize = ioBufferSize;
    }

    public void activate() throws Exception {
        if (this.state == 3) {
            throw new Exception("Link already active");
        }
        if (this.span == -1 || this.code == -1 || this.channelID == -1) {
            throw new Exception("Not all mandatory parameters are set");
        }
        this.mode = 2;
        this.configure();
        this.state = 1;
    }

    public void deactivate() throws Exception {
        if (this.mode == 1) {
            throw new Exception("Link already deactive");
        }
        this.mtp2.stop();
        this.state = 2;
    }

    public void linkFailed() {
        this.state = 4;
    }

    public void linkInService() {
        this.state = 1;
    }

    public void linkUp() {
        this.state = 3;
    }

    protected Mtp2 getMtp2() {
        return this.mtp2;
    }

    public void print(StringBuffer sb, int leftPad, int descPad) {
        FormatterHelp.createPad(sb, leftPad);
        sb.append(this.linkName);
        if (this.linkName.length() < 10) {
            FormatterHelp.createPad(sb, 10 - this.linkName.length());
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append(LINK_SPAN).append("=").append(this.span);
        if (this.span < 10) {
            FormatterHelp.createPad(sb, 1);
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append(LINK_CHANNEL_ID).append("=").append(this.channelID);
        if (this.channelID < 10) {
            FormatterHelp.createPad(sb, 1);
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append(LINK_CODE).append("=").append(this.code);
        if (this.code < 10) {
            FormatterHelp.createPad(sb, 1);
        }
        if (this.code < 100) {
            FormatterHelp.createPad(sb, 1);
        }
        sb.append("state").append("=").append(FormatterHelp.getLinkState(this.state));
    }
}

