/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPart;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPartListener;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.mobicents.protocols.ss7.sccp.Router;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.SccpManagementEventListener;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.SccpResource;
import org.mobicents.protocols.ss7.sccp.SccpStack;
import org.mobicents.protocols.ss7.sccp.impl.SccpManagement;
import org.mobicents.protocols.ss7.sccp.impl.SccpProviderImpl;
import org.mobicents.protocols.ss7.sccp.impl.SccpResourceImpl;
import org.mobicents.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageUtil;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpSegmentableMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SegmentationImpl;
import org.mobicents.protocols.ss7.sccp.impl.router.RouterImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SccpStackImpl
implements SccpStack,
Mtp3UserPartListener {
    protected final Logger logger;
    protected static final String SCCP_MANAGEMENT_PERSIST_DIR_KEY = "sccpmanagement.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    protected static final String PERSIST_FILE_NAME = "management2.xml";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final String Z_MARGIN_UDT_MSG = "zmarginxudtmessage";
    private static final String REASSEMBLY_TIMER_DELAY = "reassemblytimerdelay";
    private static final String MAX_DATA_MSG = "maxdatamessage";
    private static final String REMOVE_SPC = "removespc";
    private static final String RESERVED_FOR_NATIONAL_USE_VALUE_ADDRESS_INDICATOR = "reservedfornationalusevalue_addressindicator";
    private static final String SCCP_PROTOCOL_VERSION = "sccpProtocolVersion";
    private static final String PREVIEW_MODE = "previewMode";
    private static final String SST_TIMER_DURATION_MIN = "ssttimerduration_min";
    private static final String SST_TIMER_DURATION_MAX = "ssttimerduration_max";
    private static final String SST_TIMER_DURATION_INCREASE_FACTOR = "ssttimerduration_increasefactor";
    private static final XMLBinding binding = new XMLBinding();
    protected int zMarginXudtMessage = 240;
    protected int reassemblyTimerDelay = 15000;
    protected int maxDataMessage = 2560;
    private boolean removeSpc = true;
    protected int sstTimerDuration_Min = 10000;
    protected int sstTimerDuration_Max = 600000;
    protected double sstTimerDuration_IncreaseFactor = 1.5;
    private SccpProtocolVersion sccpProtocolVersion = SccpProtocolVersion.ITU;
    private boolean previewMode = false;
    protected volatile State state = State.IDLE;
    protected SccpProviderImpl sccpProvider;
    protected RouterImpl router;
    protected SccpResourceImpl sccpResource;
    protected MessageFactoryImpl messageFactory;
    protected SccpManagement sccpManagement;
    protected SccpRoutingControl sccpRoutingControl;
    protected FastMap<Integer, Mtp3UserPart> mtp3UserParts = new FastMap();
    protected ScheduledExecutorService timerExecutors;
    protected FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> reassemplyCache = new FastMap();
    protected final String name;
    protected final TextBuilder persistFile = TextBuilder.newInstance();
    protected String persistDir = null;
    private volatile int segmentationLocalRef = 0;
    private volatile int slsCounter = 0;
    private volatile int selectorCounter = 0;

    public SccpStackImpl(String name) {
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        this.name = name;
        this.logger = Logger.getLogger(SccpStackImpl.class.getCanonicalName() + "-" + this.name);
        this.messageFactory = new MessageFactoryImpl(this);
        this.sccpProvider = new SccpProviderImpl(this);
        this.state = State.CONFIGURED;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public SccpProvider getSccpProvider() {
        return this.sccpProvider;
    }

    @Override
    public Map<Integer, Mtp3UserPart> getMtp3UserParts() {
        return this.mtp3UserParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMtp3UserParts(Map<Integer, Mtp3UserPart> mtp3UserPartsTemp) {
        if (mtp3UserPartsTemp != null) {
            SccpStackImpl sccpStackImpl = this;
            synchronized (sccpStackImpl) {
                FastMap<Integer, Mtp3UserPart> newMtp3UserPart = new FastMap<Integer, Mtp3UserPart>();
                newMtp3UserPart.putAll(mtp3UserPartsTemp);
                this.mtp3UserParts = newMtp3UserPart;
            }
        }
    }

    @Override
    public Mtp3UserPart getMtp3UserPart(int id) {
        return this.mtp3UserParts.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMtp3UserPart(int id, Mtp3UserPart mtp3UserPart) {
        if (mtp3UserPart == null) {
            this.removeMtp3UserPart(id);
        } else {
            SccpStackImpl sccpStackImpl = this;
            synchronized (sccpStackImpl) {
                FastMap<Integer, Mtp3UserPart> newMtp3UserPart = new FastMap<Integer, Mtp3UserPart>();
                newMtp3UserPart.putAll(this.mtp3UserParts);
                newMtp3UserPart.put(id, mtp3UserPart);
                this.mtp3UserParts = newMtp3UserPart;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMtp3UserPart(int id) {
        SccpStackImpl sccpStackImpl = this;
        synchronized (sccpStackImpl) {
            FastMap<Integer, Mtp3UserPart> newMtp3UserPart = new FastMap<Integer, Mtp3UserPart>();
            newMtp3UserPart.putAll(this.mtp3UserParts);
            newMtp3UserPart.remove(id);
            this.mtp3UserParts = newMtp3UserPart;
        }
    }

    @Override
    public void setRemoveSpc(boolean removeSpc) {
        this.removeSpc = removeSpc;
        this.store();
    }

    @Override
    public void setSccpProtocolVersion(SccpProtocolVersion sccpProtocolVersion) {
        this.sccpProtocolVersion = sccpProtocolVersion;
        this.store();
    }

    @Override
    public void setPreviewMode(boolean previewMode) {
        this.previewMode = previewMode;
        this.store();
    }

    @Override
    public void setSstTimerDuration_Min(int sstTimerDuration_Min) {
        if (sstTimerDuration_Min < 5000) {
            sstTimerDuration_Min = 5000;
        }
        if (sstTimerDuration_Min > 10000) {
            sstTimerDuration_Min = 10000;
        }
        this.sstTimerDuration_Min = sstTimerDuration_Min;
        this.store();
    }

    @Override
    public void setSstTimerDuration_Max(int sstTimerDuration_Max) {
        if (sstTimerDuration_Max < 600000) {
            sstTimerDuration_Max = 600000;
        }
        if (sstTimerDuration_Max > 1200000) {
            sstTimerDuration_Max = 1200000;
        }
        this.sstTimerDuration_Max = sstTimerDuration_Max;
        this.store();
    }

    @Override
    public void setSstTimerDuration_IncreaseFactor(double sstTimerDuration_IncreaseFactor) {
        if (sstTimerDuration_IncreaseFactor < 1.0) {
            sstTimerDuration_IncreaseFactor = 1.0;
        }
        if (sstTimerDuration_IncreaseFactor > 4.0) {
            sstTimerDuration_IncreaseFactor = 4.0;
        }
        this.sstTimerDuration_IncreaseFactor = sstTimerDuration_IncreaseFactor;
        this.store();
    }

    @Override
    public boolean isRemoveSpc() {
        return this.removeSpc;
    }

    @Override
    public SccpProtocolVersion getSccpProtocolVersion() {
        return this.sccpProtocolVersion;
    }

    @Override
    public boolean isPreviewMode() {
        return this.previewMode;
    }

    @Override
    public int getSstTimerDuration_Min() {
        return this.sstTimerDuration_Min;
    }

    @Override
    public int getSstTimerDuration_Max() {
        return this.sstTimerDuration_Max;
    }

    @Override
    public double getSstTimerDuration_IncreaseFactor() {
        return this.sstTimerDuration_IncreaseFactor;
    }

    @Override
    public int getZMarginXudtMessage() {
        return this.zMarginXudtMessage;
    }

    @Override
    public void setZMarginXudtMessage(int zMarginXudtMessage) {
        if (zMarginXudtMessage < 160) {
            zMarginXudtMessage = 160;
        }
        if (zMarginXudtMessage > 255) {
            zMarginXudtMessage = 255;
        }
        this.zMarginXudtMessage = zMarginXudtMessage;
        this.store();
    }

    @Override
    public int getMaxDataMessage() {
        return this.maxDataMessage;
    }

    @Override
    public void setMaxDataMessage(int maxDataMessage) {
        if (maxDataMessage < 2560) {
            maxDataMessage = 2560;
        }
        if (maxDataMessage > 3952) {
            maxDataMessage = 3952;
        }
        this.maxDataMessage = maxDataMessage;
        this.store();
    }

    @Override
    public int getReassemblyTimerDelay() {
        return this.reassemblyTimerDelay;
    }

    @Override
    public void setReassemblyTimerDelay(int reassemblyTimerDelay) {
        if (reassemblyTimerDelay < 10000) {
            reassemblyTimerDelay = 10000;
        }
        if (reassemblyTimerDelay > 20000) {
            reassemblyTimerDelay = 20000;
        }
        this.reassemblyTimerDelay = reassemblyTimerDelay;
        this.store();
    }

    public synchronized int newSegmentationLocalRef() {
        return ++this.segmentationLocalRef;
    }

    public synchronized int newSls() {
        if (++this.slsCounter > 255) {
            this.slsCounter = 0;
        }
        return this.slsCounter;
    }

    public synchronized boolean newSelector() {
        if (++this.selectorCounter > 1) {
            this.selectorCounter = 0;
        }
        return this.selectorCounter == 1;
    }

    @Override
    public void start() throws IllegalStateException {
        this.logger.info("Starting ...");
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SCCP_MANAGEMENT_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        this.logger.info(String.format("SCCP Management configuration file path %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            this.logger.warn(String.format("Failed to load the Sccp Management configuration file. \n%s", e.getMessage()));
        }
        this.sccpManagement = new SccpManagement(this.name, this.sccpProvider, this);
        this.sccpRoutingControl = new SccpRoutingControl(this.sccpProvider, this);
        this.sccpManagement.setSccpRoutingControl(this.sccpRoutingControl);
        this.sccpRoutingControl.setSccpManagement(this.sccpManagement);
        this.router = new RouterImpl(this.name, this);
        this.router.setPersistDir(this.persistDir);
        this.router.start();
        this.sccpResource = new SccpResourceImpl(this.name);
        this.sccpResource.setPersistDir(this.persistDir);
        this.sccpResource.start();
        this.logger.info("Starting routing engine...");
        this.sccpRoutingControl.start();
        this.logger.info("Starting management ...");
        this.sccpManagement.start();
        this.logger.info("Starting MSU handler...");
        this.timerExecutors = Executors.newScheduledThreadPool(1);
        FastCollection.Record e = this.mtp3UserParts.head();
        FastMap.Entry<Integer, Mtp3UserPart> end = this.mtp3UserParts.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3UserPart mup = (Mtp3UserPart)((FastMap.Entry)e).getValue();
            mup.addMtp3UserPartListener(this);
        }
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onServiceStarted();
            }
            catch (Throwable ee) {
                this.logger.error("Exception while invoking onServiceStarted", ee);
            }
        }
        this.state = State.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.logger.info("Stopping ...");
        this.state = State.IDLE;
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onServiceStopped();
            }
            catch (Throwable ee) {
                this.logger.error("Exception while invoking onServiceStopped", ee);
            }
        }
        FastCollection.Record e = this.mtp3UserParts.head();
        FastMap.Entry<Integer, Mtp3UserPart> end = this.mtp3UserParts.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3UserPart mup = (Mtp3UserPart)((FastMap.Entry)e).getValue();
            mup.removeMtp3UserPartListener(this);
        }
        this.logger.info("Stopping management...");
        this.sccpManagement.stop();
        this.logger.info("Stopping routing engine...");
        this.sccpRoutingControl.stop();
        this.logger.info("Stopping MSU handler...");
        this.sccpResource.stop();
        this.router.stop();
        FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = this.reassemplyCache;
        synchronized (fastMap) {
            this.timerExecutors.shutdownNow();
            this.reassemplyCache.clear();
        }
        this.store();
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public SccpResource getSccpResource() {
        return this.sccpResource;
    }

    protected void send(SccpDataMessageImpl message) throws Exception {
        if (this.state != State.RUNNING) {
            this.logger.error("Trying to send SCCP message from SCCP user but SCCP stack is not RUNNING");
            return;
        }
        if (message.getCalledPartyAddress() == null || message.getCallingPartyAddress() == null || message.getData() == null || message.getData().length == 0) {
            throw new IOException("Message to send must has filled CalledPartyAddress, CallingPartyAddress and data fields");
        }
        try {
            this.sccpRoutingControl.routeMssgFromSccpUser(message);
        }
        catch (Exception e) {
            this.logger.error("IOException when sending the message to MTP3 level: " + e.getMessage(), e);
            throw e;
        }
    }

    protected int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        GlobalTitle gt = calledPartyAddress.getGlobalTitle();
        int dpc = calledPartyAddress.getSignalingPointCode();
        int ssn = calledPartyAddress.getSubsystemNumber();
        if (calledPartyAddress.getAddressIndicator().isPCPresent()) {
            if (this.router.spcIsLocal(dpc)) {
                if (ssn > 0) {
                    return this.getMaxDataMessage();
                }
                if (gt != null) {
                    return this.getMaxUserDataLengthForGT(calledPartyAddress, callingPartyAddress, msgNetworkId);
                }
                return 0;
            }
            return this.getMaxUserDataLengthForDpc(dpc, calledPartyAddress, callingPartyAddress);
        }
        if (gt != null) {
            return this.getMaxUserDataLengthForGT(calledPartyAddress, callingPartyAddress, msgNetworkId);
        }
        return 0;
    }

    private int getMaxUserDataLengthForDpc(int dpc, SccpAddress calledPartyAddress, SccpAddress callingPartyAddress) {
        Mtp3ServiceAccessPoint sap;
        LongMessageRule lmr = this.router.findLongMessageRule(dpc);
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        if (lmr != null) {
            lmrt = lmr.getLongMessageRuleType();
        }
        if ((sap = this.router.findMtp3ServiceAccessPoint(dpc, 0)) == null) {
            return 0;
        }
        Mtp3UserPart mup = this.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            return 0;
        }
        try {
            int fieldsLen = 0;
            byte[] cdp = ((SccpAddressImpl)calledPartyAddress).encode(this.isRemoveSpc(), this.getSccpProtocolVersion());
            byte[] cnp = ((SccpAddressImpl)callingPartyAddress).encode(this.isRemoveSpc(), this.getSccpProtocolVersion());
            switch (lmrt) {
                case LONG_MESSAGE_FORBBIDEN: {
                    fieldsLen = MessageUtil.calculateUdtFieldsLengthWithoutData(cdp.length, cnp.length);
                    break;
                }
                case LUDT_ENABLED: 
                case LUDT_ENABLED_WITH_SEGMENTATION: {
                    fieldsLen = MessageUtil.calculateLudtFieldsLengthWithoutData(cdp.length, cnp.length, true, true);
                    break;
                }
                case XUDT_ENABLED: {
                    fieldsLen = MessageUtil.calculateXudtFieldsLengthWithoutData(cdp.length, cnp.length, true, true);
                    int fieldsLen2 = MessageUtil.calculateXudtFieldsLengthWithoutData2(cdp.length, cnp.length);
                    if (fieldsLen <= fieldsLen2) break;
                    fieldsLen = fieldsLen2;
                }
            }
            int availLen = mup.getMaxUserDataLength(dpc) - fieldsLen;
            if ((lmrt == LongMessageRuleType.LONG_MESSAGE_FORBBIDEN || lmrt == LongMessageRuleType.XUDT_ENABLED) && availLen > 255) {
                availLen = 255;
            }
            if (lmrt == LongMessageRuleType.XUDT_ENABLED) {
                availLen *= 16;
            }
            if (availLen > this.getMaxDataMessage()) {
                availLen = this.getMaxDataMessage();
            }
            return availLen;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int getMaxUserDataLengthForGT(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        Rule rule = this.router.findRule(calledPartyAddress, false, msgNetworkId);
        if (rule == null) {
            return 0;
        }
        SccpAddress translationAddressPri = this.router.getRoutingAddress(rule.getPrimaryAddressId());
        if (translationAddressPri == null) {
            return 0;
        }
        return this.getMaxUserDataLengthForDpc(translationAddressPri.getSignalingPointCode(), calledPartyAddress, callingPartyAddress);
    }

    protected void broadcastChangedSsnState(int affectedSsn, boolean inService) {
        this.sccpManagement.broadcastChangedSsnState(affectedSsn, inService);
    }

    public void removeAllResourses() {
        if (this.state != State.RUNNING) {
            return;
        }
        this.router.removeAllResourses();
        this.sccpResource.removeAllResourses();
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onRemoveAllResources();
            }
            catch (Throwable ee) {
                this.logger.error("Exception while invoking onRemoveAllResources", ee);
            }
        }
    }

    @Override
    public void onMtp3PauseMessage(Mtp3PausePrimitive msg) {
        this.logger.warn(String.format("Rx : %s", msg));
        if (this.state != State.RUNNING) {
            this.logger.error("Cannot consume MTP3 PASUE message as SCCP stack is not RUNNING");
            return;
        }
        this.sccpManagement.handleMtp3Pause(msg.getAffectedDpc());
    }

    @Override
    public void onMtp3ResumeMessage(Mtp3ResumePrimitive msg) {
        this.logger.warn(String.format("Rx : %s", msg));
        if (this.state != State.RUNNING) {
            this.logger.error("Cannot consume MTP3 RESUME message as SCCP stack is not RUNNING");
            return;
        }
        this.sccpManagement.handleMtp3Resume(msg.getAffectedDpc());
    }

    @Override
    public void onMtp3StatusMessage(Mtp3StatusPrimitive msg) {
        this.logger.warn(String.format("Rx : %s", msg));
        if (this.state != State.RUNNING) {
            this.logger.error("Cannot consume MTP3 STATUS message as SCCP stack is not RUNNING");
            return;
        }
        this.sccpManagement.handleMtp3Status(msg.getCause(), msg.getAffectedDpc(), msg.getCongestionLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMtp3TransferMessage(Mtp3TransferPrimitive mtp3Msg) {
        if (this.state != State.RUNNING) {
            this.logger.error("Received MTP3TransferPrimitive from lower layer but SCCP stack is not RUNNING");
            return;
        }
        SccpMessageImpl msg = null;
        try {
            SccpSegmentableMessageImpl sgmMsg;
            SegmentationImpl segm;
            if (!this.isPreviewMode() && !this.router.spcIsLocal(mtp3Msg.getDpc())) {
                int dpc = mtp3Msg.getDpc();
                int sls = mtp3Msg.getSls();
                RemoteSignalingPointCode remoteSpc = this.getSccpResource().getRemoteSpcByPC(dpc);
                if (remoteSpc == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d. But RemoteSpc is not found", dpc));
                    }
                    return;
                }
                if (remoteSpc.isRemoteSpcProhibited()) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d. But RemoteSpc is Prohibited", dpc));
                    }
                    return;
                }
                Mtp3ServiceAccessPoint sap = this.router.findMtp3ServiceAccessPoint(dpc, sls);
                if (sap == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d / sls=%d. But SAP is not found", dpc, sls));
                    }
                    return;
                }
                Mtp3UserPart mup = this.getMtp3UserPart(sap.getMtp3Id());
                if (mup == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d / sls=%d. no matching Mtp3UserPart found", dpc, sls));
                    }
                    return;
                }
                mup.sendMessage(mtp3Msg);
                return;
            }
            int dpc = mtp3Msg.getDpc();
            int opc = mtp3Msg.getOpc();
            Mtp3ServiceAccessPoint sap = this.router.findMtp3ServiceAccessPointForIncMes(dpc, opc);
            int networkId = 0;
            if (sap == null) {
                if (this.logger.isEnabledFor(Level.WARN)) {
                    this.logger.warn(String.format("Incoming Mtp3 Message for local address for localPC=%d, remotePC=%d, sls=%d. But SAP is not found for localPC", dpc, opc, mtp3Msg.getSls()));
                }
            } else {
                networkId = sap.getNetworkId();
            }
            if (mtp3Msg.getSi() != 3) {
                this.logger.warn(String.format("Received Mtp3TransferPrimitive from lower layer with Service Indicator=%d which is not SCCP. Dropping this message", mtp3Msg.getSi()));
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(mtp3Msg.getData());
            DataInputStream in = new DataInputStream(bais);
            int mt = in.readUnsignedByte();
            msg = ((MessageFactoryImpl)this.sccpProvider.getMessageFactory()).createMessage(mt, mtp3Msg.getOpc(), mtp3Msg.getDpc(), mtp3Msg.getSls(), in, this.sccpProtocolVersion, networkId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Rx : SCCP message from MTP %s", msg));
            }
            if (msg instanceof SccpSegmentableMessageImpl && (segm = (SegmentationImpl)(sgmMsg = (SccpSegmentableMessageImpl)msg).getSegmentation()) != null) {
                if (segm.isFirstSegIndication() && segm.getRemainingSegments() == 0) {
                    sgmMsg.setReceivedSingleSegment();
                } else {
                    if (segm.isFirstSegIndication()) {
                        sgmMsg.setReceivedFirstSegment();
                        MessageReassemblyProcess msp = new MessageReassemblyProcess(segm.getSegmentationLocalRef(), sgmMsg.getCallingPartyAddress());
                        FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = this.reassemplyCache;
                        synchronized (fastMap) {
                            this.reassemplyCache.put(msp, sgmMsg);
                        }
                        sgmMsg.setMessageReassemblyProcess(msp);
                        msp.startTimer();
                        return;
                    }
                    MessageReassemblyProcess msp = new MessageReassemblyProcess(segm.getSegmentationLocalRef(), sgmMsg.getCallingPartyAddress());
                    SccpSegmentableMessageImpl sgmMsgFst = null;
                    FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = this.reassemplyCache;
                    synchronized (fastMap) {
                        sgmMsgFst = this.reassemplyCache.get(msp);
                    }
                    if (sgmMsgFst == null) {
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Reassembly function failure: received a non first segment without the first segement having recieved. SccpMessageSegment=%s", msg));
                        }
                        return;
                    }
                    if (sgmMsgFst.getRemainingSegments() - 1 != segm.getRemainingSegments()) {
                        fastMap = this.reassemplyCache;
                        synchronized (fastMap) {
                            this.reassemplyCache.remove(msp);
                            MessageReassemblyProcess mspMain = sgmMsgFst.getMessageReassemblyProcess();
                            if (mspMain != null) {
                                mspMain.stopTimer();
                            }
                        }
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Reassembly function failure: when receiving a next segment message order is missing. SccpMessageSegment=%s", msg));
                        }
                        this.sccpRoutingControl.sendSccpError(sgmMsgFst, ReturnCauseValue.CANNOT_REASEMBLE);
                        return;
                    }
                    if (sgmMsgFst.getRemainingSegments() == 1) {
                        fastMap = this.reassemplyCache;
                        synchronized (fastMap) {
                            MessageReassemblyProcess mspMain = sgmMsgFst.getMessageReassemblyProcess();
                            if (mspMain != null) {
                                mspMain.stopTimer();
                            }
                            this.reassemplyCache.remove(msp);
                        }
                        if (sgmMsgFst.getRemainingSegments() != 1) {
                            return;
                        }
                        sgmMsgFst.setReceivedNextSegment(sgmMsg);
                        msg = sgmMsgFst;
                    } else {
                        sgmMsgFst.setReceivedNextSegment(sgmMsg);
                        return;
                    }
                }
            }
            if (msg instanceof SccpAddressedMessageImpl) {
                SccpAddressedMessageImpl msgAddr = (SccpAddressedMessageImpl)msg;
                SccpAddress addr = msgAddr.getCallingPartyAddress();
                if (addr != null && addr.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN && !addr.getAddressIndicator().isPCPresent()) {
                    msgAddr.setCallingPartyAddress(new SccpAddressImpl(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, null, msgAddr.getIncomingOpc(), addr.getSubsystemNumber()));
                }
                this.sccpRoutingControl.routeMssgFromMtp(msgAddr);
            } else {
                this.logger.warn(String.format("Rx SCCP message which is not instance of SccpAddressedMessage or SccpSegmentableMessage. Will be dropped. Message=", msg));
            }
        }
        catch (Exception e) {
            this.logger.error("IOException while decoding SCCP message: " + e.getMessage(), e);
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.zMarginXudtMessage, Z_MARGIN_UDT_MSG, Integer.class);
            writer.write(this.reassemblyTimerDelay, REASSEMBLY_TIMER_DELAY, Integer.class);
            writer.write(this.maxDataMessage, MAX_DATA_MSG, Integer.class);
            writer.write(this.removeSpc, REMOVE_SPC, Boolean.class);
            writer.write(this.previewMode, PREVIEW_MODE, Boolean.class);
            if (this.sccpProtocolVersion != null) {
                writer.write(this.sccpProtocolVersion.toString(), SCCP_PROTOCOL_VERSION, String.class);
            }
            writer.write(this.sstTimerDuration_Min, SST_TIMER_DURATION_MIN, Integer.class);
            writer.write(this.sstTimerDuration_Max, SST_TIMER_DURATION_MAX, Integer.class);
            writer.write(this.sstTimerDuration_IncreaseFactor, SST_TIMER_DURATION_INCREASE_FACTOR, Double.class);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error(String.format("Error while persisting the Sccp Resource state in file=%s", this.persistFile.toString()), e);
        }
    }

    protected void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            Double vald;
            Boolean volb;
            reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            Integer vali = reader.read(Z_MARGIN_UDT_MSG, Integer.class);
            if (vali != null) {
                this.zMarginXudtMessage = vali;
            }
            if ((vali = reader.read(REASSEMBLY_TIMER_DELAY, Integer.class)) != null) {
                this.reassemblyTimerDelay = vali;
            }
            if ((vali = reader.read(MAX_DATA_MSG, Integer.class)) != null) {
                this.maxDataMessage = vali;
            }
            if ((volb = reader.read(REMOVE_SPC, Boolean.class)) != null) {
                this.removeSpc = volb;
            }
            if ((volb = reader.read(PREVIEW_MODE, Boolean.class)) != null) {
                this.previewMode = volb;
            }
            volb = reader.read(RESERVED_FOR_NATIONAL_USE_VALUE_ADDRESS_INDICATOR, Boolean.class);
            String s1 = reader.read(SCCP_PROTOCOL_VERSION, String.class);
            if (s1 != null) {
                this.sccpProtocolVersion = Enum.valueOf(SccpProtocolVersion.class, s1);
            }
            if ((vali = reader.read(SST_TIMER_DURATION_MIN, Integer.class)) != null) {
                this.sstTimerDuration_Min = vali;
            }
            if ((vali = reader.read(SST_TIMER_DURATION_MAX, Integer.class)) != null) {
                this.sstTimerDuration_Max = vali;
            }
            if ((vald = reader.read(SST_TIMER_DURATION_INCREASE_FACTOR, Double.class)) != null) {
                this.sstTimerDuration_IncreaseFactor = vald;
            }
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public class MessageReassemblyProcess
    implements Runnable {
        private int segmentationLocalRef;
        private SccpAddress callingPartyAddress;
        private Future timer;

        public MessageReassemblyProcess(int segmentationLocalRef, SccpAddress callingPartyAddress) {
            this.segmentationLocalRef = segmentationLocalRef;
            this.callingPartyAddress = callingPartyAddress;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MessageReassemblyProcess)) {
                return false;
            }
            MessageReassemblyProcess x = (MessageReassemblyProcess)obj;
            if (this.segmentationLocalRef != x.segmentationLocalRef) {
                return false;
            }
            if (this.callingPartyAddress == null || x.callingPartyAddress == null) {
                return false;
            }
            return this.callingPartyAddress.equals(x.callingPartyAddress);
        }

        public int hashCode() {
            return this.segmentationLocalRef;
        }

        public void startTimer() {
            this.timer = SccpStackImpl.this.timerExecutors.schedule(this, (long)SccpStackImpl.this.reassemblyTimerDelay, TimeUnit.MILLISECONDS);
        }

        public void stopTimer() {
            if (this.timer != null) {
                this.timer.cancel(false);
                this.timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SccpSegmentableMessageImpl msg = null;
            FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = SccpStackImpl.this.reassemplyCache;
            synchronized (fastMap) {
                msg = SccpStackImpl.this.reassemplyCache.remove(this);
                if (msg == null) {
                    return;
                }
                msg.cancelSegmentation();
            }
            try {
                SccpStackImpl.this.sccpRoutingControl.sendSccpError(msg, ReturnCauseValue.CANNOT_REASEMBLE);
            }
            catch (Exception e) {
                SccpStackImpl.this.logger.warn("IOException when sending an error message", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

