/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.smstpdu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mobicents.protocols.ss7.map.api.smstpdu.ApplicationPortAddressing16BitAddress;
import org.mobicents.protocols.ss7.map.api.smstpdu.ConcatenatedShortMessagesIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.NationalLanguageLockingShiftIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.NationalLanguageSingleShiftIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeader;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeaderElement;
import org.mobicents.protocols.ss7.map.smstpdu.ApplicationPortAddressing16BitAddressImpl;
import org.mobicents.protocols.ss7.map.smstpdu.ConcatenatedShortMessagesIdentifierImpl;
import org.mobicents.protocols.ss7.map.smstpdu.NationalLanguageLockingShiftIdentifierImpl;
import org.mobicents.protocols.ss7.map.smstpdu.NationalLanguageSingleShiftIdentifierImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataHeaderImpl
implements UserDataHeader {
    private Map<Integer, byte[]> data = new HashMap<Integer, byte[]>();

    public UserDataHeaderImpl() {
    }

    public UserDataHeaderImpl(byte[] encodedData) {
        if (encodedData == null || encodedData.length < 1) {
            return;
        }
        int udhl = encodedData[0] & 0xFF;
        if (udhl > encodedData.length) {
            udhl = encodedData.length;
        }
        int ind = 1;
        while (ind <= udhl - 2) {
            byte len;
            byte id = encodedData[ind++];
            if ((len = encodedData[ind++]) > udhl + 1 - ind) continue;
            byte[] buf = new byte[len];
            System.arraycopy(encodedData, ind, buf, 0, len);
            ind += len;
            this.data.put(Integer.valueOf(id), buf);
        }
    }

    @Override
    public byte[] getEncodedData() {
        if (this.data.size() == 0) {
            return null;
        }
        ByteArrayOutputStream stm = new ByteArrayOutputStream();
        stm.write(0);
        for (int id : this.data.keySet()) {
            byte[] buf = this.data.get(id);
            stm.write(id);
            if (buf == null) {
                stm.write(0);
                continue;
            }
            stm.write(buf.length);
            try {
                stm.write(buf);
            }
            catch (IOException e) {}
        }
        byte[] res = stm.toByteArray();
        res[0] = (byte)(res.length - 1);
        return res;
    }

    @Override
    public Map<Integer, byte[]> getAllData() {
        return this.data;
    }

    @Override
    public void addInformationElement(int informationElementIdentifier, byte[] encodedData) {
        this.data.put(informationElementIdentifier, encodedData);
    }

    @Override
    public void addInformationElement(UserDataHeaderElement informationElement) {
        this.data.put(informationElement.getEncodedInformationElementIdentifier(), informationElement.getEncodedInformationElementData());
    }

    @Override
    public byte[] getInformationElementData(int informationElementIdentifier) {
        return this.data.get(informationElementIdentifier);
    }

    @Override
    public NationalLanguageLockingShiftIdentifier getNationalLanguageLockingShift() {
        byte[] buf = this.data.get(37);
        if (buf != null && buf.length == 1) {
            return new NationalLanguageLockingShiftIdentifierImpl(buf);
        }
        return null;
    }

    @Override
    public NationalLanguageSingleShiftIdentifier getNationalLanguageSingleShift() {
        byte[] buf = this.data.get(36);
        if (buf != null && buf.length == 1) {
            return new NationalLanguageSingleShiftIdentifierImpl(buf);
        }
        return null;
    }

    @Override
    public ConcatenatedShortMessagesIdentifier getConcatenatedShortMessagesIdentifier() {
        byte[] buf = this.data.get(8);
        if (buf != null && buf.length == 4) {
            return new ConcatenatedShortMessagesIdentifierImpl(buf);
        }
        buf = this.data.get(0);
        if (buf != null && buf.length == 3) {
            return new ConcatenatedShortMessagesIdentifierImpl(buf);
        }
        return null;
    }

    @Override
    public ApplicationPortAddressing16BitAddress getApplicationPortAddressing16BitAddress() {
        byte[] buf = this.data.get(5);
        if (buf != null && buf.length == 1) {
            return new ApplicationPortAddressing16BitAddressImpl(buf);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UserDataHeader [");
        boolean isFirst = true;
        for (int id : this.data.keySet()) {
            byte[] buf = this.data.get(id);
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n\t");
            }
            sb.append(id);
            sb.append(" = ");
            sb.append(this.printDataArr(buf));
        }
        NationalLanguageLockingShiftIdentifier nllsi = this.getNationalLanguageLockingShift();
        NationalLanguageSingleShiftIdentifier nlssi = this.getNationalLanguageSingleShift();
        ConcatenatedShortMessagesIdentifier csmi = this.getConcatenatedShortMessagesIdentifier();
        ApplicationPortAddressing16BitAddress apa16 = this.getApplicationPortAddressing16BitAddress();
        if (nllsi != null) {
            sb.append(", NationalLanguageLockingShiftIdentifier = [");
            sb.append(nllsi);
            sb.append("]");
        }
        if (nlssi != null) {
            sb.append(", NationalLanguageSingleShiftIdentifier = [");
            sb.append(nlssi);
            sb.append("]");
        }
        if (csmi != null) {
            sb.append(", ConcatenatedShortMessagesIdentifier = [");
            sb.append(csmi);
            sb.append("]");
        }
        if (apa16 != null) {
            sb.append(", ApplicationPortAddressing16BitAddress = [");
            sb.append(apa16);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

