/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.ReSynchronisationInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class ReSynchronisationInfoImpl
implements ReSynchronisationInfo,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "ReSynchronisationInfo";
    private byte[] rand;
    private byte[] auts;

    public ReSynchronisationInfoImpl() {
    }

    public ReSynchronisationInfoImpl(byte[] rand, byte[] auts) {
        this.rand = rand;
        this.auts = auts;
    }

    public byte[] getRand() {
        return this.rand;
    }

    public byte[] getAuts() {
        return this.auts;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReSynchronisationInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReSynchronisationInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReSynchronisationInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReSynchronisationInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.rand = null;
        this.auts = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding ReSynchronisationInfo.rand: Parameter 0 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.rand = ais.readOctetString();
                    if (this.rand.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding ReSynchronisationInfo.rand: Bad field length: 16 is needed, found: " + this.rand.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding ReSynchronisationInfo.auts: Parameter 1 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.auts = ais.readOctetString();
                    if (this.auts.length == 14) break;
                    throw new MAPParsingComponentException("Error while decoding ReSynchronisationInfo.sres: Bad field length: 14 is needed, found: " + this.auts.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            ++num;
        }
        if (num < 2) {
            throw new MAPParsingComponentException("Error while decoding ReSynchronisationInfo: Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReSynchronisationInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.rand == null || this.auts == null) {
            throw new MAPException("rand, auts fields must not be null");
        }
        if (this.rand.length != 16) {
            throw new MAPException("Wrong rand field length: must be 16, found " + this.rand.length);
        }
        if (this.auts.length != 14) {
            throw new MAPException("Wrong auts field length: must be 14, found " + this.auts.length);
        }
        try {
            asnOs.writeOctetString(this.rand);
            asnOs.writeOctetString(this.auts);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ReSynchronisationInfo: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReSynchronisationInfo: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReSynchronisationInfo [");
        if (this.rand != null) {
            sb.append("rand=[");
            sb.append(this.printDataArr(this.rand));
            sb.append("], ");
        }
        if (this.auts != null) {
            sb.append("auts=[");
            sb.append(this.printDataArr(this.auts));
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

