/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.ss7;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.restcomm.ss7.SS7ServiceMBean;
import org.restcomm.ss7.Version;

public class SS7Service
extends ServiceMBeanSupport
implements SS7ServiceMBean {
    private final String serviceName;
    private Object stack;
    private String jndiName;
    private Logger logger = Logger.getLogger(SS7Service.class);
    private static final String rLogo = " ]]]]]]]]] ";
    private static final String lLogo = " [[[[[[[[[ ";

    public SS7Service(String serviceName) {
        this.serviceName = serviceName;
    }

    public void startService() throws Exception {
        this.rebind(this.stack);
        this.logger.info(this.generateMessageWithLogo("service started"));
    }

    private String generateMessageWithLogo(String message) {
        return lLogo + this.getSS7Name() + " " + this.getSS7Version() + " " + this.serviceName + " " + message + rLogo;
    }

    @Override
    public String getSS7ServiceName() {
        return this.serviceName;
    }

    @Override
    public String getSS7Name() {
        String name = Version.instance.getProperty("name");
        if (name != null) {
            return name;
        }
        return "Restcomm jSS7 Service";
    }

    @Override
    public String getSS7Vendor() {
        String vendor = Version.instance.getProperty("vendor");
        if (vendor != null) {
            return vendor;
        }
        return "TeleStax Inc";
    }

    @Override
    public String getSS7Version() {
        String version = Version.instance.getProperty("version");
        if (version != null) {
            return version;
        }
        return "2.0";
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public Object getStack() {
        return this.stack;
    }

    @Override
    public void setStack(Object stack) {
        this.stack = stack;
    }

    public void stopService() {
        if (this.jndiName != null) {
            try {
                this.unbind(this.jndiName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logger.info(this.generateMessageWithLogo("service stopped"));
    }

    private void rebind(Object stack) throws NamingException {
        if (this.jndiName != null) {
            Context ctx = new InitialContext();
            String[] tokens = this.jndiName.split("/");
            for (int i = 0; i < tokens.length - 1; ++i) {
                if (tokens[i].trim().length() <= 0) continue;
                try {
                    ctx = (Context)ctx.lookup(tokens[i]);
                    continue;
                }
                catch (NamingException e) {
                    ctx = ctx.createSubcontext(tokens[i]);
                }
            }
            ctx.bind(tokens[tokens.length - 1], stack);
        }
    }

    private void unbind(String jndiName) throws NamingException {
        InitialContext initialContext = new InitialContext();
        initialContext.unbind(jndiName);
    }

    @Override
    public boolean isStarted() {
        return this.getState() == 3;
    }
}

