/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;

public final class Utils {
    public static long readTransactionId(AsnInputStream ais) throws AsnException, IOException {
        byte[] data = ais.readOctetString();
        byte[] longRep = new byte[8];
        System.arraycopy(data, 0, longRep, longRep.length - data.length, data.length);
        ByteBuffer bb = ByteBuffer.wrap(longRep);
        return bb.getLong();
    }

    public static void writeTransactionId(AsnOutputStream aos, long txId, int tagClass, int tag) throws AsnException, IOException {
        byte[] data = new byte[4];
        data[3] = (byte)txId;
        data[2] = (byte)(txId >> 8);
        data[1] = (byte)(txId >> 16);
        data[0] = (byte)(txId >> 24);
        aos.writeOctetString(tagClass, tag, data);
    }

    public static long decodeTransactionId(byte[] data) {
        byte[] longRep = new byte[8];
        System.arraycopy(data, 0, longRep, longRep.length - data.length, data.length);
        ByteBuffer bb = ByteBuffer.wrap(longRep);
        return bb.getLong();
    }

    public static byte[] encodeTransactionId(long txId) {
        byte[] data = new byte[4];
        data[3] = (byte)txId;
        data[2] = (byte)(txId >> 8);
        data[1] = (byte)(txId >> 16);
        data[0] = (byte)(txId >> 24);
        return data;
    }
}

