/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.sccp.NetworkIdState;
import org.restcomm.protocols.ss7.sccp.RemoteSccpStatus;
import org.restcomm.protocols.ss7.sccp.SccpConnection;
import org.restcomm.protocols.ss7.sccp.SccpListener;
import org.restcomm.protocols.ss7.sccp.SccpProvider;
import org.restcomm.protocols.ss7.sccp.SignallingPointStatus;
import org.restcomm.protocols.ss7.sccp.message.MessageFactory;
import org.restcomm.protocols.ss7.sccp.message.SccpDataMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.restcomm.protocols.ss7.sccp.parameter.Credit;
import org.restcomm.protocols.ss7.sccp.parameter.ErrorCause;
import org.restcomm.protocols.ss7.sccp.parameter.Importance;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.RefusalCause;
import org.restcomm.protocols.ss7.sccp.parameter.ReleaseCause;
import org.restcomm.protocols.ss7.sccp.parameter.ResetCause;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;
import org.restcomm.protocols.ss7.tcap.DialogImpl;
import org.restcomm.protocols.ss7.tcap.PreviewDialogData;
import org.restcomm.protocols.ss7.tcap.PreviewDialogDataKey;
import org.restcomm.protocols.ss7.tcap.SlsRangeType;
import org.restcomm.protocols.ss7.tcap.TCAPStackImpl;
import org.restcomm.protocols.ss7.tcap.api.ComponentPrimitiveFactory;
import org.restcomm.protocols.ss7.tcap.api.DialogPrimitiveFactory;
import org.restcomm.protocols.ss7.tcap.api.MessageType;
import org.restcomm.protocols.ss7.tcap.api.TCAPException;
import org.restcomm.protocols.ss7.tcap.api.TCAPProvider;
import org.restcomm.protocols.ss7.tcap.api.TCListener;
import org.restcomm.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.restcomm.protocols.ss7.tcap.api.tc.dialog.TRPseudoState;
import org.restcomm.protocols.ss7.tcap.api.tc.dialog.events.DraftParsedMessage;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.DialogPortion;
import org.restcomm.protocols.ss7.tcap.asn.DialogRequestAPDUImpl;
import org.restcomm.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.restcomm.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.restcomm.protocols.ss7.tcap.asn.InvokeImpl;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.Result;
import org.restcomm.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.restcomm.protocols.ss7.tcap.asn.ResultType;
import org.restcomm.protocols.ss7.tcap.asn.TCAbortMessageImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCNoticeIndicationImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCUnidentifiedMessage;
import org.restcomm.protocols.ss7.tcap.asn.TcapFactory;
import org.restcomm.protocols.ss7.tcap.asn.Utils;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCUniMessage;
import org.restcomm.protocols.ss7.tcap.tc.component.ComponentPrimitiveFactoryImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.DialogPrimitiveFactoryImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.DraftParsedMessageImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.TCBeginIndicationImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.TCContinueIndicationImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.TCEndIndicationImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.TCPAbortIndicationImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.TCUniIndicationImpl;
import org.restcomm.protocols.ss7.tcap.tc.dialog.events.TCUserAbortIndicationImpl;
import org.restcomm.ss7.congestion.ExecutorCongestionMonitor;
import org.restcomm.ss7.congestion.MemoryCongestionMonitorImpl;

public class TCAPProviderImpl
implements TCAPProvider,
SccpListener {
    private static final Logger logger = Logger.getLogger(TCAPProviderImpl.class);
    private transient List<TCListener> tcListeners = new CopyOnWriteArrayList<TCListener>();
    protected transient ScheduledExecutorService _EXECUTOR;
    private transient ComponentPrimitiveFactory componentPrimitiveFactory;
    private transient DialogPrimitiveFactory dialogPrimitiveFactory;
    private transient SccpProvider sccpProvider;
    private transient MessageFactory messageFactory;
    private transient ParameterFactory parameterFactory;
    private transient TCAPStackImpl stack;
    private transient ConcurrentHashMap<Long, DialogImpl> dialogs = new ConcurrentHashMap();
    protected transient ConcurrentHashMap<PreviewDialogDataKey, PreviewDialogData> dialogPreviewList = new ConcurrentHashMap();
    private transient FastMap<Integer, NetworkIdState> networkIdStateList = new FastMap().shared();
    private NetworkIdStateListUpdater currentNetworkIdStateListUpdater;
    private AtomicInteger seqControl = new AtomicInteger(1);
    private int ssn;
    private long curDialogId = 0L;
    private int cumulativeCongestionLevel = 0;
    private int executorCongestionLevel = 0;
    private int executorCountWithCongestionLevel_1 = 0;
    private int executorCountWithCongestionLevel_2 = 0;
    private int executorCountWithCongestionLevel_3 = 0;
    private MemoryCongestionMonitorImpl memoryCongestionMonitor;
    private transient FastMap<String, Integer> lstUserPartCongestionLevel = new FastMap();
    private int userPartCongestionLevel_1 = 0;
    private int userPartCongestionLevel_2 = 0;
    private int userPartCongestionLevel_3 = 0;

    protected TCAPProviderImpl(SccpProvider sccpProvider, TCAPStackImpl stack, int ssn) {
        this.sccpProvider = sccpProvider;
        this.ssn = ssn;
        this.messageFactory = sccpProvider.getMessageFactory();
        this.parameterFactory = sccpProvider.getParameterFactory();
        this.stack = stack;
        this.componentPrimitiveFactory = new ComponentPrimitiveFactoryImpl(this);
        this.dialogPrimitiveFactory = new DialogPrimitiveFactoryImpl(this.componentPrimitiveFactory);
    }

    @Override
    public boolean getPreviewMode() {
        return this.stack.getPreviewMode();
    }

    @Override
    public void addTCListener(TCListener lst) {
        if (!this.tcListeners.contains(lst)) {
            this.tcListeners.add(lst);
        }
    }

    @Override
    public void removeTCListener(TCListener lst) {
        this.tcListeners.remove(lst);
    }

    private boolean checkAvailableTxId(Long id) {
        return !this.dialogs.containsKey(id);
    }

    private synchronized Long getAvailableTxId() throws TCAPException {
        Long id;
        if (this.dialogs.size() >= this.stack.getMaxDialogs()) {
            throw new TCAPException("Current dialog count exceeds its maximum value");
        }
        do {
            if (this.curDialogId < this.stack.getDialogIdRangeStart()) {
                this.curDialogId = this.stack.getDialogIdRangeStart() - 1L;
            }
            if (++this.curDialogId <= this.stack.getDialogIdRangeEnd()) continue;
            this.curDialogId = this.stack.getDialogIdRangeStart();
        } while (!this.checkAvailableTxId(id = Long.valueOf(this.curDialogId)));
        return id;
    }

    protected void resetDialogIdValueAfterRangeChange() {
        if (this.curDialogId < this.stack.getDialogIdRangeStart()) {
            this.curDialogId = this.stack.getDialogIdRangeStart();
        }
        if (this.curDialogId >= this.stack.getDialogIdRangeEnd()) {
            this.curDialogId = this.stack.getDialogIdRangeEnd() - 1L;
        }
    }

    protected int getNextSeqControl() {
        int res = this.seqControl.getAndIncrement();
        if (this.stack.getSlsRangeType() == SlsRangeType.Odd) {
            if (res % 2 == 0) {
                ++res;
            }
        } else if (this.stack.getSlsRangeType() == SlsRangeType.Even && res % 2 != 0) {
            ++res;
        }
        return res &= 0xFF;
    }

    @Override
    public ComponentPrimitiveFactory getComponentPrimitiveFactory() {
        return this.componentPrimitiveFactory;
    }

    @Override
    public DialogPrimitiveFactory getDialogPrimitiveFactory() {
        return this.dialogPrimitiveFactory;
    }

    @Override
    public Dialog getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        DialogImpl res = this.getNewDialog(localAddress, remoteAddress, this.getNextSeqControl(), null);
        if (this.stack.getStatisticsEnabled()) {
            this.stack.getCounterProviderImpl().updateAllLocalEstablishedDialogsCount();
            this.stack.getCounterProviderImpl().updateAllEstablishedDialogsCount();
        }
        this.setSsnToDialog(res, localAddress.getSubsystemNumber());
        return res;
    }

    @Override
    public Dialog getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress, Long id) throws TCAPException {
        DialogImpl res = this.getNewDialog(localAddress, remoteAddress, this.getNextSeqControl(), id);
        if (this.stack.getStatisticsEnabled()) {
            this.stack.getCounterProviderImpl().updateAllLocalEstablishedDialogsCount();
            this.stack.getCounterProviderImpl().updateAllEstablishedDialogsCount();
        }
        this.setSsnToDialog(res, localAddress.getSubsystemNumber());
        return res;
    }

    @Override
    public Dialog getNewUnstructuredDialog(SccpAddress localAddress, SccpAddress remoteAddress) throws TCAPException {
        DialogImpl res = this._getDialog(localAddress, remoteAddress, false, this.getNextSeqControl(), null);
        this.setSsnToDialog(res, localAddress.getSubsystemNumber());
        return res;
    }

    private DialogImpl getNewDialog(SccpAddress localAddress, SccpAddress remoteAddress, int seqControl, Long id) throws TCAPException {
        return this._getDialog(localAddress, remoteAddress, true, seqControl, id);
    }

    private DialogImpl _getDialog(SccpAddress localAddress, SccpAddress remoteAddress, boolean structured, int seqControl, Long id) throws TCAPException {
        if (this.stack.getPreviewMode()) {
            throw new TCAPException("Can not create a Dialog in a PreviewMode");
        }
        if (localAddress == null) {
            throw new NullPointerException("LocalAddress must not be null");
        }
        if (id == null) {
            id = this.getAvailableTxId();
        } else if (!this.checkAvailableTxId(id)) {
            throw new TCAPException("Suggested local TransactionId is already present in system: " + id);
        }
        if (structured) {
            DialogImpl di = new DialogImpl(localAddress, remoteAddress, id, structured, this._EXECUTOR, this, seqControl, this.stack.getPreviewMode());
            this.dialogs.put(id, di);
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateMinDialogsCount(this.dialogs.size());
                this.stack.getCounterProviderImpl().updateMaxDialogsCount(this.dialogs.size());
            }
            return di;
        }
        DialogImpl di = new DialogImpl(localAddress, remoteAddress, id, structured, this._EXECUTOR, this, seqControl, this.stack.getPreviewMode());
        return di;
    }

    private void setSsnToDialog(DialogImpl di, int ssn) {
        if (!(ssn == this.ssn || ssn > 0 && this.stack.isExtraSsnPresent(ssn))) {
            ssn = this.ssn;
        }
        di.setLocalSsn(ssn);
    }

    @Override
    public int getCurrentDialogsCount() {
        return this.dialogs.size();
    }

    public void send(byte[] data, boolean returnMessageOnError, SccpAddress destinationAddress, SccpAddress originatingAddress, int seqControl, int networkId, int localSsn) throws IOException {
        if (this.stack.getPreviewMode()) {
            return;
        }
        SccpDataMessage msg = this.messageFactory.createDataMessageClass1(destinationAddress, originatingAddress, data, seqControl, localSsn, returnMessageOnError, null, null);
        msg.setNetworkId(networkId);
        this.sccpProvider.updateSPCongestion(this.ssn, this.getCumulativeCongestionLevel());
        this.sccpProvider.send(msg);
    }

    public int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        return this.sccpProvider.getMaxUserDataLength(calledPartyAddress, callingPartyAddress, msgNetworkId);
    }

    public void deliver(DialogImpl dialogImpl, TCBeginIndicationImpl msg) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcBeginReceivedCount(dialogImpl);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCBegin(msg);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCContinueIndicationImpl tcContinueIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcContinueReceivedCount(dialogImpl);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCContinue(tcContinueIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCEndIndicationImpl tcEndIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcEndReceivedCount(dialogImpl);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCEnd(tcEndIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCPAbortIndicationImpl tcAbortIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcPAbortReceivedCount(dialogImpl, tcAbortIndication.getPAbortCause());
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCPAbort(tcAbortIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCUserAbortIndicationImpl tcAbortIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcUserAbortReceivedCount(dialogImpl);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCUserAbort(tcAbortIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCUniIndicationImpl tcUniIndication) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateTcUniReceivedCount(dialogImpl);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCUni(tcUniIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void deliver(DialogImpl dialogImpl, TCNoticeIndicationImpl tcNoticeIndication) {
        block3: {
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onTCNotice(tcNoticeIndication);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block3;
                logger.error("Received exception while delivering data to transport layer.", e);
            }
        }
    }

    public void release(DialogImpl d) {
        Long did = d.getLocalDialogId();
        if (!d.getPreviewMode()) {
            this.dialogs.remove(did);
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateMinDialogsCount(this.dialogs.size());
                this.stack.getCounterProviderImpl().updateMaxDialogsCount(this.dialogs.size());
            }
            this.doRelease(d);
        }
    }

    private void doRelease(DialogImpl d) {
        block4: {
            if (d.isStructured() && this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateDialogReleaseCount(d);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onDialogReleased(d);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering dialog release.", e);
            }
        }
    }

    public void timeout(DialogImpl d) {
        block4: {
            if (this.stack.getStatisticsEnabled()) {
                this.stack.getCounterProviderImpl().updateDialogTimeoutCount(d);
            }
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onDialogTimeout(d);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Received exception while delivering dialog release.", e);
            }
        }
    }

    @Override
    public TCAPStackImpl getStack() {
        return this.stack;
    }

    public Future createOperationTimer(Runnable operationTimerTask, long invokeTimeout) {
        return this._EXECUTOR.schedule(operationTimerTask, invokeTimeout, TimeUnit.MILLISECONDS);
    }

    public void operationTimedOut(InvokeImpl tcInvokeRequestImpl) {
        block3: {
            try {
                for (TCListener lst : this.tcListeners) {
                    lst.onInvokeTimeout(tcInvokeRequestImpl);
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block3;
                logger.error("Received exception while delivering Begin.", e);
            }
        }
    }

    void start() {
        logger.info("Starting TCAP Provider");
        this._EXECUTOR = Executors.newScheduledThreadPool(4, new DefaultThreadFactory("Tcap-Thread"));
        this.sccpProvider.registerSccpListener(this.ssn, this);
        logger.info("Registered SCCP listener with ssn " + this.ssn);
        List<Integer> extraSsns = this.stack.getExtraSsns();
        if (extraSsns != null) {
            for (Integer I1 : extraSsns) {
                if (I1 == null) continue;
                int extraSsn = I1;
                this.sccpProvider.registerSccpListener(extraSsn, this);
                logger.info("Registered SCCP listener with extra ssn " + extraSsn);
            }
        }
        this.updateNetworkIdStateList();
        this._EXECUTOR.scheduleWithFixedDelay(new CongestionExecutor(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.memoryCongestionMonitor = new MemoryCongestionMonitorImpl();
        this.lstUserPartCongestionLevel.clear();
    }

    void stop() {
        this.stopNetworkIdStateList();
        this._EXECUTOR.shutdown();
        this.sccpProvider.deregisterSccpListener(this.ssn);
        List<Integer> extraSsns = this.stack.getExtraSsns();
        if (extraSsns != null) {
            for (Integer I1 : extraSsns) {
                if (I1 == null) continue;
                int extraSsn = I1;
                this.sccpProvider.deregisterSccpListener(extraSsn);
            }
        }
        this.dialogs.clear();
        this.dialogPreviewList.clear();
    }

    protected void sendProviderAbort(PAbortCauseType pAbortCause, byte[] remoteTransactionId, SccpAddress remoteAddress, SccpAddress localAddress, int seqControl, int networkId) {
        block4: {
            if (this.stack.getPreviewMode()) {
                return;
            }
            TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
            msg.setDestinationTransactionId(remoteTransactionId);
            msg.setPAbortCause(pAbortCause);
            AsnOutputStream aos = new AsnOutputStream();
            try {
                msg.encode(aos);
                if (this.stack.getStatisticsEnabled()) {
                    this.stack.getCounterProviderImpl().updateTcPAbortSentCount(remoteTransactionId, pAbortCause);
                }
                this.send(aos.toByteArray(), false, remoteAddress, localAddress, seqControl, networkId, localAddress.getSubsystemNumber());
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Failed to send message: ", e);
            }
        }
    }

    protected void sendProviderAbort(DialogServiceProviderType pt, byte[] remoteTransactionId, SccpAddress remoteAddress, SccpAddress localAddress, int seqControl, ApplicationContextName acn, int networkId) {
        block4: {
            if (this.stack.getPreviewMode()) {
                return;
            }
            DialogPortion dp = TcapFactory.createDialogPortion();
            dp.setUnidirectional(false);
            DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
            apdu.setDoNotSendProtocolVersion(this.getStack().getDoNotSendProtocolVersion());
            Result res = TcapFactory.createResult();
            res.setResultType(ResultType.RejectedPermanent);
            ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
            rsd.setDialogServiceProviderType(pt);
            apdu.setResultSourceDiagnostic(rsd);
            apdu.setResult(res);
            apdu.setApplicationContextName(acn);
            dp.setDialogAPDU(apdu);
            TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
            msg.setDestinationTransactionId(remoteTransactionId);
            msg.setDialogPortion(dp);
            AsnOutputStream aos = new AsnOutputStream();
            try {
                msg.encode(aos);
                if (this.stack.getStatisticsEnabled()) {
                    this.stack.getCounterProviderImpl().updateTcPAbortSentCount(remoteTransactionId, PAbortCauseType.NoReasonGiven);
                }
                this.send(aos.toByteArray(), false, remoteAddress, localAddress, seqControl, networkId, localAddress.getSubsystemNumber());
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) break block4;
                logger.error("Failed to send message: ", e);
            }
        }
    }

    @Override
    public void onMessage(SccpDataMessage message) {
        try {
            byte[] data = message.getData();
            SccpAddress localAddress = message.getCalledPartyAddress();
            SccpAddress remoteAddress = message.getCallingPartyAddress();
            AsnInputStream ais = new AsnInputStream(data);
            int tag = ais.readTag();
            if (ais.getTagClass() != 1) {
                this.unrecognizedPackageType(message, localAddress, remoteAddress, ais, tag, message.getNetworkId());
                return;
            }
            switch (tag) {
                case 5: {
                    DialogImpl di;
                    TCContinueMessage tcm = null;
                    try {
                        tcm = TcapFactory.createTCContinueMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCContinueMessage: " + e.toString(), e);
                        ais = new AsnInputStream(data);
                        tag = ais.readTag();
                        TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
                        tcUnidentified.decode(ais);
                        if (tcUnidentified.getOriginatingTransactionId() != null) {
                            if (e.getPAbortCauseType() != null) {
                                this.sendProviderAbort(e.getPAbortCauseType(), tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            } else {
                                this.sendProviderAbort(PAbortCauseType.BadlyFormattedTxPortion, tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            }
                        }
                        return;
                    }
                    if (this.stack.isCongControl_blockingIncomingTcapMessages() && this.cumulativeCongestionLevel >= 3) {
                        this.sendProviderAbort(PAbortCauseType.ResourceLimitation, tcm.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                        return;
                    }
                    long dialogId = Utils.decodeTransactionId(tcm.getDestinationTransactionId());
                    if (this.stack.getPreviewMode()) {
                        PreviewDialogDataKey ky1 = new PreviewDialogDataKey(message.getIncomingDpc(), message.getCalledPartyAddress().getGlobalTitle() != null ? message.getCalledPartyAddress().getGlobalTitle().getDigits() : null, message.getCalledPartyAddress().getSubsystemNumber(), dialogId);
                        long dId = Utils.decodeTransactionId(tcm.getOriginatingTransactionId());
                        PreviewDialogDataKey ky2 = new PreviewDialogDataKey(message.getIncomingOpc(), message.getCallingPartyAddress().getGlobalTitle() != null ? message.getCallingPartyAddress().getGlobalTitle().getDigits() : null, message.getCallingPartyAddress().getSubsystemNumber(), dId);
                        di = (DialogImpl)this.getPreviewDialog(ky1, ky2, localAddress, remoteAddress, 0);
                        this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                    } else {
                        di = this.dialogs.get(dialogId);
                    }
                    if (di == null) {
                        logger.warn("TC-CONTINUE: No dialog/transaction for id: " + dialogId);
                        this.sendProviderAbort(PAbortCauseType.UnrecognizedTxID, tcm.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                        break;
                    }
                    di.processContinue(tcm, localAddress, remoteAddress);
                    break;
                }
                case 2: {
                    DialogRequestAPDUImpl dlg;
                    TCBeginMessage tcb = null;
                    try {
                        tcb = TcapFactory.createTCBeginMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCBeginMessage: " + e.toString(), e);
                        ais = new AsnInputStream(data);
                        tag = ais.readTag();
                        TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
                        tcUnidentified.decode(ais);
                        if (tcUnidentified.getOriginatingTransactionId() != null) {
                            if (e.getPAbortCauseType() != null) {
                                this.sendProviderAbort(e.getPAbortCauseType(), tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            } else {
                                this.sendProviderAbort(PAbortCauseType.BadlyFormattedTxPortion, tcUnidentified.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                            }
                        }
                        return;
                    }
                    if (tcb.getDialogPortion() != null && tcb.getDialogPortion().getDialogAPDU() != null && tcb.getDialogPortion().getDialogAPDU() instanceof DialogRequestAPDUImpl && !(dlg = (DialogRequestAPDUImpl)tcb.getDialogPortion().getDialogAPDU()).getProtocolVersion().isSupportedVersion()) {
                        logger.error("Unsupported protocol version of  has been received when parsing TCBeginMessage");
                        this.sendProviderAbort(DialogServiceProviderType.NoCommonDialogPortion, tcb.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), dlg.getApplicationContextName(), message.getNetworkId());
                        return;
                    }
                    if (this.stack.isCongControl_blockingIncomingTcapMessages() && this.cumulativeCongestionLevel >= 2) {
                        this.sendProviderAbort(PAbortCauseType.ResourceLimitation, tcb.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                        return;
                    }
                    DialogImpl di = null;
                    try {
                        if (this.stack.getPreviewMode()) {
                            long dId = Utils.decodeTransactionId(tcb.getOriginatingTransactionId());
                            PreviewDialogDataKey ky = new PreviewDialogDataKey(message.getIncomingOpc(), message.getCallingPartyAddress().getGlobalTitle() != null ? message.getCallingPartyAddress().getGlobalTitle().getDigits() : null, message.getCallingPartyAddress().getSubsystemNumber(), dId);
                            di = (DialogImpl)this.createPreviewDialog(ky, localAddress, remoteAddress, 0);
                            this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                        } else {
                            di = this.getNewDialog(localAddress, remoteAddress, message.getSls(), null);
                            this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                        }
                    }
                    catch (TCAPException e) {
                        this.sendProviderAbort(PAbortCauseType.ResourceLimitation, tcb.getOriginatingTransactionId(), remoteAddress, localAddress, message.getSls(), message.getNetworkId());
                        logger.error("Can not add a new dialog when receiving TCBeginMessage: " + e.getMessage(), e);
                        return;
                    }
                    if (this.stack.getStatisticsEnabled()) {
                        this.stack.getCounterProviderImpl().updateAllRemoteEstablishedDialogsCount();
                        this.stack.getCounterProviderImpl().updateAllEstablishedDialogsCount();
                    }
                    di.setNetworkId(message.getNetworkId());
                    di.processBegin(tcb, localAddress, remoteAddress);
                    if (this.stack.getPreviewMode()) {
                        di.getPrevewDialogData().setLastACN(di.getApplicationContextName());
                        di.getPrevewDialogData().setOperationsSentB(di.operationsSent);
                        di.getPrevewDialogData().setOperationsSentA(di.operationsSentA);
                    }
                    break;
                }
                case 4: {
                    DialogImpl di;
                    TCEndMessage teb = null;
                    try {
                        teb = TcapFactory.createTCEndMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCEndMessage: " + e.toString(), e);
                        return;
                    }
                    if (this.stack.isCongControl_blockingIncomingTcapMessages() && this.cumulativeCongestionLevel >= 3) {
                        return;
                    }
                    long dialogId = Utils.decodeTransactionId(teb.getDestinationTransactionId());
                    if (this.stack.getPreviewMode()) {
                        PreviewDialogDataKey ky = new PreviewDialogDataKey(message.getIncomingDpc(), message.getCalledPartyAddress().getGlobalTitle() != null ? message.getCalledPartyAddress().getGlobalTitle().getDigits() : null, message.getCalledPartyAddress().getSubsystemNumber(), dialogId);
                        di = (DialogImpl)this.getPreviewDialog(ky, null, localAddress, remoteAddress, 0);
                        this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                    } else {
                        di = this.dialogs.get(dialogId);
                    }
                    if (di == null) {
                        logger.warn("TC-END: No dialog/transaction for id: " + dialogId);
                        break;
                    }
                    di.processEnd(teb, localAddress, remoteAddress);
                    if (this.stack.getPreviewMode()) {
                        this.removePreviewDialog(di);
                    }
                    break;
                }
                case 7: {
                    DialogImpl di;
                    TCAbortMessage tub = null;
                    try {
                        tub = TcapFactory.createTCAbortMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCAbortMessage: " + e.toString(), e);
                        return;
                    }
                    if (this.stack.isCongControl_blockingIncomingTcapMessages() && this.cumulativeCongestionLevel >= 3) {
                        return;
                    }
                    long dialogId = Utils.decodeTransactionId(tub.getDestinationTransactionId());
                    if (this.stack.getPreviewMode()) {
                        long dId = Utils.decodeTransactionId(tub.getDestinationTransactionId());
                        PreviewDialogDataKey ky = new PreviewDialogDataKey(message.getIncomingDpc(), message.getCalledPartyAddress().getGlobalTitle() != null ? message.getCalledPartyAddress().getGlobalTitle().getDigits() : null, message.getCalledPartyAddress().getSubsystemNumber(), dId);
                        di = (DialogImpl)this.getPreviewDialog(ky, null, localAddress, remoteAddress, 0);
                        this.setSsnToDialog(di, message.getCalledPartyAddress().getSubsystemNumber());
                    } else {
                        di = this.dialogs.get(dialogId);
                    }
                    if (di == null) {
                        logger.warn("TC-ABORT: No dialog/transaction for id: " + dialogId);
                        break;
                    }
                    di.processAbort(tub, localAddress, remoteAddress);
                    if (this.stack.getPreviewMode()) {
                        this.removePreviewDialog(di);
                    }
                    break;
                }
                case 1: {
                    TCUniMessage tcuni;
                    try {
                        tcuni = TcapFactory.createTCUniMessage(ais);
                    }
                    catch (ParseException e) {
                        logger.error("ParseException when parsing TCUniMessage: " + e.toString(), e);
                        return;
                    }
                    if (this.stack.isCongControl_blockingIncomingTcapMessages() && this.cumulativeCongestionLevel >= 3) {
                        return;
                    }
                    DialogImpl uniDialog = (DialogImpl)this.getNewUnstructuredDialog(localAddress, remoteAddress);
                    this.setSsnToDialog(uniDialog, message.getCalledPartyAddress().getSubsystemNumber());
                    uniDialog.processUni(tcuni, localAddress, remoteAddress);
                    break;
                }
                default: {
                    this.unrecognizedPackageType(message, localAddress, remoteAddress, ais, tag, message.getNetworkId());
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(String.format("Error while decoding Rx SccpMessage=%s", message), e);
        }
    }

    private void unrecognizedPackageType(SccpDataMessage message, SccpAddress localAddress, SccpAddress remoteAddress, AsnInputStream ais, int tag, int networkId) throws ParseException {
        if (this.stack.getPreviewMode()) {
            return;
        }
        logger.error(String.format("Rx unidentified tag=%s, tagClass=. SccpMessage=%s", tag, ais.getTagClass(), message));
        TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
        tcUnidentified.decode(ais);
        if (tcUnidentified.getOriginatingTransactionId() != null) {
            byte[] otid = tcUnidentified.getOriginatingTransactionId();
            if (tcUnidentified.getDestinationTransactionId() != null) {
                Long dtid = Utils.decodeTransactionId(tcUnidentified.getDestinationTransactionId());
                this.sendProviderAbort(PAbortCauseType.UnrecognizedMessageType, otid, remoteAddress, localAddress, message.getSls(), networkId);
            } else {
                this.sendProviderAbort(PAbortCauseType.UnrecognizedMessageType, otid, remoteAddress, localAddress, message.getSls(), networkId);
            }
        } else {
            this.sendProviderAbort(PAbortCauseType.UnrecognizedMessageType, new byte[0], remoteAddress, localAddress, message.getSls(), networkId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onNotice(SccpNoticeMessage msg) {
        if (this.stack.getPreviewMode()) {
            return;
        }
        DialogImpl dialog = null;
        try {
            byte[] data = msg.getData();
            AsnInputStream ais = new AsnInputStream(data);
            int tag = ais.readTag();
            TCUnidentifiedMessage tcUnidentified = new TCUnidentifiedMessage();
            tcUnidentified.decode(ais);
            if (tcUnidentified.getOriginatingTransactionId() != null) {
                long otid = Utils.decodeTransactionId(tcUnidentified.getOriginatingTransactionId());
                dialog = this.dialogs.get(otid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(String.format("Error while decoding Rx SccpNoticeMessage=%s", msg), e);
        }
        TCNoticeIndicationImpl ind = new TCNoticeIndicationImpl();
        ind.setRemoteAddress(msg.getCallingPartyAddress());
        ind.setLocalAddress(msg.getCalledPartyAddress());
        ind.setDialog(dialog);
        ind.setReportCause(msg.getReturnCause().getValue());
        if (dialog != null) {
            try {
                dialog.dialogLock.lock();
                this.deliver(dialog, ind);
                if (dialog.getState() == TRPseudoState.Active) return;
                dialog.release();
                return;
            }
            finally {
                dialog.dialogLock.unlock();
            }
        } else {
            this.deliver(dialog, ind);
        }
    }

    protected Dialog createPreviewDialog(PreviewDialogDataKey ky, SccpAddress localAddress, SccpAddress remoteAddress, int seqControl) throws TCAPException {
        if (this.dialogPreviewList.size() >= this.stack.getMaxDialogs()) {
            throw new TCAPException("Current dialog count exceeds its maximum value");
        }
        Long dialogId = this.getAvailableTxIdPreview();
        PreviewDialogData pdd = new PreviewDialogData(this, dialogId);
        pdd.setPrevewDialogDataKey1(ky);
        PreviewDialogData pddx = this.dialogPreviewList.putIfAbsent(ky, pdd);
        if (pddx != null) {
            this.removePreviewDialog(pddx);
            throw new TCAPException("Dialog with trId=" + ky.origTxId + " is already exists - we ignore it and drops curent dialog");
        }
        DialogImpl di = new DialogImpl(localAddress, remoteAddress, seqControl, this._EXECUTOR, this, pdd, false);
        pdd.startIdleTimer();
        return di;
    }

    protected synchronized Long getAvailableTxIdPreview() throws TCAPException {
        if (this.curDialogId < this.stack.getDialogIdRangeStart()) {
            this.curDialogId = this.stack.getDialogIdRangeStart() - 1L;
        }
        if (++this.curDialogId > this.stack.getDialogIdRangeEnd()) {
            this.curDialogId = this.stack.getDialogIdRangeStart();
        }
        Long id = this.curDialogId;
        return id;
    }

    protected Dialog getPreviewDialog(PreviewDialogDataKey ky1, PreviewDialogDataKey ky2, SccpAddress localAddress, SccpAddress remoteAddress, int seqControl) {
        PreviewDialogData pdd = this.dialogPreviewList.get(ky1);
        DialogImpl di = null;
        boolean sideB = false;
        if (pdd != null) {
            sideB = pdd.getPrevewDialogDataKey1().equals(ky1);
            di = new DialogImpl(localAddress, remoteAddress, seqControl, this._EXECUTOR, this, pdd, sideB);
        } else {
            if (ky2 != null) {
                pdd = this.dialogPreviewList.get(ky2);
            }
            if (pdd != null) {
                sideB = pdd.getPrevewDialogDataKey1().equals(ky1);
                di = new DialogImpl(localAddress, remoteAddress, seqControl, this._EXECUTOR, this, pdd, sideB);
            } else {
                return null;
            }
        }
        pdd.restartIdleTimer();
        if (pdd.getPrevewDialogDataKey2() == null && ky2 != null) {
            if (pdd.getPrevewDialogDataKey1().equals(ky1)) {
                pdd.setPrevewDialogDataKey2(ky2);
            } else {
                pdd.setPrevewDialogDataKey2(ky1);
            }
            this.dialogPreviewList.put(pdd.getPrevewDialogDataKey2(), pdd);
        }
        return di;
    }

    protected void removePreviewDialog(DialogImpl di) {
        PreviewDialogData pdd = this.dialogPreviewList.get(di.prevewDialogData.getPrevewDialogDataKey1());
        if (pdd == null && di.prevewDialogData.getPrevewDialogDataKey2() != null) {
            pdd = this.dialogPreviewList.get(di.prevewDialogData.getPrevewDialogDataKey2());
        }
        if (pdd != null) {
            this.removePreviewDialog(pdd);
        }
        this.doRelease(di);
    }

    protected void removePreviewDialog(PreviewDialogData pdd) {
        this.dialogPreviewList.remove(pdd.getPrevewDialogDataKey1());
        if (pdd.getPrevewDialogDataKey2() != null) {
            this.dialogPreviewList.remove(pdd.getPrevewDialogDataKey2());
        }
        pdd.stopIdleTimer();
    }

    @Override
    public DraftParsedMessage parseMessageDraft(byte[] data) {
        try {
            DraftParsedMessageImpl res = new DraftParsedMessageImpl();
            AsnInputStream ais = new AsnInputStream(data);
            int tag = ais.readTag();
            if (ais.getTagClass() != 1) {
                res.setParsingErrorReason("Message tag class must be CLASS_APPLICATION");
                return res;
            }
            switch (tag) {
                case 5: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 8 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("originatingTransactionId tag/tagClass is bad for TC-CONTINUE message");
                        return res;
                    }
                    byte[] originatingTransactionId = localAis.readOctetString();
                    res.setOriginationDialogId(Utils.decodeTransactionId(originatingTransactionId));
                    tag = localAis.readTag();
                    if (tag != 9 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("destinationTransactionId tag/tagClass is bad for TC-CONTINUE message");
                        return res;
                    }
                    byte[] destinationTransactionId = localAis.readOctetString();
                    res.setDestinationDialogId(Utils.decodeTransactionId(destinationTransactionId));
                    res.setMessageType(MessageType.Continue);
                    break;
                }
                case 2: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 8 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("originatingTransactionId tag/tagClass is bad for TC-BEGIN message");
                        return res;
                    }
                    byte[] originatingTransactionId = localAis.readOctetString();
                    res.setOriginationDialogId(Utils.decodeTransactionId(originatingTransactionId));
                    res.setMessageType(MessageType.Begin);
                    break;
                }
                case 4: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 9 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("destinationTransactionId tag/tagClass is bad for TC-END message");
                        return res;
                    }
                    byte[] destinationTransactionId = localAis.readOctetString();
                    res.setDestinationDialogId(Utils.decodeTransactionId(destinationTransactionId));
                    res.setMessageType(MessageType.End);
                    break;
                }
                case 7: {
                    AsnInputStream localAis = ais.readSequenceStream();
                    tag = localAis.readTag();
                    if (tag != 9 || localAis.getTagClass() != 1) {
                        res.setParsingErrorReason("destinationTransactionId tag/tagClass is bad for TC-ABORT message");
                        return res;
                    }
                    byte[] destinationTransactionId = localAis.readOctetString();
                    res.setDestinationDialogId(Utils.decodeTransactionId(destinationTransactionId));
                    res.setMessageType(MessageType.Abort);
                    break;
                }
                case 1: {
                    res.setMessageType(MessageType.Unidirectional);
                    break;
                }
                default: {
                    res.setParsingErrorReason("Unrecognized message tag");
                }
            }
            return res;
        }
        catch (Exception e) {
            DraftParsedMessageImpl res = new DraftParsedMessageImpl();
            res.setParsingErrorReason("Exception when message parsing: " + e.getMessage());
            return res;
        }
    }

    @Override
    public void onCoordResponse(int ssn, int multiplicityIndicator) {
    }

    @Override
    public void onState(int dpc, int ssn, boolean inService, int multiplicityIndicator) {
    }

    @Override
    public void onPcState(int dpc, SignallingPointStatus status, Integer restrictedImportanceLevel, RemoteSccpStatus remoteSccpStatus) {
    }

    @Override
    public void onNetworkIdState(int networkId, NetworkIdState networkIdState) {
        Integer ni = networkId;
        NetworkIdState prev = this.networkIdStateList.get(ni);
        if (!networkIdState.equals(prev)) {
            logger.warn("Outgoing congestion control: TCAP: onNetworkIdState: networkId=" + networkId + ", networkIdState=" + networkIdState);
        }
        this.networkIdStateList.put(ni, networkIdState);
    }

    @Override
    public void onConnectIndication(SccpConnection conn, SccpAddress calledAddress, SccpAddress callingAddress, ProtocolClass clazz, Credit credit, byte[] data, Importance importance) throws Exception {
    }

    @Override
    public void onConnectConfirm(SccpConnection conn, byte[] data) {
    }

    @Override
    public void onDisconnectIndication(SccpConnection conn, ReleaseCause reason, byte[] data) {
    }

    @Override
    public void onDisconnectIndication(SccpConnection conn, RefusalCause reason, byte[] data) {
    }

    @Override
    public void onDisconnectIndication(SccpConnection conn, ErrorCause errorCause) {
    }

    @Override
    public void onResetIndication(SccpConnection conn, ResetCause reason) {
    }

    @Override
    public void onResetConfirm(SccpConnection conn) {
    }

    @Override
    public void onData(SccpConnection conn, byte[] data) {
    }

    @Override
    public void onDisconnectConfirm(SccpConnection conn) {
    }

    @Override
    public FastMap<Integer, NetworkIdState> getNetworkIdStateList() {
        return this.networkIdStateList;
    }

    @Override
    public NetworkIdState getNetworkIdState(int networkId) {
        return this.networkIdStateList.get(networkId);
    }

    private void stopNetworkIdStateList() {
        NetworkIdStateListUpdater curUpd = this.currentNetworkIdStateListUpdater;
        if (curUpd != null) {
            curUpd.cancel();
        }
    }

    private void updateNetworkIdStateList() {
        this.stopNetworkIdStateList();
        this.currentNetworkIdStateListUpdater = new NetworkIdStateListUpdater();
        this._EXECUTOR.schedule(this.currentNetworkIdStateListUpdater, 1000L, TimeUnit.MILLISECONDS);
        this.networkIdStateList = this.sccpProvider.getNetworkIdStateList();
        int cntNotAvailable = 0;
        int cntCongLevel1 = 0;
        int cntCongLevel2 = 0;
        int cntCongLevel3 = 0;
        if (this.networkIdStateList != null) {
            for (NetworkIdState state : this.networkIdStateList.values()) {
                if (!state.isAvailavle()) {
                    ++cntNotAvailable;
                }
                if (state.getCongLevel() >= 1) {
                    ++cntCongLevel1;
                }
                if (state.getCongLevel() >= 2) {
                    ++cntCongLevel1;
                    ++cntCongLevel2;
                }
                if (state.getCongLevel() < 3) continue;
                ++cntCongLevel1;
                ++cntCongLevel2;
                ++cntCongLevel3;
            }
        }
        this.stack.getCounterProviderImpl().updateMaxNetworkIdAreasNotAvailable(cntNotAvailable);
        this.stack.getCounterProviderImpl().updateMaxNetworkIdAreasCongLevel_1(cntCongLevel1);
        this.stack.getCounterProviderImpl().updateMaxNetworkIdAreasCongLevel_2(cntCongLevel2);
        this.stack.getCounterProviderImpl().updateMaxNetworkIdAreasCongLevel_3(cntCongLevel3);
    }

    public int getNetworkIdAreasNotAvailableCount() {
        int cntNotAvailable = 0;
        for (NetworkIdState state : this.networkIdStateList.values()) {
            if (state.isAvailavle()) continue;
            ++cntNotAvailable;
        }
        return cntNotAvailable;
    }

    public int getNetworkIdAreasCongLevel_1_Count() {
        int cntCongLevel1 = 0;
        for (NetworkIdState state : this.networkIdStateList.values()) {
            if (state.getCongLevel() < 1) continue;
            ++cntCongLevel1;
        }
        return cntCongLevel1;
    }

    public int getNetworkIdAreasCongLevel_2_Count() {
        int cntCongLevel2 = 0;
        for (NetworkIdState state : this.networkIdStateList.values()) {
            if (state.getCongLevel() < 2) continue;
            ++cntCongLevel2;
        }
        return cntCongLevel2;
    }

    public int getNetworkIdAreasCongLevel_3_Count() {
        int cntCongLevel3 = 0;
        for (NetworkIdState state : this.networkIdStateList.values()) {
            if (state.getCongLevel() < 3) continue;
            ++cntCongLevel3;
        }
        return cntCongLevel3;
    }

    @Override
    public synchronized void setUserPartCongestionLevel(String congObject, int level) {
        if (congObject != null) {
            if (level > 0) {
                this.lstUserPartCongestionLevel.put(congObject, level);
            } else {
                this.lstUserPartCongestionLevel.remove(congObject);
            }
            int cntUserPartCongestionLevel_1 = 0;
            int cntUserPartCongestionLevel_2 = 0;
            int cntUserPartCongestionLevel_3 = 0;
            for (Integer lev : this.lstUserPartCongestionLevel.values()) {
                if (lev >= 1) {
                    ++cntUserPartCongestionLevel_1;
                }
                if (lev >= 2) {
                    ++cntUserPartCongestionLevel_1;
                    ++cntUserPartCongestionLevel_2;
                }
                if (lev < 3) continue;
                ++cntUserPartCongestionLevel_1;
                ++cntUserPartCongestionLevel_2;
                ++cntUserPartCongestionLevel_3;
            }
            this.userPartCongestionLevel_1 = cntUserPartCongestionLevel_1;
            this.userPartCongestionLevel_2 = cntUserPartCongestionLevel_2;
            this.userPartCongestionLevel_3 = cntUserPartCongestionLevel_3;
            this.stack.getCounterProviderImpl().updateMaxUserPartsCongLevel_1(this.userPartCongestionLevel_1);
            this.stack.getCounterProviderImpl().updateMaxUserPartsCongLevel_2(this.userPartCongestionLevel_2);
            this.stack.getCounterProviderImpl().updateMaxUserPartsCongLevel_3(this.userPartCongestionLevel_3);
        }
    }

    @Override
    public int getMemoryCongestionLevel() {
        return this.memoryCongestionMonitor.getAlarmLevel();
    }

    @Override
    public int getExecutorCongestionLevel() {
        return this.executorCongestionLevel;
    }

    public int getExecutorCountWithCongestionLevel_1() {
        return this.executorCountWithCongestionLevel_1;
    }

    public int getExecutorCountWithCongestionLevel_2() {
        return this.executorCountWithCongestionLevel_2;
    }

    public int getExecutorCountWithCongestionLevel_3() {
        return this.executorCountWithCongestionLevel_3;
    }

    public int getUserPartCongestionLevel_1() {
        return this.userPartCongestionLevel_1;
    }

    public int getUserPartCongestionLevel_2() {
        return this.userPartCongestionLevel_2;
    }

    public int getUserPartCongestionLevel_3() {
        return this.userPartCongestionLevel_3;
    }

    @Override
    public int getCumulativeCongestionLevel() {
        int level = 0;
        for (Integer lev : this.lstUserPartCongestionLevel.values()) {
            if (level >= lev) continue;
            level = lev;
        }
        int lev2 = this.getMemoryCongestionLevel();
        if (level < lev2) {
            level = lev2;
        }
        if (level < (lev2 = this.getExecutorCongestionLevel())) {
            level = lev2;
        }
        return level;
    }

    protected String getCumulativeCongestionLevelString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CongestionLevel=[");
        boolean i1 = false;
        int lev2 = this.getMemoryCongestionLevel();
        if (lev2 > 0) {
            sb.append("MemoryCongestionLevel=");
            sb.append(lev2);
        }
        if ((lev2 = this.getExecutorCongestionLevel()) > 0) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append("ExecutorCongestionLevel=");
            sb.append(lev2);
        }
        for (Map.Entry<String, Integer> entry : this.lstUserPartCongestionLevel.entrySet()) {
            lev2 = entry.getValue();
            if (lev2 <= 0) continue;
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append("UserPartCongestion=");
            sb.append(entry.getKey());
            sb.append("-");
            sb.append(lev2);
        }
        if (this.stack.isCongControl_blockingIncomingTcapMessages()) {
            lev2 = this.getCumulativeCongestionLevel();
            if (lev2 == 3) {
                sb.append(", all incoming TCAP messages will be rejected");
            }
            if (lev2 == 2) {
                sb.append(", new incoming TCAP dialogs will be rejected");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private class CongestionExecutor
    implements Runnable {
        private CongestionExecutor() {
        }

        @Override
        public void run() {
            ExecutorCongestionMonitor[] lst = TCAPProviderImpl.this.sccpProvider.getExecutorCongestionMonitorList();
            int maxExecutorCongestionLevel = 0;
            int countExecutorCountWithCongestionLevel_1 = 0;
            int countExecutorCountWithCongestionLevel_2 = 0;
            int countExecutorCountWithCongestionLevel_3 = 0;
            for (ExecutorCongestionMonitor ecm : lst) {
                int level = ecm.getAlarmLevel();
                if (maxExecutorCongestionLevel < level) {
                    maxExecutorCongestionLevel = level;
                }
                if (level >= 1) {
                    ++countExecutorCountWithCongestionLevel_1;
                }
                if (level >= 2) {
                    ++countExecutorCountWithCongestionLevel_1;
                    ++countExecutorCountWithCongestionLevel_2;
                }
                if (level >= 3) {
                    ++countExecutorCountWithCongestionLevel_1;
                    ++countExecutorCountWithCongestionLevel_2;
                    ++countExecutorCountWithCongestionLevel_3;
                }
                try {
                    ecm.setDelayThreshold_1(TCAPProviderImpl.this.stack.getCongControl_ExecutorDelayThreshold_1());
                    ecm.setDelayThreshold_2(TCAPProviderImpl.this.stack.getCongControl_ExecutorDelayThreshold_2());
                    ecm.setDelayThreshold_3(TCAPProviderImpl.this.stack.getCongControl_ExecutorDelayThreshold_3());
                    ecm.setBackToNormalDelayThreshold_1(TCAPProviderImpl.this.stack.getCongControl_ExecutorBackToNormalDelayThreshold_1());
                    ecm.setBackToNormalDelayThreshold_2(TCAPProviderImpl.this.stack.getCongControl_ExecutorBackToNormalDelayThreshold_2());
                    ecm.setBackToNormalDelayThreshold_3(TCAPProviderImpl.this.stack.getCongControl_ExecutorBackToNormalDelayThreshold_3());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TCAPProviderImpl.this.executorCongestionLevel = maxExecutorCongestionLevel;
            TCAPProviderImpl.this.executorCountWithCongestionLevel_1 = countExecutorCountWithCongestionLevel_1;
            TCAPProviderImpl.this.executorCountWithCongestionLevel_2 = countExecutorCountWithCongestionLevel_2;
            TCAPProviderImpl.this.executorCountWithCongestionLevel_3 = countExecutorCountWithCongestionLevel_3;
            TCAPProviderImpl.this.stack.getCounterProviderImpl().updateMaxExecutorsCongLevel_1(TCAPProviderImpl.this.executorCountWithCongestionLevel_1);
            TCAPProviderImpl.this.stack.getCounterProviderImpl().updateMaxExecutorsCongLevel_2(TCAPProviderImpl.this.executorCountWithCongestionLevel_2);
            TCAPProviderImpl.this.stack.getCounterProviderImpl().updateMaxExecutorsCongLevel_3(TCAPProviderImpl.this.executorCountWithCongestionLevel_3);
            TCAPProviderImpl.this.memoryCongestionMonitor.setMemoryThreshold1(TCAPProviderImpl.this.stack.getCongControl_MemoryThreshold_1());
            TCAPProviderImpl.this.memoryCongestionMonitor.setMemoryThreshold2(TCAPProviderImpl.this.stack.getCongControl_MemoryThreshold_2());
            TCAPProviderImpl.this.memoryCongestionMonitor.setMemoryThreshold3(TCAPProviderImpl.this.stack.getCongControl_MemoryThreshold_3());
            TCAPProviderImpl.this.memoryCongestionMonitor.setBackToNormalMemoryThreshold1(TCAPProviderImpl.this.stack.getCongControl_BackToNormalMemoryThreshold_1());
            TCAPProviderImpl.this.memoryCongestionMonitor.setBackToNormalMemoryThreshold2(TCAPProviderImpl.this.stack.getCongControl_BackToNormalMemoryThreshold_2());
            TCAPProviderImpl.this.memoryCongestionMonitor.setBackToNormalMemoryThreshold3(TCAPProviderImpl.this.stack.getCongControl_BackToNormalMemoryThreshold_3());
            TCAPProviderImpl.this.memoryCongestionMonitor.monitor();
            TCAPProviderImpl.this.stack.getCounterProviderImpl().updateMaxMemoryCongLevel(TCAPProviderImpl.this.memoryCongestionMonitor.getAlarmLevel());
            int newCumulativeCongestionLevel = TCAPProviderImpl.this.getCumulativeCongestionLevel();
            if (TCAPProviderImpl.this.cumulativeCongestionLevel != newCumulativeCongestionLevel) {
                logger.warn("Outgoing congestion control: Changing of internal congestion level: " + TCAPProviderImpl.this.cumulativeCongestionLevel + "->" + newCumulativeCongestionLevel + "\n" + TCAPProviderImpl.this.getCumulativeCongestionLevelString());
                TCAPProviderImpl.this.cumulativeCongestionLevel = newCumulativeCongestionLevel;
            }
        }
    }

    private class NetworkIdStateListUpdater
    implements Runnable,
    Serializable {
        private boolean isCancelled;

        private NetworkIdStateListUpdater() {
        }

        public void cancel() {
            this.isCancelled = true;
        }

        @Override
        public void run() {
            if (this.isCancelled || !TCAPProviderImpl.this.stack.isStarted()) {
                return;
            }
            TCAPProviderImpl.this.updateNetworkIdStateList();
        }
    }
}

