/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.indicator.RoutingIndicator;
import org.restcomm.protocols.ss7.mtp.Mtp3EndCongestionPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3StatusCause;
import org.restcomm.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPart;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPartListener;
import org.restcomm.protocols.ss7.sccp.LongMessageRule;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.MaxConnectionCountReached;
import org.restcomm.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.restcomm.protocols.ss7.sccp.NetworkIdState;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.Router;
import org.restcomm.protocols.ss7.sccp.Rule;
import org.restcomm.protocols.ss7.sccp.SccpCongestionControlAlgo;
import org.restcomm.protocols.ss7.sccp.SccpConnectionState;
import org.restcomm.protocols.ss7.sccp.SccpManagementEventListener;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.SccpProvider;
import org.restcomm.protocols.ss7.sccp.SccpResource;
import org.restcomm.protocols.ss7.sccp.SccpStack;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionWithFlowControlImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpManagement;
import org.restcomm.protocols.ss7.sccp.impl.SccpProviderImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpResourceImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.congestion.SccpCongestionControl;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageUtil;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpDataNoticeTemplateMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SegmentationImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.RouterImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;
import org.restcomm.protocols.ss7.scheduler.Scheduler;

public class SccpStackImpl
implements SccpStack,
Mtp3UserPartListener {
    protected final Logger logger;
    protected static final String SCCP_MANAGEMENT_PERSIST_DIR_KEY = "sccpmanagement.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    protected static final String PERSIST_FILE_NAME = "management2.xml";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final String Z_MARGIN_UDT_MSG = "zmarginxudtmessage";
    private static final String CONN_EST_TIMER_DELAY = "connesttimerdelay";
    private static final String IAS_TIMER_DELAY = "iastimerdelay";
    private static final String IAR_TIMER_DELAY = "iartimerdelay";
    private static final String REL_TIMER_DELAY = "reltimerdelay";
    private static final String REPEAT_REL_TIMER_DELAY = "repeatreltimerdelay";
    private static final String INT_TIMER_DELAY = "inttimerdelay";
    private static final String GUARD_TIMER_DELAY = "guardtimerdelay";
    private static final String RESET_TIMER_DELAY = "resettimerdelay";
    private static final String REASSEMBLY_TIMER_DELAY = "reassemblytimerdelay";
    private static final String MAX_DATA_MSG = "maxdatamessage";
    private static final String PERIOD_OF_LOG = "periodoflogging";
    private static final String REMOVE_SPC = "removespc";
    private static final String CAN_RELAY = "canrelay";
    private static final String RESERVED_FOR_NATIONAL_USE_VALUE_ADDRESS_INDICATOR = "reservedfornationalusevalue_addressindicator";
    private static final String SCCP_PROTOCOL_VERSION = "sccpProtocolVersion";
    private static final String PREVIEW_MODE = "previewMode";
    private static final String SST_TIMER_DURATION_MIN = "ssttimerduration_min";
    private static final String SST_TIMER_DURATION_MAX = "ssttimerduration_max";
    private static final String SST_TIMER_DURATION_INCREASE_FACTOR = "ssttimerduration_increasefactor";
    private static final String CONG_CONTROL_TIMER_A = "congControl_TIMER_A";
    private static final String CONG_CONTROL_TIMER_D = "congControl_TIMER_D";
    private static final String CONG_CONTROL_ALGO = "congControl_Algo";
    private static final String CONG_CONTROL_BLOCKING_OUTGOUNG_SCCP_MESSAGES = "congControl_blockingOutgoungSccpMessages";
    private static final String TIMER_EXECUTORS_THREAD_COUNT = "timerexecutors_threadcount";
    private static final int STATUS_MSG_LOGGING_INTERVAL_MILLISEC_CONG = 10000;
    private static final int STATUS_MSG_LOGGING_INTERVAL_MILLISEC_UNAVAIL = 100;
    protected static final XMLBinding binding = new XMLBinding();
    protected int zMarginXudtMessage = 240;
    protected int connEstTimerDelay = 15000;
    protected int iasTimerDelay = 450000;
    protected int iarTimerDelay = 960000;
    protected int relTimerDelay = 15000;
    protected int repeatRelTimerDelay = 15000;
    protected int intTimerDelay = 30000;
    protected int guardTimerDelay = 1440000;
    protected int resetTimerDelay = 15000;
    protected int reassemblyTimerDelay = 15000;
    protected int maxDataMessage = 2560;
    private int periodOfLogging = 60000;
    private boolean removeSpc = true;
    private boolean canRelay = false;
    protected int sstTimerDuration_Min = 10000;
    protected int sstTimerDuration_Max = 600000;
    protected double sstTimerDuration_IncreaseFactor = 1.5;
    private SccpProtocolVersion sccpProtocolVersion = SccpProtocolVersion.ITU;
    protected int congControl_N = 8;
    protected int congControl_M = 4;
    protected int congControl_TIMER_A = 400;
    protected int congControl_TIMER_D = 2000;
    protected SccpCongestionControlAlgo congControl_Algo = SccpCongestionControlAlgo.international;
    protected boolean congControl_blockingOutgoungSccpMessages = false;
    protected int deliveryTransferMessageThreadCount = 4;
    protected int timerExecutorsThreadCount = 10;
    private boolean previewMode = false;
    protected volatile State state = State.IDLE;
    protected SccpProviderImpl sccpProvider;
    protected RouterImpl router;
    protected SccpResourceImpl sccpResource;
    protected MessageFactoryImpl messageFactory;
    protected SccpManagement sccpManagement;
    protected SccpRoutingControl sccpRoutingControl;
    protected SccpCongestionControl sccpCongestionControl;
    protected FastMap<Integer, SccpConnectionImpl> connections = new FastMap().shared();
    protected int referenceNumberCounterMax = 0xFFFFFF;
    protected FastMap<Integer, Mtp3UserPart> mtp3UserParts = new FastMap();
    protected ScheduledExecutorService timerExecutors;
    protected FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> reassemplyCache = new FastMap();
    protected ExecutorService[] msgDeliveryExecutors;
    protected int slsFilter = 15;
    protected int[] slsTable = null;
    protected final String name;
    protected final TextBuilder persistFile = TextBuilder.newInstance();
    protected String persistDir = null;
    protected boolean rspProhibitedByDefault;
    private volatile int segmentationLocalRef = 0;
    private volatile int slsCounter = 0;
    private volatile int selectorCounter = 0;
    protected volatile int referenceNumberCounter = 0;
    private FastMap<Integer, Date> lastCongNotice = new FastMap();
    private FastMap<Integer, Date> lastUserPartUnavailNotice = new FastMap();
    protected Scheduler scheduler;

    public SccpStackImpl(String name) {
        this(null, name);
    }

    public SccpStackImpl(Scheduler scheduler, String name) {
        this.scheduler = scheduler;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        this.name = name;
        this.logger = Logger.getLogger(SccpStackImpl.class.getCanonicalName() + "-" + this.name);
        this.messageFactory = new MessageFactoryImpl(this);
        this.sccpProvider = new SccpProviderImpl(this);
        this.state = State.CONFIGURED;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void setRspProhibitedByDefault(boolean rspProhibitedByDefault) {
        this.rspProhibitedByDefault = rspProhibitedByDefault;
    }

    public boolean isRspProhibitedByDefault() {
        return this.rspProhibitedByDefault;
    }

    @Override
    public SccpProvider getSccpProvider() {
        return this.sccpProvider;
    }

    @Override
    public Map<Integer, Mtp3UserPart> getMtp3UserParts() {
        return this.mtp3UserParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMtp3UserParts(Map<Integer, Mtp3UserPart> mtp3UserPartsTemp) {
        if (mtp3UserPartsTemp != null) {
            SccpStackImpl sccpStackImpl = this;
            synchronized (sccpStackImpl) {
                FastMap<Integer, Mtp3UserPart> newMtp3UserPart = new FastMap<Integer, Mtp3UserPart>();
                newMtp3UserPart.putAll(mtp3UserPartsTemp);
                this.mtp3UserParts = newMtp3UserPart;
            }
        }
    }

    @Override
    public Mtp3UserPart getMtp3UserPart(int id) {
        return this.mtp3UserParts.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMtp3UserPart(int id, Mtp3UserPart mtp3UserPart) {
        if (mtp3UserPart == null) {
            this.removeMtp3UserPart(id);
        } else {
            SccpStackImpl sccpStackImpl = this;
            synchronized (sccpStackImpl) {
                FastMap<Integer, Mtp3UserPart> newMtp3UserPart = new FastMap<Integer, Mtp3UserPart>();
                newMtp3UserPart.putAll(this.mtp3UserParts);
                newMtp3UserPart.put(id, mtp3UserPart);
                this.mtp3UserParts = newMtp3UserPart;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMtp3UserPart(int id) {
        SccpStackImpl sccpStackImpl = this;
        synchronized (sccpStackImpl) {
            FastMap<Integer, Mtp3UserPart> newMtp3UserPart = new FastMap<Integer, Mtp3UserPart>();
            newMtp3UserPart.putAll(this.mtp3UserParts);
            newMtp3UserPart.remove(id);
            this.mtp3UserParts = newMtp3UserPart;
        }
    }

    @Override
    public void setRemoveSpc(boolean removeSpc) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("RemoveSpc parameter can be updated only when SCCP stack is running");
        }
        this.removeSpc = removeSpc;
        this.store();
    }

    @Override
    public void setCanRelay(boolean canRelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("CanRelay parameter can be updated only when SCCP stack is running");
        }
        this.canRelay = canRelay;
        this.store();
    }

    @Override
    public void setSccpProtocolVersion(SccpProtocolVersion sccpProtocolVersion) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("SccpProtocolVersion parameter can be updated only when SCCP stack is running");
        }
        if (sccpProtocolVersion != null) {
            this.sccpProtocolVersion = sccpProtocolVersion;
        }
        this.store();
    }

    @Override
    public void setPreviewMode(boolean previewMode) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("PreviewMode parameter can be updated only when SCCP stack is running");
        }
        this.previewMode = previewMode;
        this.store();
    }

    public int getDeliveryMessageThreadCount() {
        return this.deliveryTransferMessageThreadCount;
    }

    public void setDeliveryMessageThreadCount(int deliveryMessageThreadCount) throws Exception {
        if (this.isStarted()) {
            throw new Exception("DeliveryMessageThreadCount parameter can be updated only when SCCP stack is NOT running");
        }
        if (deliveryMessageThreadCount > 0 && deliveryMessageThreadCount <= 100) {
            this.deliveryTransferMessageThreadCount = deliveryMessageThreadCount;
        }
    }

    public int getTimerExecutorsThreadCount() {
        return this.timerExecutorsThreadCount;
    }

    public void setTimerExecutorsThreadCount(int timerExecutorsThreadCount) throws Exception {
        if (this.isStarted()) {
            throw new Exception("ConnectionTimersThreadCount parameter can be updated only when SCCP stack is NOT running");
        }
        if (timerExecutorsThreadCount < 1) {
            timerExecutorsThreadCount = 1;
        }
        if (timerExecutorsThreadCount > 1000) {
            timerExecutorsThreadCount = 1000;
        }
        this.timerExecutorsThreadCount = timerExecutorsThreadCount;
    }

    @Override
    public void setSstTimerDuration_Min(int sstTimerDuration_Min) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("SstTimerDuration_Min parameter can be updated only when SCCP stack is running");
        }
        if (sstTimerDuration_Min < 5000) {
            sstTimerDuration_Min = 5000;
        }
        if (sstTimerDuration_Min > 10000) {
            sstTimerDuration_Min = 10000;
        }
        this.sstTimerDuration_Min = sstTimerDuration_Min;
        this.store();
    }

    @Override
    public void setSstTimerDuration_Max(int sstTimerDuration_Max) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("SstTimerDuration_Max parameter can be updated only when SCCP stack is running");
        }
        if (sstTimerDuration_Max < 600000) {
            sstTimerDuration_Max = 600000;
        }
        if (sstTimerDuration_Max > 1200000) {
            sstTimerDuration_Max = 1200000;
        }
        this.sstTimerDuration_Max = sstTimerDuration_Max;
        this.store();
    }

    @Override
    public void setSstTimerDuration_IncreaseFactor(double sstTimerDuration_IncreaseFactor) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("SstTimerDuration_IncreaseFactor parameter can be updated only when SCCP stack is running");
        }
        if (sstTimerDuration_IncreaseFactor < 1.0) {
            sstTimerDuration_IncreaseFactor = 1.0;
        }
        if (sstTimerDuration_IncreaseFactor > 4.0) {
            sstTimerDuration_IncreaseFactor = 4.0;
        }
        this.sstTimerDuration_IncreaseFactor = sstTimerDuration_IncreaseFactor;
        this.store();
    }

    @Override
    public int getCongControlTIMER_A() {
        return this.congControl_TIMER_A;
    }

    @Override
    public void setCongControlTIMER_A(int value) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("CongControlTIMER_A parameter can be updated only when SCCP stack is running");
        }
        if (value < 60) {
            value = 60;
        }
        if (value > 1000) {
            value = 1000;
        }
        this.congControl_TIMER_A = value;
        this.store();
    }

    @Override
    public int getCongControlTIMER_D() {
        return this.congControl_TIMER_D;
    }

    @Override
    public void setCongControlTIMER_D(int value) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("CongControlTIMER_D parameter can be updated only when SCCP stack is running");
        }
        if (value < 500) {
            value = 500;
        }
        if (value > 10000) {
            value = 10000;
        }
        this.congControl_TIMER_D = value;
        this.store();
    }

    public int getCongControlN() {
        return this.congControl_N;
    }

    public void setCongControlN(int value) {
        this.congControl_N = value;
        this.store();
    }

    public int getCongControlM() {
        return this.congControl_M;
    }

    public void setCongControlM(int value) {
        this.congControl_M = value;
        this.store();
    }

    @Override
    public SccpCongestionControlAlgo getCongControl_Algo() {
        return this.congControl_Algo;
    }

    @Override
    public void setCongControl_Algo(SccpCongestionControlAlgo value) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("CongControl_Algo parameter can be updated only when SCCP stack is running");
        }
        if (value != null) {
            this.congControl_Algo = value;
        }
        this.store();
    }

    @Override
    public boolean isCongControl_blockingOutgoungSccpMessages() {
        return this.congControl_blockingOutgoungSccpMessages;
    }

    @Override
    public void setCongControl_blockingOutgoungSccpMessages(boolean value) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("CongControl_blockingOutgoungSccpMessages parameter can be updated only when SCCP stack is running");
        }
        this.congControl_blockingOutgoungSccpMessages = value;
        this.store();
    }

    @Override
    public boolean isRemoveSpc() {
        return this.removeSpc;
    }

    @Override
    public boolean isCanRelay() {
        return this.canRelay;
    }

    @Override
    public SccpProtocolVersion getSccpProtocolVersion() {
        return this.sccpProtocolVersion;
    }

    @Override
    public boolean isPreviewMode() {
        return this.previewMode;
    }

    @Override
    public int getSstTimerDuration_Min() {
        return this.sstTimerDuration_Min;
    }

    @Override
    public int getSstTimerDuration_Max() {
        return this.sstTimerDuration_Max;
    }

    @Override
    public double getSstTimerDuration_IncreaseFactor() {
        return this.sstTimerDuration_IncreaseFactor;
    }

    @Override
    public int getZMarginXudtMessage() {
        return this.zMarginXudtMessage;
    }

    @Override
    public void setZMarginXudtMessage(int zMarginXudtMessage) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("ZMarginXudtMessage parameter can be updated only when SCCP stack is running");
        }
        if (zMarginXudtMessage < 160) {
            zMarginXudtMessage = 160;
        }
        if (zMarginXudtMessage > 255) {
            zMarginXudtMessage = 255;
        }
        this.zMarginXudtMessage = zMarginXudtMessage;
        this.store();
    }

    @Override
    public int getMaxDataMessage() {
        return this.maxDataMessage;
    }

    @Override
    public void setMaxDataMessage(int maxDataMessage) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("MaxDataMessage parameter can be updated only when SCCP stack is running");
        }
        if (maxDataMessage < 2560) {
            maxDataMessage = 2560;
        }
        if (maxDataMessage > 3952) {
            maxDataMessage = 3952;
        }
        this.maxDataMessage = maxDataMessage;
        this.store();
    }

    @Override
    public int getConnEstTimerDelay() {
        return this.connEstTimerDelay;
    }

    @Override
    public void setConnEstTimerDelay(int connEstTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("ConnEstTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (connEstTimerDelay < 60000) {
            connEstTimerDelay = 60000;
        }
        if (connEstTimerDelay > 120000) {
            connEstTimerDelay = 120000;
        }
        this.connEstTimerDelay = connEstTimerDelay;
        this.store();
    }

    @Override
    public int getIasTimerDelay() {
        return this.iasTimerDelay;
    }

    @Override
    public void setIasTimerDelay(int iasTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("IasTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (iasTimerDelay < 300000) {
            iasTimerDelay = 300000;
        }
        if (iasTimerDelay > 600000) {
            iasTimerDelay = 600000;
        }
        this.iasTimerDelay = iasTimerDelay;
        this.store();
    }

    @Override
    public int getIarTimerDelay() {
        return this.iarTimerDelay;
    }

    @Override
    public void setIarTimerDelay(int iarTimerDelay) throws Exception {
        this.iarTimerDelay = iarTimerDelay;
        if (!this.isStarted()) {
            throw new Exception("IarTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (iarTimerDelay < 660000) {
            iarTimerDelay = 660000;
        }
        if (iarTimerDelay > 1260000) {
            iarTimerDelay = 1260000;
        }
        this.iarTimerDelay = iarTimerDelay;
        this.store();
    }

    @Override
    public int getRelTimerDelay() {
        return this.relTimerDelay;
    }

    @Override
    public void setRelTimerDelay(int relTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("RelTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (relTimerDelay < 10000) {
            relTimerDelay = 10000;
        }
        if (relTimerDelay > 20000) {
            relTimerDelay = 20000;
        }
        this.relTimerDelay = relTimerDelay;
        this.store();
    }

    @Override
    public int getRepeatRelTimerDelay() {
        return this.repeatRelTimerDelay;
    }

    @Override
    public void setRepeatRelTimerDelay(int repeatRelTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("RepeatRelTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (repeatRelTimerDelay < 10000) {
            repeatRelTimerDelay = 10000;
        }
        if (repeatRelTimerDelay > 20000) {
            repeatRelTimerDelay = 20000;
        }
        this.repeatRelTimerDelay = repeatRelTimerDelay;
        this.store();
    }

    @Override
    public int getIntTimerDelay() {
        return this.intTimerDelay;
    }

    @Override
    public void setIntTimerDelay(int intTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("IntTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (intTimerDelay < 0) {
            intTimerDelay = 0;
        }
        if (intTimerDelay > 60000) {
            intTimerDelay = 60000;
        }
        this.intTimerDelay = intTimerDelay;
        this.store();
    }

    @Override
    public int getGuardTimerDelay() {
        return this.guardTimerDelay;
    }

    @Override
    public void setGuardTimerDelay(int guardTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("GuardTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (guardTimerDelay < 1380000) {
            guardTimerDelay = 1380000;
        }
        if (guardTimerDelay > 1500000) {
            guardTimerDelay = 1500000;
        }
        this.guardTimerDelay = guardTimerDelay;
        this.store();
    }

    @Override
    public int getResetTimerDelay() {
        return this.resetTimerDelay;
    }

    @Override
    public void setResetTimerDelay(int resetTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("ResetTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (resetTimerDelay < 10000) {
            resetTimerDelay = 10000;
        }
        if (resetTimerDelay > 20000) {
            resetTimerDelay = 20000;
        }
        this.resetTimerDelay = resetTimerDelay;
        this.store();
    }

    @Override
    public int getPeriodOfLogging() {
        return this.periodOfLogging;
    }

    @Override
    public void setPeriodOfLogging(int periodOfLogging) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("periodOfLogging parameter can be updated only when SCCP stack is running");
        }
        this.periodOfLogging = periodOfLogging;
        this.store();
    }

    @Override
    public int getReassemblyTimerDelay() {
        return this.reassemblyTimerDelay;
    }

    @Override
    public void setReassemblyTimerDelay(int reassemblyTimerDelay) throws Exception {
        if (!this.isStarted()) {
            throw new Exception("ReassemblyTimerDelay parameter can be updated only when SCCP stack is running");
        }
        if (reassemblyTimerDelay < 10000) {
            reassemblyTimerDelay = 10000;
        }
        if (reassemblyTimerDelay > 20000) {
            reassemblyTimerDelay = 20000;
        }
        this.reassemblyTimerDelay = reassemblyTimerDelay;
        this.store();
    }

    public synchronized int newSegmentationLocalRef() {
        return ++this.segmentationLocalRef;
    }

    public synchronized int newSls() {
        if (++this.slsCounter > 255) {
            this.slsCounter = 0;
        }
        return this.slsCounter;
    }

    public synchronized boolean newSelector() {
        if (++this.selectorCounter > 1) {
            this.selectorCounter = 0;
        }
        return this.selectorCounter == 1;
    }

    protected void createSLSTable(int maxSls, int minimumBoundThread) {
        int stream = 0;
        for (int i = 0; i < maxSls; ++i) {
            if (stream >= minimumBoundThread) {
                stream = 0;
            }
            this.slsTable[i] = stream++;
        }
    }

    @Override
    public void start() throws IllegalStateException {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SCCP_MANAGEMENT_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        try {
            this.load();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.sccpManagement = new SccpManagement(this.name, this.sccpProvider, this);
        this.sccpRoutingControl = new SccpRoutingControl(this.sccpProvider, this);
        this.sccpCongestionControl = new SccpCongestionControl(this.sccpManagement, this);
        this.sccpManagement.setSccpRoutingControl(this.sccpRoutingControl);
        this.sccpRoutingControl.setSccpManagement(this.sccpManagement);
        this.sccpManagement.setSccpCongestionControl(this.sccpCongestionControl);
        this.router = new RouterImpl(this.name, this);
        this.router.setPersistDir(this.persistDir);
        this.router.start();
        this.sccpResource = new SccpResourceImpl(this.name, this.rspProhibitedByDefault);
        this.sccpResource.setPersistDir(this.persistDir);
        this.sccpResource.start();
        this.sccpRoutingControl.start();
        this.sccpManagement.start();
        this.timerExecutors = Executors.newScheduledThreadPool(this.timerExecutorsThreadCount);
        int maxSls = 16;
        this.slsFilter = 15;
        this.slsTable = new int[maxSls];
        this.createSLSTable(maxSls, this.deliveryTransferMessageThreadCount);
        this.msgDeliveryExecutors = new ExecutorService[this.deliveryTransferMessageThreadCount];
        for (int i = 0; i < this.deliveryTransferMessageThreadCount; ++i) {
            this.msgDeliveryExecutors[i] = Executors.newFixedThreadPool(1, new DefaultThreadFactory("SccpTransit-DeliveryExecutor-" + i));
        }
        FastCollection.Record e = this.mtp3UserParts.head();
        FastMap.Entry<Integer, Mtp3UserPart> end = this.mtp3UserParts.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3UserPart mup = (Mtp3UserPart)((FastMap.Entry)e).getValue();
            mup.addMtp3UserPartListener(this);
        }
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onServiceStarted();
            }
            catch (Throwable ee) {
                System.out.println("Exception while invoking onServiceStarted" + ee.getMessage());
            }
        }
        this.state = State.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        System.out.println("Stopping ...");
        this.state = State.IDLE;
        if (this.msgDeliveryExecutors != null) {
            for (ExecutorService es : this.msgDeliveryExecutors) {
                es.shutdown();
            }
            this.msgDeliveryExecutors = null;
        }
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onServiceStopped();
            }
            catch (Throwable ee) {
                System.out.println("Exception while invoking onServiceStarted" + ee.getMessage());
            }
        }
        FastCollection.Record e = this.mtp3UserParts.head();
        FastMap.Entry<Integer, Mtp3UserPart> end = this.mtp3UserParts.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3UserPart mup = (Mtp3UserPart)((FastMap.Entry)e).getValue();
            mup.removeMtp3UserPartListener(this);
        }
        this.sccpManagement.stop();
        this.sccpRoutingControl.stop();
        this.sccpResource.stop();
        this.router.stop();
        FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = this.reassemplyCache;
        synchronized (fastMap) {
            this.timerExecutors.shutdownNow();
            this.reassemplyCache.clear();
        }
        this.store();
    }

    @Override
    public boolean isStarted() {
        return this.state == State.RUNNING;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public SccpResource getSccpResource() {
        return this.sccpResource;
    }

    public SccpConnectionImpl getConnection(LocalReference number) {
        if (number == null) {
            System.out.println("Error: Reference number can't be null ...");
            throw new IllegalArgumentException("Reference number can't be null");
        }
        return this.connections.get(number.getValue());
    }

    public int getConnectionsNumber() {
        return this.connections.size();
    }

    protected SccpConnectionImpl newConnection(int localSsn, ProtocolClass protocol) throws MaxConnectionCountReached {
        SccpConnectionImpl conn;
        Integer refNumber = this.newReferenceNumber();
        if (protocol.getProtocolClass() == 2) {
            conn = new SccpConnectionImpl(localSsn, new LocalReferenceImpl(refNumber), protocol, this, this.sccpRoutingControl);
        } else if (protocol.getProtocolClass() == 3) {
            conn = new SccpConnectionWithFlowControlImpl(localSsn, new LocalReferenceImpl(refNumber), protocol, this, this.sccpRoutingControl);
        } else {
            System.err.printf("UnSupported connection class %d", protocol.getProtocolClass());
            throw new IllegalArgumentException();
        }
        this.connections.put(refNumber, conn);
        return conn;
    }

    protected void removeConnection(LocalReference ref) {
        SccpConnectionImpl conn = this.connections.get(ref.getValue());
        if (conn != null) {
            this.connections.remove(ref.getValue());
            conn.stopTimers();
            conn.setState(SccpConnectionState.CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int newReferenceNumber() throws MaxConnectionCountReached {
        SccpStackImpl sccpStackImpl = this;
        synchronized (sccpStackImpl) {
            if (this.referenceNumberCounter++ > this.referenceNumberCounterMax) {
                this.referenceNumberCounter = 0;
            }
            if (this.connections.size() >= this.referenceNumberCounterMax + 1) {
                this.logger.error(String.format("Can't open more connections than %d", this.referenceNumberCounterMax + 1));
                throw new MaxConnectionCountReached(String.format("Can't open more connections than %d", this.referenceNumberCounterMax + 1));
            }
            while (this.connections.keySet().contains(this.referenceNumberCounter)) {
                ++this.referenceNumberCounter;
            }
            return this.referenceNumberCounter;
        }
    }

    protected void send(SccpDataNoticeTemplateMessageImpl message) throws Exception {
        if (this.state != State.RUNNING) {
            this.logger.error("Trying to send SCCP message from SCCP user but SCCP stack is not RUNNING");
            return;
        }
        if (message.getCalledPartyAddress() == null || message.getCallingPartyAddress() == null || message.getData() == null || message.getData().length == 0) {
            this.logger.error("Message to send must has filled CalledPartyAddress, CallingPartyAddress and data fields");
            throw new IOException("Message to send must has filled CalledPartyAddress, CallingPartyAddress and data fields");
        }
        try {
            this.sccpRoutingControl.routeMssgFromSccpUser(message);
        }
        catch (Exception e) {
            this.logger.error("IOException when sending the message to MTP3 level: " + e.getMessage(), e);
            throw e;
        }
    }

    protected int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        GlobalTitle gt = calledPartyAddress.getGlobalTitle();
        int dpc = calledPartyAddress.getSignalingPointCode();
        int ssn = calledPartyAddress.getSubsystemNumber();
        if (calledPartyAddress.getAddressIndicator().isPCPresent()) {
            if (this.router.spcIsLocal(dpc)) {
                if (ssn > 0) {
                    return this.getMaxDataMessage();
                }
                if (gt != null) {
                    return this.getMaxUserDataLengthForGT(calledPartyAddress, callingPartyAddress, msgNetworkId);
                }
                return 0;
            }
            return this.getMaxUserDataLengthForDpc(dpc, calledPartyAddress, callingPartyAddress);
        }
        if (gt != null) {
            return this.getMaxUserDataLengthForGT(calledPartyAddress, callingPartyAddress, msgNetworkId);
        }
        return 0;
    }

    private int getMaxUserDataLengthForDpc(int dpc, SccpAddress calledPartyAddress, SccpAddress callingPartyAddress) {
        Mtp3ServiceAccessPoint sap;
        LongMessageRule lmr = this.router.findLongMessageRule(dpc);
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        if (lmr != null) {
            lmrt = lmr.getLongMessageRuleType();
        }
        if ((sap = this.router.findMtp3ServiceAccessPoint(dpc, 0)) == null) {
            return 0;
        }
        Mtp3UserPart mup = this.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            return 0;
        }
        try {
            int fieldsLen = 0;
            byte[] cdp = ((SccpAddressImpl)calledPartyAddress).encode(this.isRemoveSpc(), this.getSccpProtocolVersion());
            byte[] cnp = ((SccpAddressImpl)callingPartyAddress).encode(this.isRemoveSpc(), this.getSccpProtocolVersion());
            switch (lmrt) {
                case LONG_MESSAGE_FORBBIDEN: {
                    fieldsLen = MessageUtil.calculateUdtFieldsLengthWithoutData(cdp.length, cnp.length);
                    break;
                }
                case LUDT_ENABLED: 
                case LUDT_ENABLED_WITH_SEGMENTATION: {
                    fieldsLen = MessageUtil.calculateLudtFieldsLengthWithoutData(cdp.length, cnp.length, true, true);
                    break;
                }
                case XUDT_ENABLED: {
                    fieldsLen = MessageUtil.calculateXudtFieldsLengthWithoutData(cdp.length, cnp.length, true, true);
                    int fieldsLen2 = MessageUtil.calculateXudtFieldsLengthWithoutData2(cdp.length, cnp.length);
                    if (fieldsLen <= fieldsLen2) break;
                    fieldsLen = fieldsLen2;
                }
            }
            int availLen = mup.getMaxUserDataLength(dpc) - fieldsLen;
            if ((lmrt == LongMessageRuleType.LONG_MESSAGE_FORBBIDEN || lmrt == LongMessageRuleType.XUDT_ENABLED) && availLen > 255) {
                availLen = 255;
            }
            if (lmrt == LongMessageRuleType.XUDT_ENABLED) {
                availLen *= 16;
            }
            if (availLen > this.getMaxDataMessage()) {
                availLen = this.getMaxDataMessage();
            }
            return availLen;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int getMaxUserDataLengthForGT(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        Rule rule = this.router.findRule(calledPartyAddress, callingPartyAddress, false, msgNetworkId);
        if (rule == null) {
            return 0;
        }
        SccpAddress translationAddressPri = this.router.getRoutingAddress(rule.getPrimaryAddressId());
        if (translationAddressPri == null) {
            return 0;
        }
        return this.getMaxUserDataLengthForDpc(translationAddressPri.getSignalingPointCode(), calledPartyAddress, callingPartyAddress);
    }

    protected void broadcastChangedSsnState(int affectedSsn, boolean inService) {
        this.sccpManagement.broadcastChangedSsnState(affectedSsn, inService);
    }

    public void removeAllResourses() {
        if (this.state != State.RUNNING) {
            return;
        }
        this.router.removeAllResourses();
        this.sccpResource.removeAllResourses();
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onRemoveAllResources();
            }
            catch (Throwable ee) {
                this.logger.error("Exception while invoking onRemoveAllResources", ee);
            }
        }
    }

    @Override
    public void onMtp3PauseMessage(Mtp3PausePrimitive msg) {
        if (this.state != State.RUNNING) {
            this.logger.error("Cannot consume MTP3 PASUE message as SCCP stack is not RUNNING");
            return;
        }
        this.sccpManagement.handleMtp3Pause(msg.getAffectedDpc());
    }

    @Override
    public void onMtp3ResumeMessage(Mtp3ResumePrimitive msg) {
        if (this.state != State.RUNNING) {
            this.logger.error("Cannot consume MTP3 RESUME message as SCCP stack is not RUNNING");
            return;
        }
        this.sccpManagement.handleMtp3Resume(msg.getAffectedDpc());
    }

    @Override
    public void onMtp3StatusMessage(Mtp3StatusPrimitive msg) {
        int affectedDpc = msg.getAffectedDpc();
        if (msg.getCause() == Mtp3StatusCause.SignallingNetworkCongested) {
            Date lastNotice = this.lastCongNotice.get(affectedDpc);
            if (lastNotice == null) {
                this.lastCongNotice.put(affectedDpc, new Date());
                this.logger.warn(String.format("Rx : %s  (one message in %d seconds)", msg, 100));
            } else if (System.currentTimeMillis() - lastNotice.getTime() > 10000L) {
                lastNotice.setTime(System.currentTimeMillis());
                this.logger.warn(String.format("Rx : %s (one message in %d seconds)", msg, 100));
            }
        } else {
            Date lastNotice = this.lastUserPartUnavailNotice.get(affectedDpc);
            if (lastNotice == null) {
                this.lastUserPartUnavailNotice.put(affectedDpc, new Date());
                this.logger.warn(String.format("Rx : %s (one message in %d seconds)", msg, 100));
            } else if (System.currentTimeMillis() - lastNotice.getTime() > 100L) {
                lastNotice.setTime(System.currentTimeMillis());
                this.logger.warn(String.format("Rx : %s (one message in %d seconds)", msg, 100));
            }
        }
        if (this.state != State.RUNNING) {
            this.logger.error("Cannot consume MTP3 STATUS message as SCCP stack is not RUNNING");
            return;
        }
        this.sccpManagement.handleMtp3Status(msg.getCause(), affectedDpc, msg.getCongestionLevel());
    }

    @Override
    public void onMtp3EndCongestionMessage(Mtp3EndCongestionPrimitive msg) {
        int affectedDpc = msg.getAffectedDpc();
        this.logger.warn(String.format("Rx : %s", msg));
        this.sccpManagement.handleMtp3EndCongestion(affectedDpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMtp3TransferMessage(Mtp3TransferPrimitive mtp3Msg) {
        if (this.state != State.RUNNING) {
            this.logger.error("Received MTP3TransferPrimitive from lower layer but SCCP stack is not RUNNING");
            return;
        }
        SccpMessageImpl msg = null;
        int dpc = mtp3Msg.getDpc();
        int opc = mtp3Msg.getOpc();
        try {
            SccpSegmentableMessageImpl sgmMsg;
            SegmentationImpl segm;
            GlobalTitle gt;
            SccpAddressedMessageImpl msgAddr;
            SccpAddress addr;
            if (!this.isPreviewMode() && !this.router.spcIsLocal(dpc)) {
                int sls = mtp3Msg.getSls();
                RemoteSignalingPointCode remoteSpc = this.getSccpResource().getRemoteSpcByPC(dpc);
                Mtp3ServiceAccessPoint sap = this.router.findMtp3ServiceAccessPoint(opc, sls);
                if (remoteSpc == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d. But RemoteSpc is not found", dpc));
                    }
                    return;
                }
                if (remoteSpc.isRemoteSpcProhibited()) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d. But RemoteSpc is Prohibited", dpc));
                    }
                    return;
                }
                if (remoteSpc.getCurrentRestrictionLevel() > 1) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d. But RemoteSpc is Congested", dpc));
                    }
                    return;
                }
                Mtp3ServiceAccessPoint sap2 = this.router.findMtp3ServiceAccessPoint(dpc, sls);
                if (sap2 == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d / sls=%d. But SAP is not found", dpc, sls));
                    }
                    return;
                }
                Mtp3UserPart mup = this.getMtp3UserPart(sap2.getMtp3Id());
                if (mup == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Incoming Mtp3 Message for nonlocal dpc=%d / sls=%d. no matching Mtp3UserPart found", dpc, sls));
                    }
                    return;
                }
                mup.sendMessage(mtp3Msg);
                return;
            }
            if (mtp3Msg.getSi() != 3) {
                this.logger.warn(String.format("Received Mtp3TransferPrimitive from lower layer with Service Indicator=%d which is not SCCP. Dropping this message", mtp3Msg.getSi()));
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(mtp3Msg.getData());
            DataInputStream in = new DataInputStream(bais);
            int mt = in.readUnsignedByte();
            msg = ((MessageFactoryImpl)this.sccpProvider.getMessageFactory()).createMessage(mt, mtp3Msg.getOpc(), mtp3Msg.getDpc(), mtp3Msg.getSls(), in, this.sccpProtocolVersion, 0);
            dpc = mtp3Msg.getDpc();
            opc = mtp3Msg.getOpc();
            String localGtDigits = null;
            if (msg instanceof SccpAddressedMessageImpl && (addr = (msgAddr = (SccpAddressedMessageImpl)msg).getCalledPartyAddress()) != null && (gt = addr.getGlobalTitle()) != null) {
                localGtDigits = gt.getDigits();
            }
            Mtp3ServiceAccessPoint sap = this.router.findMtp3ServiceAccessPointForIncMes(dpc, opc, localGtDigits);
            int networkId = 0;
            if (sap == null) {
                if (this.logger.isEnabledFor(Level.WARN)) {
                    this.logger.warn(String.format("Incoming Mtp3 Message for local address for localPC=%d, remotePC=%d, sls=%d. But SAP is not found for localPC", dpc, opc, mtp3Msg.getSls()));
                }
            } else {
                networkId = sap.getNetworkId();
            }
            msg.setNetworkId(networkId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Rx : SCCP message from MTP %s", msg));
            }
            if (msg instanceof SccpSegmentableMessageImpl && (segm = (SegmentationImpl)(sgmMsg = (SccpSegmentableMessageImpl)msg).getSegmentation()) != null) {
                if (segm.isFirstSegIndication() && segm.getRemainingSegments() == 0) {
                    sgmMsg.setReceivedSingleSegment();
                } else {
                    if (segm.isFirstSegIndication()) {
                        sgmMsg.setReceivedFirstSegment();
                        MessageReassemblyProcess msp = new MessageReassemblyProcess(segm.getSegmentationLocalRef(), sgmMsg.getCallingPartyAddress());
                        FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = this.reassemplyCache;
                        synchronized (fastMap) {
                            this.reassemplyCache.put(msp, sgmMsg);
                        }
                        sgmMsg.setMessageReassemblyProcess(msp);
                        msp.startTimer();
                        return;
                    }
                    MessageReassemblyProcess msp = new MessageReassemblyProcess(segm.getSegmentationLocalRef(), sgmMsg.getCallingPartyAddress());
                    SccpSegmentableMessageImpl sgmMsgFst = null;
                    FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = this.reassemplyCache;
                    synchronized (fastMap) {
                        sgmMsgFst = this.reassemplyCache.get(msp);
                    }
                    if (sgmMsgFst == null) {
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Reassembly function failure: received a non first segment without the first segement having recieved. SccpMessageSegment=%s", msg));
                        }
                        return;
                    }
                    if (sgmMsgFst.getRemainingSegments() - 1 != segm.getRemainingSegments()) {
                        fastMap = this.reassemplyCache;
                        synchronized (fastMap) {
                            this.reassemplyCache.remove(msp);
                            MessageReassemblyProcess mspMain = sgmMsgFst.getMessageReassemblyProcess();
                            if (mspMain != null) {
                                mspMain.stopTimer();
                            }
                        }
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Reassembly function failure: when receiving a next segment message order is missing. SccpMessageSegment=%s", msg));
                        }
                        this.sccpRoutingControl.sendSccpError(sgmMsgFst, ReturnCauseValue.CANNOT_REASEMBLE, null);
                        return;
                    }
                    if (sgmMsgFst.getRemainingSegments() == 1) {
                        fastMap = this.reassemplyCache;
                        synchronized (fastMap) {
                            MessageReassemblyProcess mspMain = sgmMsgFst.getMessageReassemblyProcess();
                            if (mspMain != null) {
                                mspMain.stopTimer();
                            }
                            this.reassemplyCache.remove(msp);
                        }
                        if (sgmMsgFst.getRemainingSegments() != 1) {
                            return;
                        }
                        sgmMsgFst.setReceivedNextSegment(sgmMsg);
                        msg = sgmMsgFst;
                    } else {
                        sgmMsgFst.setReceivedNextSegment(sgmMsg);
                        return;
                    }
                }
            }
            if (msg instanceof SccpAddressedMessageImpl) {
                SccpAddressedMessageImpl msgAddr2 = (SccpAddressedMessageImpl)msg;
                SccpAddress addr2 = msgAddr2.getCallingPartyAddress();
                if (addr2 != null && addr2.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN && !addr2.getAddressIndicator().isPCPresent()) {
                    msgAddr2.setCallingPartyAddress(new SccpAddressImpl(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, null, msgAddr2.getIncomingOpc(), addr2.getSubsystemNumber()));
                }
                this.sccpRoutingControl.routeMssgFromMtp(msgAddr2);
            } else if (msg instanceof SccpConnMessage) {
                this.sccpRoutingControl.routeMssgFromMtpConn((SccpConnMessage)((Object)msg));
            } else {
                this.logger.warn(String.format("Rx SCCP message which is not instance of SccpAddressedMessage or SccpSegmentableMessage and doesn't implement SccpConnMessage. Will be dropped. Message=", msg));
            }
        }
        catch (Exception e) {
            this.logger.error("IOException while handling SCCP message: " + e.getMessage(), e);
        }
    }

    public FastMap<Integer, NetworkIdState> getNetworkIdList(int affectedPc) {
        return this.router.getNetworkIdList(affectedPc);
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.zMarginXudtMessage, Z_MARGIN_UDT_MSG, Integer.class);
            writer.write(this.connEstTimerDelay, CONN_EST_TIMER_DELAY, Integer.class);
            writer.write(this.iasTimerDelay, IAS_TIMER_DELAY, Integer.class);
            writer.write(this.iarTimerDelay, IAR_TIMER_DELAY, Integer.class);
            writer.write(this.relTimerDelay, REL_TIMER_DELAY, Integer.class);
            writer.write(this.repeatRelTimerDelay, REPEAT_REL_TIMER_DELAY, Integer.class);
            writer.write(this.intTimerDelay, INT_TIMER_DELAY, Integer.class);
            writer.write(this.guardTimerDelay, GUARD_TIMER_DELAY, Integer.class);
            writer.write(this.resetTimerDelay, RESET_TIMER_DELAY, Integer.class);
            writer.write(this.reassemblyTimerDelay, REASSEMBLY_TIMER_DELAY, Integer.class);
            writer.write(this.maxDataMessage, MAX_DATA_MSG, Integer.class);
            writer.write(this.periodOfLogging, PERIOD_OF_LOG, Integer.class);
            writer.write(this.removeSpc, REMOVE_SPC, Boolean.class);
            writer.write(this.canRelay, CAN_RELAY, Boolean.class);
            writer.write(this.timerExecutorsThreadCount, TIMER_EXECUTORS_THREAD_COUNT, Integer.class);
            writer.write(this.previewMode, PREVIEW_MODE, Boolean.class);
            if (this.sccpProtocolVersion != null) {
                writer.write(this.sccpProtocolVersion.toString(), SCCP_PROTOCOL_VERSION, String.class);
            }
            writer.write(this.congControl_TIMER_A, CONG_CONTROL_TIMER_A, Integer.class);
            writer.write(this.congControl_TIMER_D, CONG_CONTROL_TIMER_D, Integer.class);
            if (this.congControl_Algo != null) {
                writer.write(this.congControl_Algo.toString(), CONG_CONTROL_ALGO, String.class);
            }
            writer.write(this.congControl_blockingOutgoungSccpMessages, CONG_CONTROL_BLOCKING_OUTGOUNG_SCCP_MESSAGES, Boolean.class);
            writer.write(this.sstTimerDuration_Min, SST_TIMER_DURATION_MIN, Integer.class);
            writer.write(this.sstTimerDuration_Max, SST_TIMER_DURATION_MAX, Integer.class);
            writer.write(this.sstTimerDuration_IncreaseFactor, SST_TIMER_DURATION_INCREASE_FACTOR, Double.class);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error(String.format("Error while persisting the Sccp Resource state in file=%s", this.persistFile.toString()), e);
        }
    }

    protected void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.load(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    protected void load(XMLObjectReader reader) throws XMLStreamException {
        Double vald;
        Boolean volb;
        Integer vali = reader.read(Z_MARGIN_UDT_MSG, Integer.class);
        if (vali != null) {
            this.zMarginXudtMessage = vali;
        }
        if ((vali = reader.read(CONN_EST_TIMER_DELAY, Integer.class)) != null) {
            this.connEstTimerDelay = vali;
        }
        if ((vali = reader.read(IAS_TIMER_DELAY, Integer.class)) != null) {
            this.iasTimerDelay = vali;
        }
        if ((vali = reader.read(IAR_TIMER_DELAY, Integer.class)) != null) {
            this.iarTimerDelay = vali;
        }
        if ((vali = reader.read(REL_TIMER_DELAY, Integer.class)) != null) {
            this.relTimerDelay = vali;
        }
        if ((vali = reader.read(REPEAT_REL_TIMER_DELAY, Integer.class)) != null) {
            this.repeatRelTimerDelay = vali;
        }
        if ((vali = reader.read(INT_TIMER_DELAY, Integer.class)) != null) {
            this.intTimerDelay = vali;
        }
        if ((vali = reader.read(GUARD_TIMER_DELAY, Integer.class)) != null) {
            this.guardTimerDelay = vali;
        }
        if ((vali = reader.read(RESET_TIMER_DELAY, Integer.class)) != null) {
            this.resetTimerDelay = vali;
        }
        if ((vali = reader.read(REASSEMBLY_TIMER_DELAY, Integer.class)) != null) {
            this.reassemblyTimerDelay = vali;
        }
        if ((vali = reader.read(MAX_DATA_MSG, Integer.class)) != null) {
            this.maxDataMessage = vali;
        }
        if ((vali = reader.read(PERIOD_OF_LOG, Integer.class)) != null) {
            this.periodOfLogging = vali;
        }
        if ((volb = reader.read(REMOVE_SPC, Boolean.class)) != null) {
            this.removeSpc = volb;
        }
        if ((volb = reader.read(CAN_RELAY, Boolean.class)) != null) {
            this.canRelay = volb;
        }
        if ((vali = reader.read(TIMER_EXECUTORS_THREAD_COUNT, Integer.class)) != null) {
            this.timerExecutorsThreadCount = vali;
        }
        if ((volb = reader.read(PREVIEW_MODE, Boolean.class)) != null) {
            this.previewMode = volb;
        }
        volb = reader.read(RESERVED_FOR_NATIONAL_USE_VALUE_ADDRESS_INDICATOR, Boolean.class);
        String s1 = reader.read(SCCP_PROTOCOL_VERSION, String.class);
        if (s1 != null) {
            this.sccpProtocolVersion = Enum.valueOf(SccpProtocolVersion.class, s1);
        }
        if ((vali = reader.read(CONG_CONTROL_TIMER_A, Integer.class)) != null) {
            this.congControl_TIMER_A = vali;
        }
        if ((vali = reader.read(CONG_CONTROL_TIMER_D, Integer.class)) != null) {
            this.congControl_TIMER_D = vali;
        }
        if ((s1 = reader.read(CONG_CONTROL_ALGO, String.class)) != null) {
            this.congControl_Algo = Enum.valueOf(SccpCongestionControlAlgo.class, s1);
        }
        if ((volb = reader.read(CONG_CONTROL_BLOCKING_OUTGOUNG_SCCP_MESSAGES, Boolean.class)) != null) {
            this.congControl_blockingOutgoungSccpMessages = volb;
        }
        if ((vali = reader.read(SST_TIMER_DURATION_MIN, Integer.class)) != null) {
            this.sstTimerDuration_Min = vali;
        }
        if ((vali = reader.read(SST_TIMER_DURATION_MAX, Integer.class)) != null) {
            this.sstTimerDuration_Max = vali;
        }
        if ((vald = reader.read(SST_TIMER_DURATION_INCREASE_FACTOR, Double.class)) != null) {
            this.sstTimerDuration_IncreaseFactor = vald;
        }
        reader.close();
    }

    public class MessageReassemblyProcess
    implements Runnable {
        private int segmentationLocalRef;
        private SccpAddress callingPartyAddress;
        private Future timer;

        public MessageReassemblyProcess(int segmentationLocalRef, SccpAddress callingPartyAddress) {
            this.segmentationLocalRef = segmentationLocalRef;
            this.callingPartyAddress = callingPartyAddress;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MessageReassemblyProcess)) {
                return false;
            }
            MessageReassemblyProcess x = (MessageReassemblyProcess)obj;
            if (this.segmentationLocalRef != x.segmentationLocalRef) {
                return false;
            }
            if (this.callingPartyAddress == null || x.callingPartyAddress == null) {
                return false;
            }
            return this.callingPartyAddress.equals(x.callingPartyAddress);
        }

        public int hashCode() {
            return this.segmentationLocalRef;
        }

        public void startTimer() {
            this.timer = SccpStackImpl.this.timerExecutors.schedule(this, (long)SccpStackImpl.this.reassemblyTimerDelay, TimeUnit.MILLISECONDS);
        }

        public void stopTimer() {
            if (this.timer != null) {
                this.timer.cancel(false);
                this.timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SccpSegmentableMessageImpl msg = null;
            FastMap<MessageReassemblyProcess, SccpSegmentableMessageImpl> fastMap = SccpStackImpl.this.reassemplyCache;
            synchronized (fastMap) {
                msg = SccpStackImpl.this.reassemplyCache.remove(this);
                if (msg == null) {
                    return;
                }
                msg.cancelSegmentation();
            }
            try {
                SccpStackImpl.this.sccpRoutingControl.sendSccpError(msg, ReturnCauseValue.CANNOT_REASEMBLE, null);
            }
            catch (Exception e) {
                SccpStackImpl.this.logger.warn("IOException when sending an error message", e);
            }
        }
    }

    protected static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

