/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPart;
import org.restcomm.protocols.ss7.sccp.MaxConnectionCountReached;
import org.restcomm.protocols.ss7.sccp.NetworkIdState;
import org.restcomm.protocols.ss7.sccp.SccpConnection;
import org.restcomm.protocols.ss7.sccp.SccpListener;
import org.restcomm.protocols.ss7.sccp.SccpManagementEventListener;
import org.restcomm.protocols.ss7.sccp.SccpProvider;
import org.restcomm.protocols.ss7.sccp.SccpStack;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpNoticeMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.restcomm.protocols.ss7.sccp.message.MessageFactory;
import org.restcomm.protocols.ss7.sccp.message.SccpDataMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;
import org.restcomm.ss7.congestion.ExecutorCongestionMonitor;

public class SccpProviderImpl
implements SccpProvider,
Serializable {
    private static final Logger logger = Logger.getLogger(SccpProviderImpl.class);
    private transient SccpStackImpl stack;
    protected FastMap<Integer, SccpListener> ssnToListener = new FastMap();
    protected FastList<SccpManagementEventListener> managementEventListeners = new FastList();
    private MessageFactoryImpl messageFactory;
    private ParameterFactoryImpl parameterFactory;
    private ConcurrentHashMap<Integer, Integer> congestionSsn = new ConcurrentHashMap();

    SccpProviderImpl(SccpStackImpl stack) {
        this.stack = stack;
        this.messageFactory = stack.messageFactory;
        this.parameterFactory = new ParameterFactoryImpl();
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public ParameterFactory getParameterFactory() {
        return this.parameterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSccpListener(int ssn, SccpListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            SccpListener existingListener = this.ssnToListener.get(ssn);
            if (existingListener == null || logger.isEnabledFor(Level.WARN)) {
                // empty if block
            }
            FastMap<Integer, SccpListener> newListener = new FastMap<Integer, SccpListener>();
            newListener.putAll(this.ssnToListener);
            newListener.put(ssn, listener);
            this.ssnToListener = newListener;
            this.stack.broadcastChangedSsnState(ssn, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterSccpListener(int ssn) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            FastMap<Integer, SccpListener> newListener = new FastMap<Integer, SccpListener>();
            newListener.putAll(this.ssnToListener);
            SccpListener existingListener = (SccpListener)newListener.remove(ssn);
            if (existingListener == null && logger.isEnabledFor(Level.WARN)) {
                logger.warn(String.format("No existing SccpListnere=%s for SSN=%d", existingListener, ssn));
            }
            this.ssnToListener = newListener;
            this.stack.broadcastChangedSsnState(ssn, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerManagementEventListener(SccpManagementEventListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            if (this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<SccpManagementEventListener> newManagementEventListeners = new FastList<SccpManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.add(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterManagementEventListener(SccpManagementEventListener listener) {
        SccpProviderImpl sccpProviderImpl = this;
        synchronized (sccpProviderImpl) {
            if (!this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<SccpManagementEventListener> newManagementEventListeners = new FastList<SccpManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.remove(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    protected SccpListener getSccpListener(int ssn) {
        return this.ssnToListener.get(ssn);
    }

    protected FastMap<Integer, SccpListener> getAllSccpListeners() {
        return this.ssnToListener;
    }

    @Override
    public SccpConnection newConnection(int localSsn, ProtocolClass protocol) throws MaxConnectionCountReached {
        return this.stack.newConnection(localSsn, protocol);
    }

    @Override
    public FastMap<LocalReference, SccpConnection> getConnections() {
        FastMap<LocalReferenceImpl, SccpConnectionImpl> connections = new FastMap<LocalReferenceImpl, SccpConnectionImpl>();
        if (this.stack.connections != null) {
            for (Map.Entry<Integer, SccpConnectionImpl> entry : this.stack.connections.entrySet()) {
                connections.put(new LocalReferenceImpl(entry.getKey()), entry.getValue());
            }
        }
        return connections.shared();
    }

    @Override
    public void send(SccpDataMessage message) throws IOException {
        try {
            SccpDataMessageImpl msg = (SccpDataMessageImpl)message;
            this.stack.send(msg);
        }
        catch (Exception e) {
            logger.error(e);
            throw new IOException(e);
        }
    }

    @Override
    public void send(SccpNoticeMessage message) throws IOException {
        try {
            SccpNoticeMessageImpl msg = (SccpNoticeMessageImpl)message;
            this.stack.send(msg);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMaxUserDataLength(SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, int msgNetworkId) {
        return this.stack.getMaxUserDataLength(calledPartyAddress, callingPartyAddress, msgNetworkId);
    }

    @Override
    public FastMap<Integer, NetworkIdState> getNetworkIdStateList() {
        return this.stack.router.getNetworkIdList(-1);
    }

    @Override
    public void coordRequest(int ssn) {
    }

    @Override
    public ExecutorCongestionMonitor[] getExecutorCongestionMonitorList() {
        ArrayList<ExecutorCongestionMonitor> res = new ArrayList<ExecutorCongestionMonitor>();
        FastCollection.Record e = this.stack.mtp3UserParts.head();
        FastMap.Entry<Integer, Mtp3UserPart> end = this.stack.mtp3UserParts.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3UserPart mup = (Mtp3UserPart)((FastMap.Entry)e).getValue();
            ExecutorCongestionMonitor ecm = mup.getExecutorCongestionMonitor();
            if (ecm == null) continue;
            res.add(ecm);
        }
        ExecutorCongestionMonitor[] ress = new ExecutorCongestionMonitor[res.size()];
        res.toArray(ress);
        return ress;
    }

    @Override
    public SccpStack getSccpStack() {
        return this.stack;
    }

    public ConcurrentHashMap<Integer, Integer> getCongestionSsn() {
        return this.congestionSsn;
    }

    @Override
    public void updateSPCongestion(Integer ssn, Integer congestionLevel) {
        this.congestionSsn.put(ssn, congestionLevel);
    }
}

