/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionWithTimers;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageUtil;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt1MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt2MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;

abstract class SccpConnectionWithSegmentingImpl
extends SccpConnectionWithTimers {
    private boolean awaitSegments = false;
    private SccpConnSegmentableMessageImpl currentSegmentedMessage;

    public SccpConnectionWithSegmentingImpl(int sls, int localSsn, LocalReference localReference, ProtocolClass protocol, SccpStackImpl stack, SccpRoutingControl sccpRoutingControl) {
        super(sls, localSsn, localReference, protocol, stack, sccpRoutingControl);
    }

    public boolean isAwaitSegments() {
        return this.awaitSegments;
    }

    @Override
    protected void receiveMessage(SccpConnMessage message) throws Exception {
        super.receiveMessage(message);
        if (message instanceof SccpConnSegmentableMessageImpl) {
            this.receiveDataMessage((SccpConnSegmentableMessageImpl)message);
        }
    }

    protected void receiveDataMessage(SccpConnSegmentableMessageImpl msg) throws Exception {
        if (!msg.isMoreData() && !this.awaitSegments) {
            this.callListenerOnData(msg.getUserData());
        } else if (msg.isMoreData()) {
            this.awaitSegments = true;
            if (this.currentSegmentedMessage == null) {
                this.currentSegmentedMessage = msg;
            } else {
                this.currentSegmentedMessage.setReceivedNextSegment(msg);
            }
        } else if (!msg.isMoreData() && this.awaitSegments) {
            this.currentSegmentedMessage.setReceivedNextSegment(msg);
            this.awaitSegments = false;
            if (!this.currentSegmentedMessage.isFullyRecieved()) {
                this.logger.error(String.format("Message is expected to be fully received but it isn't: %s", msg));
                throw new IllegalStateException();
            }
            this.callListenerOnData(this.currentSegmentedMessage.getUserData());
            this.currentSegmentedMessage = null;
        }
    }

    public void send(byte[] data) throws Exception {
        if (data.length <= 255) {
            this.sendDataMessageSegment(data, false);
        } else {
            int i;
            int chunks = (int)Math.ceil((double)data.length / 255.0);
            int pos = 0;
            ArrayList<byte[]> chunkData = new ArrayList<byte[]>();
            for (i = 0; i < chunks; ++i) {
                int copyBytes;
                if (i != chunks - 1) {
                    copyBytes = 255;
                    chunkData.add(Arrays.copyOfRange(data, pos, pos + 255));
                } else {
                    copyBytes = data.length - i * 255;
                    chunkData.add(Arrays.copyOfRange(data, pos, pos + copyBytes));
                }
                pos += copyBytes;
            }
            for (i = 0; i < chunkData.size(); ++i) {
                this.sendDataMessageSegment((byte[])chunkData.get(i), i != chunkData.size() - 1);
            }
        }
    }

    private void sendDataMessageSegment(byte[] data, boolean moreData) throws Exception {
        if (data.length > 255) {
            this.logger.error("Message data is too lengthy");
            throw new IllegalArgumentException("Message data is too lengthy");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Sending data message to DPC=%d, SSN=%d, DLR=%s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference()));
        }
        if (!this.isAvailable()) {
            throw new SccpConnectionImpl.ConnectionNotAvailableException(String.format("Trying to send data when in non-compatible state %s", new Object[]{this.getState()}));
        }
        SccpConnSegmentableMessageImpl dataMessage = this.getProtocolClass().getProtocolClass() == 2 ? new SccpConnDt1MessageImpl(255, this.getSls(), this.getLocalSsn()) : new SccpConnDt2MessageImpl(255, this.getSls(), this.getLocalSsn());
        dataMessage.setDestinationLocalReferenceNumber(this.getRemoteReference());
        dataMessage.setSourceLocalReferenceNumber(this.getLocalReference());
        dataMessage.setUserData(data);
        dataMessage.setMoreData(moreData);
        this.lastMoreDataSent = moreData;
        if (MessageUtil.getDln(dataMessage) == null) {
            this.logger.error(String.format("Message doesn't have DLN set: ", dataMessage));
            throw new IllegalStateException();
        }
        this.sendMessage(dataMessage);
    }
}

