/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.LMSI;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.lsm.AdditionalNumber;
import org.restcomm.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.LMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.lsm.AdditionalNumberImpl;

public class LocationInfoWithLMSIImpl
extends SequenceBase
implements LocationInfoWithLMSI {
    private static final int _TAG_NetworkNodeNumber = 1;
    private static final int _TAG_GprsNodeIndicator = 5;
    private static final int _TAG_AdditionalNumber = 6;
    private ISDNAddressString networkNodeNumber;
    private LMSI lmsi;
    private MAPExtensionContainer extensionContainer;
    private boolean gprsNodeIndicator;
    private AdditionalNumber additionalNumber;

    public LocationInfoWithLMSIImpl() {
        super("LocationInfoWithLMSI");
    }

    public LocationInfoWithLMSIImpl(ISDNAddressString networkNodeNumber, LMSI lmsi, MAPExtensionContainer extensionContainer, boolean gprsNodeIndicator, AdditionalNumber additionalNumber) {
        super("LocationInfoWithLMSI");
        this.networkNodeNumber = networkNodeNumber;
        this.lmsi = lmsi;
        this.extensionContainer = extensionContainer;
        this.gprsNodeIndicator = gprsNodeIndicator;
        this.additionalNumber = additionalNumber;
    }

    @Override
    public ISDNAddressString getNetworkNodeNumber() {
        return this.networkNodeNumber;
    }

    @Override
    public LMSI getLMSI() {
        return this.lmsi;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public boolean getGprsNodeIndicator() {
        return this.gprsNodeIndicator;
    }

    @Override
    public AdditionalNumber getAdditionalNumber() {
        return this.additionalNumber;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.networkNodeNumber = null;
        this.lmsi = null;
        this.extensionContainer = null;
        this.gprsNodeIndicator = false;
        this.additionalNumber = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (num == 0) {
                if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 1) {
                    throw new MAPParsingComponentException("Error when decoding LocationInfoWithLMSI: networkNode-Number: tagClass or tag is bad or element is not primitive: tagClass=" + ais.getTagClass() + ", Tag=" + tag, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.networkNodeNumber = new ISDNAddressStringImpl();
                ((ISDNAddressStringImpl)this.networkNodeNumber).decodeAll(ais);
            } else if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive() || this.lmsi != null) {
                            throw new MAPParsingComponentException("Error when decoding " + this._PrimitiveName + ": lmsi: double element or element is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lmsi = new LMSIImpl();
                        ((LMSIImpl)this.lmsi).decodeAll(ais);
                        break;
                    }
                    case 16: {
                        if (ais.isTagPrimitive() || this.extensionContainer != null) {
                            throw new MAPParsingComponentException("Error when decoding " + this._PrimitiveName + ": extensionContainer: double element or element is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 5: {
                        if (!ais.isTagPrimitive() || this.gprsNodeIndicator) {
                            throw new MAPParsingComponentException("Error when decoding " + this._PrimitiveName + ": gprsNodeIndicator: double element or element is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.gprsNodeIndicator = true;
                        break;
                    }
                    case 6: {
                        if (ais.isTagPrimitive() || this.additionalNumber != null) {
                            throw new MAPParsingComponentException("Error when decoding " + this._PrimitiveName + ": additionalNumber: double element or element is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.additionalNumber = new AdditionalNumberImpl();
                        ((AdditionalNumberImpl)this.additionalNumber).decodeAll(ais2);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else {
                ais.advanceElement();
            }
            ++num;
        }
        if (this.networkNodeNumber == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": 1 parameter is mandatory, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.networkNodeNumber == null) {
                throw new MAPException("Error while encoding " + this._PrimitiveName + ": networkNodeNumber must not be null");
            }
            ((ISDNAddressStringImpl)this.networkNodeNumber).encodeAll(asnOs, 2, 1);
            if (this.lmsi != null) {
                ((LMSIImpl)this.lmsi).encodeAll(asnOs);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.gprsNodeIndicator) {
                asnOs.writeNull(2, 5);
            }
            if (this.additionalNumber != null) {
                asnOs.writeTag(2, false, 6);
                int pos = asnOs.StartContentDefiniteLength();
                ((AdditionalNumberImpl)this.additionalNumber).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.networkNodeNumber != null) {
            sb.append("networkNodeNumber=");
            sb.append(this.networkNodeNumber.toString());
        }
        if (this.lmsi != null) {
            sb.append(", lmsi=");
            sb.append(this.lmsi.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        if (this.gprsNodeIndicator) {
            sb.append(", gprsNodeIndicator");
        }
        if (this.additionalNumber != null) {
            sb.append(", additionalNumber=");
            sb.append(this.additionalNumber.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

