/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.lsm;

import org.restcomm.protocols.ss7.map.api.service.lsm.DeferredLocationEventType;
import org.restcomm.protocols.ss7.map.primitives.BitStringBase;

public class DeferredLocationEventTypeImpl
extends BitStringBase
implements DeferredLocationEventType {
    private static final int _INDEX_MS_AVAILABLE = 0;
    private static final int _INDEX__ENTERING_INTO_AREA = 1;
    private static final int _INDEX_LEAVING_FROM_AREA = 2;
    private static final int _INDEX_BEING_INSIDE_AREA = 3;

    public DeferredLocationEventTypeImpl() {
        super(1, 16, 4, "DeferredLocationEventType");
    }

    public DeferredLocationEventTypeImpl(boolean msAvailable, boolean enteringIntoArea, boolean leavingFromArea, boolean beingInsideArea) {
        super(1, 16, 4, "DeferredLocationEventType");
        if (msAvailable) {
            this.bitString.set(0);
        }
        if (enteringIntoArea) {
            this.bitString.set(1);
        }
        if (leavingFromArea) {
            this.bitString.set(2);
        }
        if (beingInsideArea) {
            this.bitString.set(3);
        }
    }

    @Override
    public boolean getMsAvailable() {
        return this.bitString.get(0);
    }

    @Override
    public boolean getEnteringIntoArea() {
        return this.bitString.get(1);
    }

    @Override
    public boolean getLeavingFromArea() {
        return this.bitString.get(2);
    }

    @Override
    public boolean getBeingInsideArea() {
        return this.bitString.get(3);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.getMsAvailable()) {
            sb.append("MsAvailable, ");
        }
        if (this.getEnteringIntoArea()) {
            sb.append("EnteringIntoArea, ");
        }
        if (this.getLeavingFromArea()) {
            sb.append("LeavingFromArea, ");
        }
        if (this.getBeingInsideArea()) {
            sb.append("BeingInsideArea, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

