/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.parameter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.DeregistrationStatusImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.RoutingContextImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.DeregistrationResult;
import org.restcomm.protocols.ss7.m3ua.parameter.DeregistrationStatus;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingContext;

public class DeregistrationResultImpl
extends ParameterImpl
implements DeregistrationResult {
    private RoutingContext rc;
    private DeregistrationStatus status;
    private byte[] value;
    private ByteBuf buf = Unpooled.buffer(16);

    public DeregistrationResultImpl(RoutingContext rc, DeregistrationStatus status) {
        this.tag = (short)521;
        this.rc = rc;
        this.status = status;
        this.encode();
    }

    public DeregistrationResultImpl(byte[] data) {
        this.tag = (short)521;
        block4: for (int pos = 0; pos < data.length; pos += pos % 4) {
            short tag = (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
            short len = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF);
            byte[] value = new byte[len - 4];
            System.arraycopy(data, pos + 4, value, 0, value.length);
            pos += len;
            switch (tag) {
                case 6: {
                    this.rc = new RoutingContextImpl(value);
                    continue block4;
                }
                case 531: {
                    this.status = new DeregistrationStatusImpl(value);
                }
            }
        }
    }

    private void encode() {
        ((RoutingContextImpl)this.rc).write(this.buf);
        ((DeregistrationStatusImpl)this.status).write(this.buf);
        int length = this.buf.readableBytes();
        this.value = new byte[length];
        this.buf.getBytes(this.buf.readerIndex(), this.value);
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    @Override
    public DeregistrationStatus getDeregistrationStatus() {
        return this.status;
    }

    @Override
    public RoutingContext getRoutingContext() {
        return this.rc;
    }
}

