/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp.netty;

import com.sun.nio.sctp.SctpStandardSocketOptions;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationType;
import org.mobicents.protocols.api.CongestionListener;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.ManagementEventListener;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.api.ServerListener;
import org.mobicents.protocols.sctp.AssociationMap;
import org.mobicents.protocols.sctp.netty.NettyAssociationImpl;
import org.mobicents.protocols.sctp.netty.NettySctpXMLBinding;
import org.mobicents.protocols.sctp.netty.NettyServerImpl;

public class NettySctpManagementImpl
implements Management {
    private static final Logger logger = Logger.getLogger(NettySctpManagementImpl.class);
    private static final String SCTP_PERSIST_DIR_KEY = "sctp.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "sctp.xml";
    private static final String SERVERS = "servers";
    private static final String ASSOCIATIONS = "associations";
    private static final String CONNECT_DELAY_PROP = "connectdelay";
    private static final String SINGLE_THREAD_PROP = "singlethread";
    private static final String WORKER_THREADS_PROP = "workerthreads";
    public static final String CONG_CONTROL_DELAY_THRESHOLD_1 = "congControl_DelayThreshold_1";
    public static final String CONG_CONTROL_DELAY_THRESHOLD_2 = "congControl_DelayThreshold_2";
    public static final String CONG_CONTROL_DELAY_THRESHOLD_3 = "congControl_DelayThreshold_3";
    public static final String CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_1 = "congControl_BackToNormalDelayThreshold_1";
    public static final String CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_2 = "congControl_BackToNormalDelayThreshold_2";
    public static final String CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_3 = "congControl_BackToNormalDelayThreshold_3";
    static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private final TextBuilder persistFile = TextBuilder.newInstance();
    protected static final NettySctpXMLBinding binding = new NettySctpXMLBinding();
    protected static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private final String name;
    protected String persistDir = null;
    private int connectDelay = 5000;
    protected double[] congControl_DelayThreshold = new double[]{2.5, 8.0, 14.0};
    protected double[] congControl_BackToNormalDelayThreshold = new double[]{1.5, 5.5, 10.0};
    private ServerListener serverListener = null;
    private FastList<ManagementEventListener> managementEventListeners = new FastList();
    private FastList<CongestionListener> congestionListeners = new FastList();
    protected FastList<Server> servers = new FastList();
    protected AssociationMap<String, Association> associations = new AssociationMap();
    private volatile boolean started = false;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ScheduledExecutorService clientExecutor;
    private Boolean optionSctpDisableFragments = null;
    private Integer optionSctpFragmentInterleave = null;
    private Integer optionSctpInitMaxstreams_MaxOutStreams = null;
    private Integer optionSctpInitMaxstreams_MaxInStreams = null;
    private Boolean optionSctpNodelay = true;
    private Integer optionSoSndbuf = null;
    private Integer optionSoRcvbuf = null;
    private Integer optionSoLinger = null;

    public NettySctpManagementImpl(String name) throws IOException {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(NettyServerImpl.class, "server");
        binding.setAlias(NettyAssociationImpl.class, "association");
        binding.setAlias(String.class, "string");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public ServerListener getServerListener() {
        return this.serverListener;
    }

    @Override
    public void setServerListener(ServerListener serverListener) {
        this.serverListener = serverListener;
    }

    protected EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    protected EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    protected ScheduledExecutorService getClientExecutor() {
        return this.clientExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addManagementEventListener(ManagementEventListener listener) {
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            if (this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<ManagementEventListener> newManagementEventListeners = new FastList<ManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.add(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeManagementEventListener(ManagementEventListener listener) {
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            if (!this.managementEventListeners.contains(listener)) {
                return;
            }
            FastList<ManagementEventListener> newManagementEventListeners = new FastList<ManagementEventListener>();
            newManagementEventListeners.addAll(this.managementEventListeners);
            newManagementEventListeners.remove(listener);
            this.managementEventListeners = newManagementEventListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCongestionListener(CongestionListener listener) {
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            if (this.congestionListeners.contains(listener)) {
                return;
            }
            FastList<CongestionListener> newCongestionListeners = new FastList<CongestionListener>();
            newCongestionListeners.addAll(this.congestionListeners);
            newCongestionListeners.add(listener);
            this.congestionListeners = newCongestionListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCongestionListener(CongestionListener listener) {
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            if (!this.congestionListeners.contains(listener)) {
                return;
            }
            FastList<CongestionListener> newCongestionListeners = new FastList<CongestionListener>();
            newCongestionListeners.addAll(this.congestionListeners);
            newCongestionListeners.remove(listener);
            this.congestionListeners = newCongestionListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (this.started) {
            logger.warn(String.format("management=%s is already started", this.name));
            return;
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            this.persistFile.clear();
            if (this.persistDir != null) {
                this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
            } else {
                this.persistFile.append(System.getProperty(SCTP_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
            }
            logger.info(String.format("SCTP configuration file path %s", this.persistFile.toString()));
            this.bossGroup = new NioEventLoopGroup(1, new DefaultThreadFactory("Sctp-BossGroup-" + this.name));
            this.workerGroup = new NioEventLoopGroup(0, new DefaultThreadFactory("Sctp-WorkerGroup-" + this.name));
            this.clientExecutor = new ScheduledThreadPoolExecutor(1, new DefaultThreadFactory("Sctp-ClientExecutorGroup-" + this.name));
            try {
                this.load();
            }
            catch (FileNotFoundException e) {
                logger.warn(String.format("Failed to load the SCTP configuration file. \n%s", e.getMessage()));
            }
            this.started = true;
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Started SCTP Management=%s", this.name));
            }
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServiceStarted();
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServiceStarted", ee);
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (!this.started) {
            logger.warn(String.format("management=%s is already stopped", this.name));
            return;
        }
        for (ManagementEventListener lstr : this.managementEventListeners) {
            try {
                lstr.onServiceStopped();
            }
            catch (Throwable ee) {
                logger.error("Exception while invoking onServiceStopped", ee);
            }
        }
        this.store();
        AssociationMap<String, Association> associationsTemp = this.associations;
        FastCollection.Record n = associationsTemp.head();
        FastMap.Entry end = associationsTemp.tail();
        while ((n = ((FastMap.Entry)n).getNext()) != end) {
            Association associationTemp = (Association)((FastMap.Entry)n).getValue();
            if (!associationTemp.isStarted()) continue;
            ((NettyAssociationImpl)associationTemp).stop();
        }
        FastList<Server> tempServers = this.servers;
        FastCollection.Record n2 = tempServers.head();
        FastCollection.Record end2 = tempServers.tail();
        while ((n2 = ((FastList.Node)n2).getNext()) != end2) {
            Server serverTemp = (Server)((FastList.Node)n2).getValue();
            if (!serverTemp.isStarted()) continue;
            try {
                ((NettyServerImpl)serverTemp).stop();
            }
            catch (Exception e) {
                logger.error(String.format("Exception while stopping the Server=%s", serverTemp.getName()), e);
            }
        }
        for (int i1 = 0; i1 < 20; ++i1) {
            boolean assConnected = false;
            FastCollection.Record n3 = this.associations.head();
            FastMap.Entry end3 = this.associations.tail();
            while ((n3 = ((FastMap.Entry)n3).getNext()) != end3) {
                Association associationTemp = (Association)((FastMap.Entry)n3).getValue();
                if (!associationTemp.isConnected()) continue;
                assConnected = true;
                break;
            }
            if (!assConnected) break;
            Thread.sleep(100L);
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.clientExecutor.shutdown();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllResourses() throws Exception {
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            if (!this.started) {
                throw new Exception(String.format("Management=%s not started", this.name));
            }
            if (this.associations.size() == 0 && this.servers.size() == 0) {
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Removing allocated resources: Servers=%d, Associations=%d", this.servers.size(), this.associations.size()));
            }
            ArrayList<Object> lst = new ArrayList<Object>();
            FastCollection.Record n = this.associations.head();
            FastMap.Entry entry = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != entry) {
                lst.add(((FastMap.Entry)n).getKey());
            }
            for (String string : lst) {
                this.stopAssociation(string);
                this.removeAssociation(string);
            }
            lst.clear();
            n = this.servers.head();
            FastCollection.Record record = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != record) {
                lst.add(((Server)((FastList.Node)n).getValue()).getName());
            }
            for (String string : lst) {
                this.stopServer(string);
                this.removeServer(string);
            }
            this.store();
            for (ManagementEventListener managementEventListener : this.managementEventListeners) {
                try {
                    managementEventListener.onRemoveAllResources();
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onRemoveAllResources", ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Server addServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, boolean acceptAnonymousConnections, int maxConcurrentConnectionsCount, String[] extraHostAddresses) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (hostAddress == null) {
            throw new Exception("Server host address cannot be null");
        }
        if (port < 1) {
            throw new Exception("Server host port cannot be less than 1");
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            FastCollection.Record n = this.servers.head();
            FastCollection.Record end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                Server serverTemp = (Server)((FastList.Node)n).getValue();
                if (serverName.equals(serverTemp.getName())) {
                    throw new Exception(String.format("Server name=%s already exist", serverName));
                }
                if (!hostAddress.equals(serverTemp.getHostAddress()) || port != serverTemp.getHostport()) continue;
                throw new Exception(String.format("Server name=%s is already bound to %s:%d", serverTemp.getName(), serverTemp.getHostAddress(), serverTemp.getHostport()));
            }
            NettyServerImpl server = new NettyServerImpl(serverName, hostAddress, port, ipChannelType, acceptAnonymousConnections, maxConcurrentConnectionsCount, extraHostAddresses);
            server.setManagement(this);
            FastList<Server> newServers = new FastList<Server>();
            newServers.addAll(this.servers);
            newServers.add(server);
            this.servers = newServers;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServerAdded(server);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServerAdded", ee);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Created Server=%s", server.getName()));
            }
            return server;
        }
    }

    @Override
    public Server addServer(String serverName, String hostAddress, int port, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        return this.addServer(serverName, hostAddress, port, ipChannelType, false, 0, extraHostAddresses);
    }

    @Override
    public Server addServer(String serverName, String hostAddress, int port) throws Exception {
        return this.addServer(serverName, hostAddress, port, IpChannelType.SCTP, false, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            NettyServerImpl removeServer = null;
            FastCollection.Record n = this.servers.head();
            FastCollection.Record end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                NettyServerImpl serverTemp = (NettyServerImpl)((FastList.Node)n).getValue();
                if (!serverName.equals(serverTemp.getName())) continue;
                if (serverTemp.isStarted()) {
                    throw new Exception(String.format("Server=%s is started. Stop the server before removing", serverName));
                }
                if (serverTemp.anonymAssociations.size() != 0 || serverTemp.associations.size() != 0) {
                    throw new Exception(String.format("Server=%s has Associations. Remove all those Associations before removing Server", serverName));
                }
                removeServer = serverTemp;
                break;
            }
            if (removeServer == null) {
                throw new Exception(String.format("No Server found with name=%s", serverName));
            }
            FastList<Server> newServers = new FastList<Server>();
            newServers.addAll(this.servers);
            newServers.remove(removeServer);
            this.servers = newServers;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServerRemoved(removeServer);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServerRemoved", ee);
                }
            }
        }
    }

    @Override
    public void startServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (this.name == null) {
            throw new Exception("Server name cannot be null");
        }
        FastList<Server> tempServers = this.servers;
        FastCollection.Record n = tempServers.head();
        FastCollection.Record end = tempServers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            Server serverTemp = (Server)((FastList.Node)n).getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            if (serverTemp.isStarted()) {
                throw new Exception(String.format("Server=%s is already started", serverName));
            }
            ((NettyServerImpl)serverTemp).start();
            this.store();
            return;
        }
        throw new Exception(String.format("No Server foubd with name=%s", serverName));
    }

    @Override
    public void stopServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        FastList<Server> tempServers = this.servers;
        FastCollection.Record n = tempServers.head();
        FastCollection.Record end = tempServers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            Server serverTemp = (Server)((FastList.Node)n).getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            ((NettyServerImpl)serverTemp).stop();
            this.store();
            return;
        }
        throw new Exception(String.format("No Server found with name=%s", serverName));
    }

    @Override
    public List<Server> getServers() {
        return this.servers.unmodifiable();
    }

    @Override
    public Association addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName) throws Exception {
        return this.addServerAssociation(peerAddress, peerPort, serverName, assocName, IpChannelType.SCTP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName, IpChannelType ipChannelType) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (peerAddress == null) {
            throw new Exception("Peer address cannot be null");
        }
        if (peerPort < 0) {
            throw new Exception("Peer port cannot be less than 0");
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            if (this.associations.get(assocName) != null) {
                throw new Exception(String.format("Already has association=%s", assocName));
            }
            Server server = null;
            FastCollection.Record n = this.servers.head();
            FastMap.Entry end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                Server serverTemp = (Server)((FastList.Node)n).getValue();
                if (!serverTemp.getName().equals(serverName)) continue;
                server = serverTemp;
            }
            if (server == null) {
                throw new Exception(String.format("No Server found for name=%s", serverName));
            }
            n = this.associations.head();
            end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                Association associationTemp = (Association)((FastMap.Entry)n).getValue();
                if (!associationTemp.getServerName().equals(server.getName()) || !peerAddress.equals(associationTemp.getPeerAddress()) || associationTemp.getPeerPort() != peerPort) continue;
                throw new Exception(String.format("Already has association=%s with same peer address=%s and port=%d", associationTemp.getName(), peerAddress, peerPort));
            }
            if (server.getIpChannelType() != ipChannelType) {
                throw new Exception(String.format("Server and Accociation has different IP channel type", new Object[0]));
            }
            NettyAssociationImpl association = new NettyAssociationImpl(peerAddress, peerPort, serverName, assocName, ipChannelType);
            association.setManagement(this);
            AssociationMap<String, Association> newAssociations = new AssociationMap<String, Association>();
            newAssociations.putAll(this.associations);
            newAssociations.put(assocName, association);
            this.associations = newAssociations;
            FastList<String> newAssociations2 = new FastList<String>();
            newAssociations2.addAll(((NettyServerImpl)server).associations);
            newAssociations2.add(assocName);
            ((NettyServerImpl)server).associations = newAssociations2;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationAdded(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationAdded", ee);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Added Associoation=%s of type=%s", new Object[]{association.getName(), association.getAssociationType()}));
            }
            return association;
        }
    }

    @Override
    public Association addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName) throws Exception {
        return this.addAssociation(hostAddress, hostPort, peerAddress, peerPort, assocName, IpChannelType.SCTP, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (hostAddress == null) {
            throw new Exception("Host address cannot be null");
        }
        if (hostPort < 0) {
            throw new Exception("Host port cannot be less than 0");
        }
        if (peerAddress == null) {
            throw new Exception("Peer address cannot be null");
        }
        if (peerPort < 1) {
            throw new Exception("Peer port cannot be less than 1");
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            FastCollection.Record n = this.associations.head();
            FastMap.Entry end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                Association associationTemp = (Association)((FastMap.Entry)n).getValue();
                if (assocName.equals(associationTemp.getName())) {
                    throw new Exception(String.format("Already has association=%s", associationTemp.getName()));
                }
                if (peerAddress.equals(associationTemp.getPeerAddress()) && associationTemp.getPeerPort() == peerPort) {
                    throw new Exception(String.format("Already has association=%s with same peer address=%s and port=%d", associationTemp.getName(), peerAddress, peerPort));
                }
                if (!hostAddress.equals(associationTemp.getHostAddress()) || associationTemp.getHostPort() != hostPort) continue;
                throw new Exception(String.format("Already has association=%s with same host address=%s and port=%d", associationTemp.getName(), hostAddress, hostPort));
            }
            NettyAssociationImpl association = new NettyAssociationImpl(hostAddress, hostPort, peerAddress, peerPort, assocName, ipChannelType, extraHostAddresses);
            association.setManagement(this);
            AssociationMap<String, Association> newAssociations = new AssociationMap<String, Association>();
            newAssociations.putAll(this.associations);
            newAssociations.put(assocName, association);
            this.associations = newAssociations;
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationAdded(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationAdded", ee);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Added Associoation=%s of type=%s", new Object[]{association.getName(), association.getAssociationType()}));
            }
            return association;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            Association association = (Association)this.associations.get(assocName);
            if (association == null) {
                throw new Exception(String.format("No Association found for name=%s", assocName));
            }
            if (association.isStarted()) {
                throw new Exception(String.format("Association name=%s is started. Stop before removing", assocName));
            }
            AssociationMap<String, Association> newAssociations = new AssociationMap<String, Association>();
            newAssociations.putAll(this.associations);
            newAssociations.remove(assocName);
            this.associations = newAssociations;
            if (((NettyAssociationImpl)association).getAssociationType() == AssociationType.SERVER) {
                FastCollection.Record n = this.servers.head();
                FastCollection.Record end = this.servers.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    Server serverTemp = (Server)((FastList.Node)n).getValue();
                    if (!serverTemp.getName().equals(association.getServerName())) continue;
                    FastList<String> newAssociations2 = new FastList<String>();
                    newAssociations2.addAll(((NettyServerImpl)serverTemp).associations);
                    newAssociations2.remove(assocName);
                    ((NettyServerImpl)serverTemp).associations = newAssociations2;
                    break;
                }
            }
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationRemoved(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationRemoved", ee);
                }
            }
        }
    }

    @Override
    public Association getAssociation(String assocName) throws Exception {
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association associationTemp = (Association)this.associations.get(assocName);
        if (associationTemp == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        return associationTemp;
    }

    @Override
    public Map<String, Association> getAssociations() {
        HashMap<String, Association> routeTmp = new HashMap<String, Association>();
        routeTmp.putAll(this.associations);
        return routeTmp;
    }

    @Override
    public void startAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association associationTemp = (Association)this.associations.get(assocName);
        if (associationTemp == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        if (associationTemp.isStarted()) {
            throw new Exception(String.format("Association=%s is already started", assocName));
        }
        ((NettyAssociationImpl)associationTemp).start();
        this.store();
    }

    @Override
    public void stopAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association association = (Association)this.associations.get(assocName);
        if (association == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        ((NettyAssociationImpl)association).stop();
        this.store();
    }

    @Override
    public int getConnectDelay() {
        return this.connectDelay;
    }

    @Override
    public void setConnectDelay(int connectDelay) throws Exception {
        if (!this.started) {
            throw new Exception("ConnectDelay parameter can be updated only when SCTP stack is running");
        }
        this.connectDelay = connectDelay;
        this.store();
    }

    @Override
    public double getCongControl_DelayThreshold_1() {
        return this.congControl_DelayThreshold[0];
    }

    @Override
    public double getCongControl_DelayThreshold_2() {
        return this.congControl_DelayThreshold[1];
    }

    @Override
    public double getCongControl_DelayThreshold_3() {
        return this.congControl_DelayThreshold[2];
    }

    @Override
    public void setCongControl_DelayThreshold_1(double val) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_DelayThreshold parameter can be updated only when SCTP stack is running");
        }
        this.congControl_DelayThreshold[0] = val;
        this.store();
    }

    @Override
    public void setCongControl_DelayThreshold_2(double val) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_DelayThreshold parameter can be updated only when SCTP stack is running");
        }
        this.congControl_DelayThreshold[1] = val;
        this.store();
    }

    @Override
    public void setCongControl_DelayThreshold_3(double val) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_DelayThreshold parameter can be updated only when SCTP stack is running");
        }
        this.congControl_DelayThreshold[2] = val;
        this.store();
    }

    @Override
    public double getCongControl_BackToNormalDelayThreshold_1() {
        return this.congControl_BackToNormalDelayThreshold[0];
    }

    @Override
    public double getCongControl_BackToNormalDelayThreshold_2() {
        return this.congControl_BackToNormalDelayThreshold[1];
    }

    @Override
    public double getCongControl_BackToNormalDelayThreshold_3() {
        return this.congControl_BackToNormalDelayThreshold[2];
    }

    @Override
    public void setCongControl_BackToNormalDelayThreshold_1(double val) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_BackToNormalDelayThreshold parameter can be updated only when SCTP stack is running");
        }
        this.congControl_BackToNormalDelayThreshold[0] = val;
        this.store();
    }

    @Override
    public void setCongControl_BackToNormalDelayThreshold_2(double val) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_BackToNormalDelayThreshold parameter can be updated only when SCTP stack is running");
        }
        this.congControl_BackToNormalDelayThreshold[1] = val;
        this.store();
    }

    @Override
    public void setCongControl_BackToNormalDelayThreshold_3(double val) throws Exception {
        if (!this.started) {
            throw new Exception("CongControl_BackToNormalDelayThreshold parameter can be updated only when SCTP stack is running");
        }
        this.congControl_BackToNormalDelayThreshold[2] = val;
        this.store();
    }

    @Override
    public int getWorkerThreads() {
        return 1;
    }

    @Override
    public void setWorkerThreads(int workerThreads) throws Exception {
    }

    @Override
    public boolean isSingleThread() {
        return true;
    }

    @Override
    public void setSingleThread(boolean singleThread) throws Exception {
    }

    @Override
    public Boolean getOptionSctpDisableFragments() {
        return this.optionSctpDisableFragments;
    }

    @Override
    public void setOptionSctpDisableFragments(Boolean optionSctpDisableFragments) {
        this.optionSctpDisableFragments = optionSctpDisableFragments;
    }

    @Override
    public Integer getOptionSctpFragmentInterleave() {
        return this.optionSctpFragmentInterleave;
    }

    @Override
    public void setOptionSctpFragmentInterleave(Integer optionSctpFragmentInterleave) {
        this.optionSctpFragmentInterleave = optionSctpFragmentInterleave;
    }

    public SctpStandardSocketOptions.InitMaxStreams getOptionSctpInitMaxstreams() {
        if (this.optionSctpInitMaxstreams_MaxInStreams != null && this.optionSctpInitMaxstreams_MaxOutStreams != null) {
            return SctpStandardSocketOptions.InitMaxStreams.create(this.optionSctpInitMaxstreams_MaxInStreams, this.optionSctpInitMaxstreams_MaxOutStreams);
        }
        return null;
    }

    @Override
    public Integer getOptionSctpInitMaxstreams_MaxOutStreams() {
        return this.optionSctpInitMaxstreams_MaxOutStreams;
    }

    @Override
    public Integer getOptionSctpInitMaxstreams_MaxInStreams() {
        return this.optionSctpInitMaxstreams_MaxInStreams;
    }

    @Override
    public void setOptionSctpInitMaxstreams_MaxOutStreams(Integer val) {
        this.optionSctpInitMaxstreams_MaxOutStreams = val;
    }

    @Override
    public void setOptionSctpInitMaxstreams_MaxInStreams(Integer val) {
        this.optionSctpInitMaxstreams_MaxInStreams = val;
    }

    @Override
    public Boolean getOptionSctpNodelay() {
        return this.optionSctpNodelay;
    }

    @Override
    public void setOptionSctpNodelay(Boolean optionSctpNodelay) {
        this.optionSctpNodelay = optionSctpNodelay;
    }

    @Override
    public Integer getOptionSoSndbuf() {
        return this.optionSoSndbuf;
    }

    @Override
    public void setOptionSoSndbuf(Integer optionSoSndbuf) {
        this.optionSoSndbuf = optionSoSndbuf;
    }

    @Override
    public Integer getOptionSoRcvbuf() {
        return this.optionSoRcvbuf;
    }

    @Override
    public void setOptionSoRcvbuf(Integer optionSoRcvbuf) {
        this.optionSoRcvbuf = optionSoRcvbuf;
    }

    @Override
    public Integer getOptionSoLinger() {
        return this.optionSoLinger;
    }

    @Override
    public void setOptionSoLinger(Integer optionSoLinger) {
        this.optionSoLinger = optionSoLinger;
    }

    protected FastList<ManagementEventListener> getManagementEventListeners() {
        return this.managementEventListeners;
    }

    protected FastList<CongestionListener> getCongestionListeners() {
        return this.congestionListeners;
    }

    protected void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.load(reader);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    protected void load(XMLObjectReader reader) throws XMLStreamException {
        try {
            Integer vali = reader.read(CONNECT_DELAY_PROP, Integer.class);
            if (vali != null) {
                this.connectDelay = vali;
            }
            vali = reader.read(WORKER_THREADS_PROP, Integer.class);
            Boolean bl = reader.read(SINGLE_THREAD_PROP, Boolean.class);
        }
        catch (NullPointerException vali) {
            // empty catch block
        }
        Double valTH1 = reader.read(CONG_CONTROL_DELAY_THRESHOLD_1, Double.class);
        Double valTH2 = reader.read(CONG_CONTROL_DELAY_THRESHOLD_2, Double.class);
        Double valTH3 = reader.read(CONG_CONTROL_DELAY_THRESHOLD_3, Double.class);
        Double valTB1 = reader.read(CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_1, Double.class);
        Double valTB2 = reader.read(CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_2, Double.class);
        Double valTB3 = reader.read(CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_3, Double.class);
        if (valTH1 != null && valTH2 != null && valTH3 != null && valTB1 != null && valTB2 != null && valTB3 != null) {
            this.congControl_DelayThreshold = new double[3];
            this.congControl_DelayThreshold[0] = valTH1;
            this.congControl_DelayThreshold[1] = valTH2;
            this.congControl_DelayThreshold[2] = valTH3;
            this.congControl_BackToNormalDelayThreshold = new double[3];
            this.congControl_BackToNormalDelayThreshold[0] = valTB1;
            this.congControl_BackToNormalDelayThreshold[1] = valTB2;
            this.congControl_BackToNormalDelayThreshold[2] = valTB3;
        }
        this.servers = reader.read(SERVERS, FastList.class);
        FastCollection.Record n = this.servers.head();
        FastMap.Entry end = this.servers.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            Server serverTemp = (Server)((FastList.Node)n).getValue();
            ((NettyServerImpl)serverTemp).setManagement(this);
            if (!serverTemp.isStarted()) continue;
            try {
                ((NettyServerImpl)serverTemp).start();
            }
            catch (Exception e) {
                logger.error(String.format("Error while initiating Server=%s", serverTemp.getName()), e);
            }
        }
        this.associations = reader.read(ASSOCIATIONS, AssociationMap.class);
        n = this.associations.head();
        end = this.associations.tail();
        while ((n = ((FastMap.Entry)n).getNext()) != end) {
            NettyAssociationImpl associationTemp = (NettyAssociationImpl)((FastMap.Entry)n).getValue();
            associationTemp.setManagement(this);
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.connectDelay, CONNECT_DELAY_PROP, Integer.class);
            if (this.congControl_DelayThreshold != null && this.congControl_DelayThreshold.length == 3) {
                writer.write(this.congControl_DelayThreshold[0], CONG_CONTROL_DELAY_THRESHOLD_1, Double.class);
                writer.write(this.congControl_DelayThreshold[1], CONG_CONTROL_DELAY_THRESHOLD_2, Double.class);
                writer.write(this.congControl_DelayThreshold[2], CONG_CONTROL_DELAY_THRESHOLD_3, Double.class);
            }
            if (this.congControl_BackToNormalDelayThreshold != null && this.congControl_BackToNormalDelayThreshold.length == 3) {
                writer.write(this.congControl_BackToNormalDelayThreshold[0], CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_1, Double.class);
                writer.write(this.congControl_BackToNormalDelayThreshold[1], CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_2, Double.class);
                writer.write(this.congControl_BackToNormalDelayThreshold[2], CONG_CONTROL_BACK_TO_NORMAL_DELAY_THRESHOLD_3, Double.class);
            }
            writer.write(this.servers, SERVERS, FastList.class);
            writer.write(this.associations, ASSOCIATIONS, AssociationMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error("Error while persisting the Rule state in file", e);
        }
    }

    @Override
    public int getBufferSize() {
        return 0;
    }

    @Override
    public void setBufferSize(int bufferSize) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyServer(String serverName, String hostAddress, Integer port, IpChannelType ipChannelType, Boolean acceptAnonymousConnections, Integer maxConcurrentConnectionsCount, String[] extraHostAddresses) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s MUST be started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (port != null && (port < 1 || port > 65535)) {
            throw new Exception("Server host port cannot be less than 1 or more than 65535. But was : " + port);
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            NettyServerImpl modifyServer = null;
            FastCollection.Record n = this.servers.head();
            FastCollection.Record end = this.servers.tail();
            while ((n = ((FastList.Node)n).getNext()) != end) {
                NettyServerImpl currServer = (NettyServerImpl)((FastList.Node)n).getValue();
                if (!serverName.equals(currServer.getName())) continue;
                if (currServer.isStarted()) {
                    throw new Exception(String.format("Server=%s is started. Stop the server before modifying", serverName));
                }
                if (hostAddress != null) {
                    currServer.setHostAddress(hostAddress);
                }
                if (port != null) {
                    currServer.setHostport(port);
                }
                if (ipChannelType != null) {
                    currServer.setIpChannelType(ipChannelType);
                }
                if (acceptAnonymousConnections != null) {
                    currServer.setAcceptAnonymousConnections(acceptAnonymousConnections);
                }
                if (maxConcurrentConnectionsCount != null) {
                    currServer.setMaxConcurrentConnectionsCount(maxConcurrentConnectionsCount);
                }
                if (extraHostAddresses != null) {
                    currServer.setExtraHostAddresses(extraHostAddresses);
                }
                modifyServer = currServer;
                break;
            }
            if (modifyServer == null) {
                throw new Exception(String.format("No Server found for modifying with name=%s", serverName));
            }
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onServerModified(modifyServer);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onServerModified", ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyServerAssociation(String assocName, String peerAddress, Integer peerPort, String serverName, IpChannelType ipChannelType) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        if (peerPort != null && (peerPort < 1 || peerPort > 65535)) {
            throw new Exception("Peer port cannot be less than 1 or more than 65535. But was : " + peerPort);
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            NettyAssociationImpl association = (NettyAssociationImpl)this.associations.get(assocName);
            if (association == null) {
                throw new Exception(String.format("No Association found for name=%s", assocName));
            }
            FastCollection.Record n = this.associations.head();
            FastCollection.Record end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                Association associationTemp = (Association)((FastMap.Entry)n).getValue();
                if (peerAddress == null || !peerAddress.equals(associationTemp.getPeerAddress()) || associationTemp.getPeerPort() != peerPort.intValue()) continue;
                throw new Exception(String.format("Already has association=%s with same peer address=%s and port=%d", associationTemp.getName(), peerAddress, peerPort));
            }
            if (peerAddress != null) {
                association.setPeerAddress(peerAddress);
            }
            if (peerPort != null) {
                association.setPeerPort(peerPort);
            }
            if (serverName != null && !serverName.equals(association.getServerName())) {
                Server serverTemp;
                Server newServer = null;
                FastCollection.Record n2 = this.servers.head();
                FastCollection.Record end2 = this.servers.tail();
                while ((n2 = ((FastList.Node)n2).getNext()) != end2) {
                    serverTemp = (Server)((FastList.Node)n2).getValue();
                    if (!serverTemp.getName().equals(serverName)) continue;
                    newServer = serverTemp;
                }
                if (newServer == null) {
                    throw new Exception(String.format("No Server found for name=%s", serverName));
                }
                if (ipChannelType != null && newServer.getIpChannelType() != ipChannelType || ipChannelType == null && newServer.getIpChannelType() != association.getIpChannelType()) {
                    throw new Exception(String.format("Server and Accociation has different IP channel type", new Object[0]));
                }
                n2 = this.servers.head();
                end2 = this.servers.tail();
                while ((n2 = ((FastList.Node)n2).getNext()) != end2) {
                    serverTemp = (Server)((FastList.Node)n2).getValue();
                    if (!serverTemp.getName().equals(association.getServerName())) continue;
                    FastList<String> newAssociations2 = new FastList<String>();
                    newAssociations2.addAll(((NettyServerImpl)serverTemp).associations);
                    newAssociations2.remove(assocName);
                    ((NettyServerImpl)serverTemp).associations = newAssociations2;
                    break;
                }
                FastList<String> newAssociations2 = new FastList<String>();
                newAssociations2.addAll(((NettyServerImpl)newServer).associations);
                newAssociations2.add(assocName);
                ((NettyServerImpl)newServer).associations = newAssociations2;
                association.setServerName(serverName);
            } else if (ipChannelType != null) {
                n = this.servers.head();
                end = this.servers.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    Server serverTemp = (Server)((FastList.Node)n).getValue();
                    if (!serverTemp.getName().equals(association.getServerName()) || serverTemp.getIpChannelType() == ipChannelType) continue;
                    throw new Exception(String.format("Server and Accociation has different IP channel type", new Object[0]));
                }
                association.setIpChannelType(ipChannelType);
            }
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationModified(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationModified", ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyAssociation(String hostAddress, Integer hostPort, String peerAddress, Integer peerPort, String assocName, IpChannelType ipChannelType, String[] extraHostAddresses) throws Exception {
        boolean isModified = false;
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (hostPort != null && (hostPort < 1 || hostPort > 65535)) {
            throw new Exception("Host port cannot be less than 1 or more than 65535. But was : " + hostPort);
        }
        if (peerPort != null && (peerPort < 1 || peerPort > 65535)) {
            throw new Exception("Peer port cannot be less than 1 or more than 65535. But was : " + peerPort);
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        NettySctpManagementImpl nettySctpManagementImpl = this;
        synchronized (nettySctpManagementImpl) {
            FastCollection.Record n = this.associations.head();
            FastMap.Entry end = this.associations.tail();
            while ((n = ((FastMap.Entry)n).getNext()) != end) {
                Association associationTemp = (Association)((FastMap.Entry)n).getValue();
                if (peerAddress != null && peerAddress.equals(associationTemp.getPeerAddress()) && associationTemp.getPeerPort() == peerPort.intValue()) {
                    throw new Exception(String.format("Already has association=%s with same peer address=%s and port=%d", associationTemp.getName(), peerAddress, peerPort));
                }
                if (hostAddress == null || !hostAddress.equals(associationTemp.getHostAddress()) || associationTemp.getHostPort() != hostPort.intValue()) continue;
                throw new Exception(String.format("Already has association=%s with same host address=%s and port=%d", associationTemp.getName(), hostAddress, hostPort));
            }
            NettyAssociationImpl association = (NettyAssociationImpl)this.associations.get(assocName);
            if (hostAddress != null) {
                association.setHostAddress(hostAddress);
                isModified = true;
            }
            if (hostPort != null) {
                association.setHostPort(hostPort);
                isModified = true;
            }
            if (peerAddress != null) {
                association.setPeerAddress(peerAddress);
                isModified = true;
            }
            if (peerPort != null) {
                association.setPeerPort(peerPort);
                isModified = true;
            }
            if (ipChannelType != null) {
                association.setIpChannelType(ipChannelType);
                isModified = true;
            }
            if (extraHostAddresses != null) {
                association.setExtraHostAddresses(extraHostAddresses);
                isModified = true;
            }
            if (association.isConnected() && isModified) {
                association.stop();
                association.start();
            }
            this.store();
            for (ManagementEventListener lstr : this.managementEventListeners) {
                try {
                    lstr.onAssociationModified(association);
                }
                catch (Throwable ee) {
                    logger.error("Exception while invoking onAssociationModified", ee);
                }
            }
        }
    }
}

