/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.jmxss7;

import java.util.List;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListener;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmListenerCollection;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMediator;
import org.mobicents.protocols.ss7.oam.common.alarm.AlarmMessage;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmList;
import org.mobicents.protocols.ss7.oam.common.alarm.CurrentAlarmListImpl;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHostImpl;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanLayer;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanType;
import org.mobicents.protocols.ss7.oam.common.jmxss7.Ss7ManagementMBean;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterProviderManagement;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterMediator;

public class Ss7Management
extends MBeanHostImpl
implements Ss7ManagementMBean,
AlarmMediator,
AlarmListener {
    protected final Logger logger = Logger.getLogger(Ss7Management.class.getCanonicalName());
    private AlarmListenerCollection alc = new AlarmListenerCollection();
    private List<AlarmMediator> alarmMediators = new FastList<AlarmMediator>();
    private CounterProviderManagement counterProvider;
    private FastMap<String, CounterMediator> counterMediatorsRegistered = new FastMap();

    public Ss7Management() {
        this.setAlarmProviderObjectPath("SS7_Alarms");
    }

    public void start() {
        this.logger.info("Starting ...");
        super.start();
        this.counterProvider = null;
        this.counterMediatorsRegistered.clear();
        this.logger.info("Started ...");
    }

    public void stop() {
        this.logger.info("Stoping ...");
        super.stop();
        this.logger.info("Stoped ...");
    }

    public void registerMBean(MBeanLayer layer, MBeanType type, String name, Object bean) {
        super.registerMBean(layer, type, name, bean);
        if (bean instanceof AlarmMediator) {
            AlarmMediator am = (AlarmMediator)bean;
            am.registerAlarmListener(this);
            this.registerAlarmMediator(am);
        }
        if (bean instanceof CounterProviderManagement) {
            CounterProviderManagement cp;
            this.counterProvider = cp = (CounterProviderManagement)bean;
            for (CounterMediator cm : this.counterMediatorsRegistered.values()) {
                cp.registerCounterMediator(cm);
            }
        }
        if (bean instanceof CounterMediator) {
            CounterMediator cm = (CounterMediator)bean;
            if (this.counterProvider != null) {
                this.counterProvider.registerCounterMediator(cm);
            }
            this.counterMediatorsRegistered.put(cm.getCounterMediatorName(), cm);
        }
        this.logger.info("Registered MBean: " + name);
    }

    public Object unregisterMBean(MBeanLayer layer, MBeanType type, String name) {
        Object bean = super.unregisterMBean(layer, type, name);
        if (bean instanceof AlarmMediator) {
            AlarmMediator am = (AlarmMediator)bean;
            am.unregisterAlarmListener(this);
            this.unregisterAlarmMediator(am);
        }
        if (bean instanceof CounterProviderManagement) {
            this.counterProvider = null;
        }
        if (bean instanceof CounterMediator) {
            CounterMediator cm = (CounterMediator)bean;
            if (this.counterProvider != null) {
                this.counterProvider.unRegisterCounterMediator(cm);
            }
            this.counterMediatorsRegistered.remove(cm.getCounterMediatorName());
        }
        this.logger.info("Unregistered MBean: " + name);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlarmMediator(AlarmMediator am) {
        List<AlarmMediator> list = this.alarmMediators;
        synchronized (list) {
            this.alarmMediators.add(am);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAlarmMediator(AlarmMediator am) {
        List<AlarmMediator> list = this.alarmMediators;
        synchronized (list) {
            this.alarmMediators.remove(am);
        }
    }

    public void registerAlarmListener(AlarmListener listener) {
        this.alc.registerAlarmListener(listener);
    }

    public void unregisterAlarmListener(AlarmListener listener) {
        this.alc.unregisterAlarmListener(listener);
    }

    public String getAlarmProviderObjectPath() {
        return this.alc.getAlarmProviderObjectPath();
    }

    public void setAlarmProviderObjectPath(String value) {
        this.alc.setAlarmProviderObjectPath(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrentAlarmList getCurrentAlarmList() {
        CurrentAlarmListImpl al = new CurrentAlarmListImpl();
        List<AlarmMediator> list = this.alarmMediators;
        synchronized (list) {
            for (AlarmMediator amr : this.alarmMediators) {
                CurrentAlarmList temp = amr.getCurrentAlarmList();
                for (AlarmMessage alm : temp.getCurrentAlarmList()) {
                    this.alc.prepareAlarm(alm);
                    al.addAlarm(alm);
                }
            }
        }
        al.sortAlarms();
        return al;
    }

    public void onAlarm(AlarmMessage alarm) {
        this.alc.onAlarm(alarm);
    }
}

