/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mobicents.protocols.ss7.map.api.primitives.Time;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;

public class TimeImpl
extends OctetStringBase
implements Time {
    private static final long msbZero = 2085978496000L;
    private static final long msbOne = -2208988800000L;

    public TimeImpl() {
        super(4, 4, "Time");
    }

    public TimeImpl(byte[] data) {
        super(4, 4, "Time", data);
    }

    public TimeImpl(int year, int month, int day, int hour, int minute, int second) {
        super(4, 4, "Time");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(year, month - 1, day, hour, minute, second);
        long ntpTime = this.getNtpTime(cal.getTimeInMillis());
        this.data = new byte[4];
        System.arraycopy(this.longToBytes(ntpTime), 4, this.data, 0, 4);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getYear() {
        long time = this.bytesToLong(this.data);
        time = this.getTime(time);
        Date d = new Date(time);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        return cal.get(1);
    }

    public int getMonth() {
        long time = this.bytesToLong(this.data);
        time = this.getTime(time);
        Date d = new Date(time);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        return cal.get(2) + 1;
    }

    public int getDay() {
        long time = this.bytesToLong(this.data);
        time = this.getTime(time);
        Date d = new Date(time);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        return cal.get(5);
    }

    public int getHour() {
        long time = this.bytesToLong(this.data);
        time = this.getTime(time);
        Date d = new Date(time);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        return cal.get(11);
    }

    public int getMinute() {
        long time = this.bytesToLong(this.data);
        time = this.getTime(time);
        Date d = new Date(time);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        return cal.get(12);
    }

    public int getSecond() {
        long time = this.bytesToLong(this.data);
        time = this.getTime(time);
        Date d = new Date(time);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(d);
        return cal.get(13);
    }

    private long getNtpTime(long time) {
        boolean isMSBSet = time < 2085978496000L;
        long timeWithMills = isMSBSet ? time - -2208988800000L : time - 2085978496000L;
        long seconds = timeWithMills / 1000L;
        if (isMSBSet) {
            seconds |= 0x80000000L;
        }
        return seconds;
    }

    public long getTime(long ntpTime) {
        long msb = ntpTime & 0x80000000L;
        if (msb == 0L) {
            return 2085978496000L + ntpTime * 1000L;
        }
        return -2208988800000L + ntpTime * 1000L;
    }

    public byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        byte[] eightbytes = new byte[8];
        System.arraycopy(bytes, 0, eightbytes, 4, 4);
        buffer.put(eightbytes);
        buffer.flip();
        return buffer.getLong();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("year=");
            sb.append(this.getYear());
            sb.append(", month=");
            sb.append(this.getMonth());
            sb.append(", day=");
            sb.append(this.getDay());
            sb.append(", hour=");
            sb.append(this.getHour());
            sb.append(", minite=");
            sb.append(this.getMinute());
            sb.append(", second=");
            sb.append(this.getSecond());
        }
        sb.append("]");
        return sb.toString();
    }
}

