/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.parameter;

import java.util.Arrays;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.AffectedPointCode;

public class AffectedPointCodeImpl
extends ParameterImpl
implements AffectedPointCode {
    private byte[] value;
    private int[] pointCodes;
    private short[] masks;

    protected AffectedPointCodeImpl(byte[] value) {
        this.tag = (short)18;
        int count = 0;
        int arrSize = 0;
        this.pointCodes = new int[value.length / 4];
        this.masks = new short[value.length / 4];
        while (count < value.length) {
            this.masks[arrSize] = value[count++];
            this.pointCodes[arrSize] = 0;
            int n = arrSize;
            this.pointCodes[n] = this.pointCodes[n] | value[count++] & 0xFF;
            int n2 = arrSize;
            this.pointCodes[n2] = this.pointCodes[n2] << 8;
            int n3 = arrSize;
            this.pointCodes[n3] = this.pointCodes[n3] | value[count++] & 0xFF;
            int n4 = arrSize;
            this.pointCodes[n4] = this.pointCodes[n4] << 8;
            int n5 = arrSize++;
            this.pointCodes[n5] = this.pointCodes[n5] | value[count++] & 0xFF;
        }
        this.value = value;
    }

    protected AffectedPointCodeImpl(int[] pointCodes, short[] masks) {
        this.tag = (short)18;
        this.pointCodes = pointCodes;
        this.masks = masks;
        this.encode();
    }

    private void encode() {
        this.value = new byte[this.pointCodes.length * 4];
        int count = 0;
        int arrSize = 0;
        while (count < this.value.length) {
            this.value[count++] = (byte)this.masks[arrSize];
            this.value[count++] = (byte)(this.pointCodes[arrSize] >>> 16);
            this.value[count++] = (byte)(this.pointCodes[arrSize] >>> 8);
            this.value[count++] = (byte)this.pointCodes[arrSize++];
        }
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    @Override
    public short[] getMasks() {
        return this.masks;
    }

    @Override
    public int[] getPointCodes() {
        return this.pointCodes;
    }

    public String toString() {
        return String.format("AffectedPointCode pointCode=%s mask=%s", Arrays.toString(this.pointCodes), Arrays.toString(this.masks));
    }
}

